/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur12;

import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.ur10.RobotTypeSupportUR10;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR10UR12Impl
implements PayloadAndCogWarningCalculator,
RobotTypeSupportUR10 {
    private final PayloadAndCogWarningCalculatorHelper calculationHelper;

    @Inject
    public PayloadAndCogWarningCalculatorUR10UR12Impl(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.calculationHelper = payloadAndCogWarningCalculatorHelper;
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.calculationHelper.isBelowWeightLimit(mass, 12.5) && this.calculationHelper.isBelowLengthLimit(cogDistance, 0.8) && (this.calculationHelper.isBelowSlopedLimit(mass, cogDistance, new Point2d(0.11, 12.5), new Point2d(0.15, 10.0)) || this.calculationHelper.isBelowSlopedLimit(mass, cogDistance, new Point2d(0.15, 10.0), new Point2d(0.8, 5.0)));
    }

    @Override
    public boolean supportsRobotType(int robotTypeId, int robotSubTypeId) {
        return this.supportsRobotType(robotTypeId) && (robotSubTypeId == 2 || robotSubTypeId == 1);
    }
}

