/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur15;

import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadValidationFunctionFactory;
import com.ur.polyscope.robot.configuration.internal.ur15.RobotTypeSupportUR15;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR15
implements PayloadAndCogWarningCalculator,
RobotTypeSupportUR15 {
    private static final Point2d[] SLOPE = new Point2d[]{new Point2d(0.0, 17.5), new Point2d(0.1, 17.5), new Point2d(0.2, 16.0), new Point2d(0.4, 11.0), new Point2d(0.8, 7.0)};
    private final PayloadValidationFunctionFactory.ValidPayloadFunction validPayloadFunction;

    @Inject
    public PayloadAndCogWarningCalculatorUR15(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.validPayloadFunction = PayloadValidationFunctionFactory.create(payloadAndCogWarningCalculatorHelper, SLOPE);
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.validPayloadFunction.isBelowWeightLimit(mass, cogDistance);
    }
}

