/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur16;

import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.ur16.RobotTypeSupportUR16;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR16Impl
implements PayloadAndCogWarningCalculator,
RobotTypeSupportUR16 {
    private final PayloadAndCogWarningCalculatorHelper calculationHelper;

    @Inject
    public PayloadAndCogWarningCalculatorUR16Impl(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.calculationHelper = payloadAndCogWarningCalculatorHelper;
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.calculationHelper.isBelowWeightLimit(mass, 16.0) && this.calculationHelper.isBelowLengthLimit(cogDistance, 0.8) && this.calculationHelper.isBelowSlopedLimitNoPreCheck(mass, cogDistance, new Point2d(0.12, 16.0), new Point2d(0.155, 15.5)) && this.approximateSlope(mass, cogDistance);
    }

    private boolean approximateSlope(Weight mass, Length cogDistance) {
        return this.calculationHelper.isBelowSlopedLimitNoPreCheck(mass, cogDistance, new Point2d(0.155, 15.5), new Point2d(0.2, 13.2)) || this.calculationHelper.isBelowSlopedLimitNoPreCheck(mass, cogDistance, new Point2d(0.2, 13.2), new Point2d(0.4, 8.0)) || this.calculationHelper.isBelowSlopedLimitNoPreCheck(mass, cogDistance, new Point2d(0.4, 8.0), new Point2d(0.6, 6.0)) || this.calculationHelper.isBelowSlopedLimitNoPreCheck(mass, cogDistance, new Point2d(0.6, 6.0), new Point2d(0.8, 4.5));
    }
}

