/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur20;

import com.ur.polyscope.robot.configuration.contribution.RobotTypeSupport;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadValidationFunctionFactory;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.view.constants.dev.robotsize.RobotType;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR20Impl
implements RobotTypeSupport,
PayloadAndCogWarningCalculator {
    public static final Point2d[] SLOPE = new Point2d[]{new Point2d(0.0, 25.0), new Point2d(0.2, 25.0), new Point2d(0.4, 16.0), new Point2d(0.8, 8.0)};
    private final PayloadValidationFunctionFactory.ValidPayloadFunction payloadValidator;

    @Inject
    public PayloadAndCogWarningCalculatorUR20Impl(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.payloadValidator = PayloadValidationFunctionFactory.create(payloadAndCogWarningCalculatorHelper, SLOPE);
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.payloadValidator.isBelowWeightLimit(mass, cogDistance);
    }

    public boolean supportsRobotType(int robotType) {
        return robotType == RobotType.UR20.getId();
    }
}

