/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur20;

import com.ur.polyscope.robot.configuration.contribution.RobotTypeSupport;
import com.ur.polyscope.robot.configuration.visualization.SingularityVisualizationConfiguration;
import com.ur.view.constants.dev.robotsize.RobotType;
import javax.vecmath.Vector3d;

public class SingularityVisualizationUR20Impl
implements RobotTypeSupport,
SingularityVisualizationConfiguration {
    private static final float ELBOW_CYLINDER_RADIUS = 0.1f;
    private static final float ELBOW_CYLINDER_LENGTH = 0.38f;
    private static final Vector3d ELBOW_CYLINDER_OFFSET = new Vector3d(0.0, 0.0, (double)0.14f);
    private static final float HEAD_CYLINDER_RADIUS = 0.35f;
    private static final float HEAD_CYLINDER_LENGTH = 3.5f;
    private static final float WRIST_CYLINDER_RADIUS = 0.065f;
    private static final float WRIST_CYLINDER_LENGTH = 0.35f;
    private static final Vector3d WRIST3_CYLINDER_OFFSET = new Vector3d(0.0, 0.0, (double)0.04f);
    private static final Vector3d WRIST1_CYLINDER_OFFSET = new Vector3d(0.0, 0.0, (double)0.1f);

    public boolean supportsRobotType(int robotType) {
        return robotType == RobotType.UR20.getId();
    }

    public float getElbowCylinderRadius() {
        return 0.1f;
    }

    public float getElbowCylinderLength() {
        return 0.38f;
    }

    public Vector3d getElbowCylinderTranslation() {
        return ELBOW_CYLINDER_OFFSET;
    }

    public float getHeadCylinderRadius() {
        return 0.35f;
    }

    public float getHeadCylinderLength() {
        return 3.5f;
    }

    public float getWristCylinderRadius() {
        return 0.065f;
    }

    public float getWristCylinderLength() {
        return 0.35f;
    }

    public Vector3d getWrist1Translation() {
        return WRIST1_CYLINDER_OFFSET;
    }

    public Vector3d getWrist3Translation() {
        return WRIST3_CYLINDER_OFFSET;
    }
}

