/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur30;

import com.ur.polyscope.robot.configuration.contribution.RobotTypeSupport;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadValidationFunctionFactory;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.view.constants.dev.robotsize.RobotType;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR30Impl
implements RobotTypeSupport,
PayloadAndCogWarningCalculator {
    public static final Point2d[] SLOPE = new Point2d[]{new Point2d(0.0, 35.0), new Point2d(0.1, 35.0), new Point2d(0.2, 25.0), new Point2d(0.3, 20.0), new Point2d(0.4000000001, 16.0), new Point2d(0.6, 12.0), new Point2d(0.8, 10.0)};
    private final PayloadValidationFunctionFactory.ValidPayloadFunction validPayloadFunction;

    @Inject
    public PayloadAndCogWarningCalculatorUR30Impl(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.validPayloadFunction = PayloadValidationFunctionFactory.create(payloadAndCogWarningCalculatorHelper, SLOPE);
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.validPayloadFunction.isBelowWeightLimit(mass, cogDistance);
    }

    public boolean supportsRobotType(int robotType) {
        return robotType == RobotType.UR30.getId();
    }
}

