/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur30;

import com.ur.polyscope.robot.configuration.internal.RobotTypeContribution;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumber;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.view.constants.dev.TPType;
import com.ur.view.constants.dev.robotsize.JointSize;
import com.ur.view.constants.dev.robotsize.RobotType;
import javax.inject.Singleton;

@Singleton
public class RobotTypeUR30
implements RobotTypeContribution,
TPCapable {
    private static final int SERIAL_NUMBER_IDENTIFIER = 9;
    private static final int[] JOINT_SIZES_UR30 = new int[]{JointSize.SIZE5.getId(), JointSize.SIZE5.getId(), JointSize.SIZE4.getId(), JointSize.SIZE2_5.getId(), JointSize.SIZE2_5.getId(), JointSize.SIZE2_5.getId()};

    @Override
    public int[] getJointIdsForRobotType() {
        return (int[])JOINT_SIZES_UR30.clone();
    }

    @Override
    public int getRobotTypeIdFromController(SerialNumber serialNumber) {
        if (serialNumber.getSubType() == 9) {
            return RobotType.UR30.getId();
        }
        return -1;
    }

    @Override
    public boolean isAllowedOnG3() {
        return false;
    }

    @Override
    public boolean supportsRobotType(int robotType) {
        return robotType == RobotType.UR30.getId();
    }

    @Override
    public int getSerialNumberIdentifier() {
        return 9;
    }

    public TPType[] getSupportedTeachPendents() {
        return new TPType[]{TPType.NONE, TPType.THREE_POSITION_ENABLING};
    }

    public TPType getDefaultTeachPendent() {
        return TPType.THREE_POSITION_ENABLING;
    }

    public boolean requires3PEConfigured() {
        return true;
    }
}

