/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.ur7;

import com.ur.polyscope.robot.configuration.internal.payload.PayloadAndCogWarningCalculatorHelper;
import com.ur.polyscope.robot.configuration.internal.payload.PayloadValidationFunctionFactory;
import com.ur.polyscope.robot.configuration.internal.ur5.RobotTypeSupportUR5;
import com.ur.polyscope.robot.configuration.payload.PayloadAndCogWarningCalculator;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Weight;
import javax.inject.Inject;
import javax.vecmath.Point2d;

public class PayloadAndCogWarningCalculatorUR7Impl
implements PayloadAndCogWarningCalculator,
RobotTypeSupportUR5 {
    public static final Point2d[] SLOPE = new Point2d[]{new Point2d(0.0, 7.5), new Point2d(0.15, 7.5), new Point2d(0.225, 7.0), new Point2d(0.6, 3.3)};
    private final PayloadValidationFunctionFactory.ValidPayloadFunction validPayloadFunction;

    @Inject
    public PayloadAndCogWarningCalculatorUR7Impl(PayloadAndCogWarningCalculatorHelper payloadAndCogWarningCalculatorHelper) {
        this.validPayloadFunction = PayloadValidationFunctionFactory.create(payloadAndCogWarningCalculatorHelper, SLOPE);
    }

    public boolean isPayloadAndCogValid(Weight mass, Length cogDistance) {
        return this.validPayloadFunction.isBelowWeightLimit(mass, cogDistance);
    }

    @Override
    public boolean supportsRobotType(int robotTypeId, int subTypeId) {
        return this.isUR7(robotTypeId, subTypeId);
    }
}

