/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Cylinder;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouse;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouseFoot;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouseFootProvider;
import com.ur.polyscope.robot.configuration.internal.visualization.Link;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.view.constants.dev.robotsize.JointSize;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

class FirstLink
extends Link {
    FirstLink(TransformGroup parent, DH dh, RobotAppearance robotAppearance, VisualizationType visualizationType, JointSize jointSize, JointHouseFootProvider footProvider) {
        super(parent, dh);
        if (visualizationType.isReal()) {
            JointHouseFoot baseFoot = footProvider.getFoot(jointSize, robotAppearance, this);
            this.addChild((Node)new JointHouse(baseFoot.getJointSize(), robotAppearance, visualizationType));
            parent.addChild((Node)((TransformGroup)baseFoot));
            this.addPowerCable(parent, baseFoot, robotAppearance, baseFoot.getXoffsetFootCable(baseFoot.getJointSize()));
        }
    }

    private void addPowerCable(TransformGroup parent, JointHouseFoot baseFoot, RobotAppearance robotAppearance, float offsetCable) {
        Transform3D linkTransform = new Transform3D(this.T);
        Transform3D cableTransform = new Transform3D();
        Vector3d position = new Vector3d(0.0, -baseFoot.getFootBaseYOffset(), (double)(JointHouse.getRadius(baseFoot.getJointSize()) - JointHouse.getHouseHeight(baseFoot.getJointSize()) - offsetCable));
        Matrix3d rotation = new Matrix3d();
        rotation.rotX(1.5707963267948966);
        cableTransform.set(rotation, position, 1.0);
        linkTransform.mul(cableTransform);
        TransformGroup transformGroup = new TransformGroup(linkTransform);
        float POWER_CABLE_CYL_LENGTH = 0.04f;
        float POWER_CABLE_CYL_RADIUS = 0.009f;
        transformGroup.addChild((Node)new Cylinder(POWER_CABLE_CYL_RADIUS, POWER_CABLE_CYL_LENGTH, robotAppearance.metalAppearance()));
        parent.addChild((Node)transformGroup);
    }
}

