/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Cylinder;
import com.ur.polyscope.robot.configuration.contribution.JointSizeContribution;
import com.ur.polyscope.robot.configuration.internal.visualization.Link;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.robotsize.JointSize;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class JointHouse
extends TransformGroup {
    private static final float CAP_HEIGHT = 0.01f;
    private static final float JOINT_SIZE_0_RADIUS = 0.03f;
    private static final float JOINT_SIZE_1_RADIUS = 0.0375f;
    private static final float JOINT_SIZE_2_RADIUS = 0.045f;
    private static final float JOINT_SIZE_2_5_RADIUS = 0.053f;
    private static final float JOINT_SIZE_3_RADIUS = 0.058f;
    private static final float JOINT_SIZE_4_RADIUS = 0.075f;
    private static final float JOINT_SIZE_5_RADIUS = 0.09f;
    private static Set<JointSizeContribution> jointSizeContributions;

    JointHouse(JointSize size, RobotAppearance robotAppearance, VisualizationType visualizationType) {
        try {
            Cylinder house = new Cylinder(JointHouse.getRadius(size), JointHouse.getHouseHeight(size), robotAppearance.metalAppearance());
            Transform3D houseTransform = new Transform3D();
            houseTransform.setTranslation(new Vector3d(0.0, this.getHouseOffset(size), 0.0));
            this.addNode((Node)house, houseTransform);
            Cylinder side = new Cylinder(JointHouse.getRadius(size), JointHouse.getSideHeight(size), robotAppearance.metalAppearance());
            Matrix3d sideRot = new Matrix3d();
            sideRot.rotX(1.5707963267948966);
            Vector3d sidePos = new Vector3d(0.0, 0.0, (double)(JointHouse.getSideHeight(size) / 2.0f));
            Transform3D sideTransform = new Transform3D(sideRot, sidePos, 1.0);
            this.addNode((Node)side, sideTransform);
            if (visualizationType.isReal()) {
                Cylinder cap = new Cylinder(JointHouse.getRadius(size), JointHouse.getCapHeight(size), robotAppearance.bluePlasticAppearance());
                Transform3D capTransform = new Transform3D();
                capTransform.setTranslation(new Vector3d(0.0, (double)JointHouse.getCapOffset(size), 0.0));
                this.addNode((Node)cap, capTransform);
            }
        }
        catch (Exception e) {
            Log.error((String)"Could not create joint house", (Throwable)e);
        }
    }

    @Inject
    public static void setJointSizeContributions(Set<JointSizeContribution> jointSizeContributions) {
        JointHouse.jointSizeContributions = jointSizeContributions;
    }

    protected void addNode(Node node, Transform3D transform) {
        TransformGroup tg = new TransformGroup(transform);
        tg.addChild(node);
        this.addChild((Node)tg);
    }

    public static float getHouseHeight(JointSize size) {
        return (float)(Link.getHeightTriplet(size)[0] + Link.getHeightTriplet(size)[1] - (double)JointHouse.getCapHeight(size));
    }

    private double getHouseOffset(JointSize size) {
        return (double)(JointHouse.getHouseHeight(size) / 2.0f) - Link.getHeightTriplet(size)[0];
    }

    public static float getSideHeight(JointSize size) {
        return (float)(Link.getHeightTriplet(size)[2] - Link.getHeightTriplet(size)[0]);
    }

    private static float getCapOffset(JointSize size) {
        return (float)(Link.getHeightTriplet(size)[1] - (double)(JointHouse.getCapHeight(size) / 2.0f));
    }

    public static float getHeight(JointSize size) {
        return (float)(Link.getHeightTriplet(size)[0] + Link.getHeightTriplet(size)[1]);
    }

    public static float getOffset(JointSize size) {
        return (float)((double)(JointHouse.getHeight(size) / 2.0f) - Link.getHeightTriplet(size)[0]);
    }

    public static float getRadius(JointSize jointSize) {
        switch (jointSize) {
            case SIZE0: {
                return 0.03f;
            }
            case SIZE1: {
                return 0.0375f;
            }
            case SIZE2: {
                return 0.045f;
            }
            case SIZE2_5: {
                return 0.053f;
            }
            case SIZE3: {
                return 0.058f;
            }
            case SIZE4: {
                return 0.075f;
            }
            case SIZE5: {
                return 0.09f;
            }
        }
        JointSizeContribution contribution = JointHouse.getContributionForSize(jointSize);
        if (contribution != null) {
            return contribution.getRadius();
        }
        throw new IllegalStateException("Unexpected enum value");
    }

    public static float getCapHeight(JointSize jointSize) {
        if (Arrays.asList(JointSize.values()).contains(jointSize)) {
            return 0.01f;
        }
        throw new IllegalStateException("Unexpected enum value");
    }

    private static JointSizeContribution getContributionForSize(JointSize jointSize) {
        for (JointSizeContribution contribution : jointSizeContributions) {
            if (!contribution.supportsJointSize(jointSize.getId())) continue;
            return contribution;
        }
        return null;
    }
}

