/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.ur.polyscope.robot.configuration.contribution.JointSizeContribution;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouse;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouseFoot;
import com.ur.polyscope.robot.configuration.internal.visualization.Link;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.robotsize.JointSize;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class JointHouseFootImpl
extends TransformGroup
implements JointHouseFoot {
    @Inject
    private static Set<JointSizeContribution> jointSizeContributions;
    protected float cylinderHeight;
    protected double footBaseCylYOffset;
    private JointSize size;

    public JointHouseFootImpl(JointSize size, RobotAppearance robotAppearance, Link link) {
        this.size = size;
        this.setHeight(size);
        this.createGeometry(size, robotAppearance, link, JointHouse.getCapHeight(size));
        try {
            float houseFootRadiusRatio = 1.5f;
            float outerRadiusSmall = JointHouse.getRadius(size);
            double outerRadiusLarge = (double)houseFootRadiusRatio * (double)outerRadiusSmall;
            float coneHeight = houseFootRadiusRatio * JointHouse.getHeight(size);
            double coneYOffset = -JointHouse.getHeight(size) / 2.0f + this.cylinderHeight;
            this.footBaseCylYOffset = JointHouse.getHeight(size) + this.cylinderHeight;
            Cone cone = new Cone((float)outerRadiusLarge, coneHeight, robotAppearance.metalAppearance());
            Transform3D coneTransform = new Transform3D();
            coneTransform.setTranslation(new Vector3d(0.0, coneYOffset, 0.0));
            this.addNode((Node)cone, coneTransform);
            Cylinder cylinder = new Cylinder((float)outerRadiusLarge, this.cylinderHeight, robotAppearance.metalAppearance());
            Transform3D houseTransform = new Transform3D();
            houseTransform.setTranslation(new Vector3d(0.0, -this.footBaseCylYOffset, 0.0));
            this.addNode((Node)cylinder, houseTransform);
        }
        catch (Exception e) {
            Log.error((String)"Could not create joint house foot", (Throwable)e);
        }
    }

    @Override
    public void createGeometry(JointSize size, RobotAppearance robotAppearance, Link link, double footYOffset) {
        this.footBaseCylYOffset = Link.getHeightTriplet(size)[1] + footYOffset;
        Cylinder cylinder = new Cylinder(JointHouse.getRadius(size), this.cylinderHeight, robotAppearance.metalAppearance());
        Transform3D houseTransform = new Transform3D();
        houseTransform.setTranslation(new Vector3d(0.0, -this.footBaseCylYOffset, 0.0));
        this.addNode((Node)cylinder, houseTransform);
        this.setLinkTransform(link);
    }

    @Override
    public void setHeight(JointSize size) {
        this.cylinderHeight = 0.15f * JointHouse.getHeight(size);
        if (size == JointSize.SIZE2) {
            this.cylinderHeight = 0.15f * JointHouse.getHeight(size);
        } else if (size == JointSize.SIZE3) {
            this.cylinderHeight = 0.13f * JointHouse.getHeight(size);
        } else if (size == JointSize.SIZE4) {
            this.cylinderHeight = 0.11f * JointHouse.getHeight(size);
        } else {
            JointSizeContribution contribution = this.getJointSizeContribution(size);
            if (contribution != null) {
                this.cylinderHeight = contribution.getCylinderHeightScalingFactor() * JointHouse.getHeight(size);
            }
        }
    }

    @Override
    public void setLinkTransform(Link link) {
        Transform3D linkTransform = new Transform3D();
        link.getTransform(linkTransform);
        this.setTransform(linkTransform);
    }

    @Override
    public void addNode(Node node, Transform3D transform) {
        TransformGroup tg = new TransformGroup(transform);
        tg.addChild(node);
        this.addChild((Node)tg);
    }

    @Override
    public double getFootBaseYOffset() {
        return this.footBaseCylYOffset;
    }

    @Override
    public JointSize getJointSize() {
        return this.size;
    }

    @Override
    public float getXoffsetFootCable(JointSize size) {
        if (size == JointSize.SIZE2) {
            return 0.0f;
        }
        if (size == JointSize.SIZE3) {
            return 0.02f;
        }
        if (size == JointSize.SIZE4) {
            return 0.04f;
        }
        JointSizeContribution contribution = this.getJointSizeContribution(size);
        if (contribution != null) {
            return contribution.getXoffsetFootCable();
        }
        return 0.0f;
    }

    private JointSizeContribution getJointSizeContribution(JointSize jointSize) {
        for (JointSizeContribution contribution : jointSizeContributions) {
            if (!contribution.supportsJointSize(jointSize.getId())) continue;
            return contribution;
        }
        return null;
    }
}

