/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Primitive;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.robot.configuration.contribution.JointSizeContribution;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.view.constants.dev.robotsize.JointSize;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

public abstract class Link
extends TransformGroup
implements JointPositionVector.LinkTransform {
    private static final double[] JOINT_SIZE_0_HEIGHT = new double[]{0.04735, 0.039, 0.08544};
    private static final double[] JOINT_SIZE_1_HEIGHT = new double[]{0.04825, 0.056985, 0.105};
    private static final double[] JOINT_SIZE_2_HEIGHT = new double[]{0.060402, 0.057218, 0.12};
    private static final double[] JOINT_SIZE_2_5_HEIGHT = new double[]{0.059, 0.056, 0.16};
    private static final double[] JOINT_SIZE_3_HEIGHT = new double[]{0.067, 0.068797, 0.134409};
    private static final double[] JOINT_SIZE_4_HEIGHT = new double[]{0.0887, 0.087202, 0.176};
    protected final DH dh;
    private static Set<JointSizeContribution> jointSizeContributions;
    protected double theta = Double.NaN;
    protected Transform3D T = new Transform3D();

    public Link(TransformGroup parent, DH dh) {
        this.dh = dh;
        this.setCapability(18);
        this.acceptCoordinateTransformation(0.0);
        parent.addChild((Node)this);
    }

    @Inject
    public static void setJointSizeContributions(Set<JointSizeContribution> jointSizeContributions) {
        Link.jointSizeContributions = jointSizeContributions;
    }

    public void acceptCoordinateTransformation(double theta) {
        if (Double.isNaN(theta) || this.theta == theta) {
            return;
        }
        this.theta = theta;
        this.dh.applyCoordinateTransformation(this.T, this.theta);
        this.setTransform(this.T);
    }

    public void addChild(Primitive prim, Transform3D t3d) {
        TransformGroup tg = new TransformGroup(t3d);
        tg.addChild((Node)prim);
        this.addChild((Node)tg);
    }

    static double[] getHeightTriplet(JointSize jointSize) {
        double[] result;
        switch (jointSize) {
            case SIZE0: {
                result = Arrays.copyOf(JOINT_SIZE_0_HEIGHT, JOINT_SIZE_0_HEIGHT.length);
                break;
            }
            case SIZE1: {
                result = Arrays.copyOf(JOINT_SIZE_1_HEIGHT, JOINT_SIZE_1_HEIGHT.length);
                break;
            }
            case SIZE2: {
                result = Arrays.copyOf(JOINT_SIZE_2_HEIGHT, JOINT_SIZE_2_HEIGHT.length);
                break;
            }
            case SIZE2_5: {
                result = Arrays.copyOf(JOINT_SIZE_2_5_HEIGHT, JOINT_SIZE_2_5_HEIGHT.length);
                break;
            }
            case SIZE3: {
                result = Arrays.copyOf(JOINT_SIZE_3_HEIGHT, JOINT_SIZE_3_HEIGHT.length);
                break;
            }
            case SIZE4: {
                result = Arrays.copyOf(JOINT_SIZE_4_HEIGHT, JOINT_SIZE_4_HEIGHT.length);
                break;
            }
            default: {
                result = Link.getHeightFromContributions(jointSize);
            }
        }
        return result;
    }

    private static double[] getHeightFromContributions(JointSize jointSize) {
        for (JointSizeContribution contribution : jointSizeContributions) {
            if (!contribution.supportsJointSize(jointSize.getId())) continue;
            return contribution.getHeightTriplet();
        }
        throw new IllegalStateException("Link: illegal joint size: " + jointSize);
    }
}

