/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouse;
import com.ur.polyscope.robot.configuration.internal.visualization.Link;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.view.constants.dev.robotsize.JointSize;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

class SecondLink
extends Link {
    SecondLink(TransformGroup parent, DH dh, RobotAppearance robotAppearance, VisualizationType visualizationType, JointSize sizeToUseHereA, JointSize sizeToUseHereB) {
        super(parent, dh);
        Matrix3d rotx = new Matrix3d();
        Matrix3d rotz = new Matrix3d();
        Vector3d pos = new Vector3d();
        JointHouse jointHouse1 = new JointHouse(sizeToUseHereA, robotAppearance, visualizationType);
        rotx.rotX(1.5707963267948966);
        rotz.rotZ(-1.5707963267948966);
        rotz.mul(rotx);
        pos.set(-dh.getA(), 0.0, SecondLink.getHeightTriplet(sizeToUseHereA)[2]);
        jointHouse1.setTransform(new Transform3D(rotz, pos, 1.0));
        this.addChild((Node)jointHouse1);
        float houseSideSizeDifference = JointHouse.getSideHeight(sizeToUseHereA) - JointHouse.getSideHeight(sizeToUseHereB);
        float radius = JointHouse.getRadius(sizeToUseHereB);
        float height = (float)(-dh.getA() - (double)JointHouse.getSideHeight(sizeToUseHereA) - (double)JointHouse.getSideHeight(sizeToUseHereB));
        Cylinder cyl = new Cylinder(radius, height, robotAppearance.metalAppearance());
        rotz.rotZ(1.5707963267948966);
        pos.set(-(dh.getA() / 2.0) - (double)(houseSideSizeDifference / 2.0f), 0.0, SecondLink.getHeightTriplet(sizeToUseHereA)[2]);
        this.addChild((Primitive)cyl, new Transform3D(rotz, pos, 1.0));
        JointHouse jointHouse2 = new JointHouse(sizeToUseHereB, robotAppearance, visualizationType);
        rotx.rotX(1.5707963267948966);
        rotz.rotZ(1.5707963267948966);
        rotz.mul(rotx);
        pos.set(0.0, 0.0, SecondLink.getHeightTriplet(sizeToUseHereA)[2]);
        jointHouse2.setTransform(new Transform3D(rotz, pos, 1.0));
        this.addChild((Node)jointHouse2);
    }
}

