/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.ur.polyscope.robot.configuration.contribution.RobotTypeSupport;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.visualization.SingularityVisualizationConfiguration;
import com.ur.polyscope.robot.configuration.visualization.SingularityVisualizationProvider;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.util.Set;
import javax.inject.Inject;

public class SingularityVisualizationProviderImpl
implements SingularityVisualizationProvider {
    private final SingularityVisualizationConfiguration singularityVisualizationConfiguration;

    @Inject
    public SingularityVisualizationProviderImpl(RobotTypeIdentificationProvider robotIdentificationProvider, Set<SingularityVisualizationConfiguration> singularityVisualizationConfigurations) {
        this.singularityVisualizationConfiguration = this.determineSingularityVisualization(robotIdentificationProvider, singularityVisualizationConfigurations);
    }

    public SingularityVisualizationConfiguration getSingularityVisualization() {
        return this.singularityVisualizationConfiguration;
    }

    private SingularityVisualizationConfiguration determineSingularityVisualization(RobotTypeIdentificationProvider robotTypeIdentificationProvider, Set<SingularityVisualizationConfiguration> singularityVisualizationConfigurations) {
        RobotType robotType = robotTypeIdentificationProvider.getRobotTypeIdentification().robotType();
        for (SingularityVisualizationConfiguration configuration : singularityVisualizationConfigurations) {
            if (!((RobotTypeSupport)configuration).supportsRobotType(robotType.getId())) continue;
            return configuration;
        }
        throw new IllegalStateException("Unsupported RobotType");
    }
}

