/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouse;
import com.ur.polyscope.robot.configuration.internal.visualization.Link;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.view.constants.dev.robotsize.JointSize;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

class SixthLink
extends Link {
    SixthLink(TransformGroup parent, DH dh, RobotAppearance robotAppearance, JointSize jointSize) {
        super(parent, dh);
        float height = (float)(dh.getD() - SixthLink.getHeightTriplet(jointSize)[0]);
        Cylinder cyl = new Cylinder(JointHouse.getRadius(jointSize), height, robotAppearance.metalAppearance());
        Vector3d pos = new Vector3d(0.0, 0.0, (double)(-height / 2.0f));
        Matrix3d rot = new Matrix3d();
        rot.rotX(1.5707963267948966);
        Transform3D t3d = new Transform3D();
        t3d.set(rot, pos, 1.0);
        this.addChild((Primitive)cyl, t3d);
        float ioConnectorCylLength = 0.021f;
        float ioConnectorCylRadius = 0.0065f;
        Cylinder toolIOCyl = new Cylinder(ioConnectorCylRadius, ioConnectorCylLength, robotAppearance.metalAppearance());
        t3d = new Transform3D();
        t3d.setTranslation(new Vector3d(0.0, (double)(-JointHouse.getRadius(jointSize)), (double)(-height / 2.0f)));
        this.addChild((Primitive)toolIOCyl, t3d);
    }
}

