/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouse;
import com.ur.polyscope.robot.configuration.internal.visualization.ThirdLink;
import com.ur.polyscope.robot.configuration.kinematics.DH;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.view.constants.dev.robotsize.JointSize;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

class ThirdLinkImpl
extends ThirdLink {
    ThirdLinkImpl(TransformGroup parent, DH dh, RobotAppearance robotAppearance, VisualizationType visualizationType, JointSize lowerArmSize, JointSize wrist1Size) {
        super(parent, dh);
        double handProtectionDist;
        double lowerArmZoffset;
        switch (wrist1Size) {
            case SIZE0: {
                lowerArmZoffset = 0.027;
                handProtectionDist = 0.014;
                break;
            }
            case SIZE1: {
                lowerArmZoffset = 0.007;
                handProtectionDist = 0.026;
                break;
            }
            case SIZE2: {
                lowerArmZoffset = 0.048;
                handProtectionDist = 0.013;
                break;
            }
            case SIZE2_5: {
                lowerArmZoffset = 0.032;
                handProtectionDist = 0.013;
                break;
            }
            default: {
                lowerArmZoffset = 0.0;
                handProtectionDist = 0.0;
            }
        }
        Matrix3d rotx = new Matrix3d();
        Matrix3d rotz = new Matrix3d();
        Vector3d pos = new Vector3d();
        float radiusDiff = JointHouse.getRadius(lowerArmSize) - JointHouse.getRadius(wrist1Size);
        this.addJointHouseBase(robotAppearance, lowerArmSize, rotx, pos, lowerArmZoffset, radiusDiff);
        this.addJointCylinder(robotAppearance, lowerArmSize, wrist1Size, rotx, rotz, pos, lowerArmZoffset, radiusDiff);
        this.addJointHouseWrist1(robotAppearance, visualizationType, wrist1Size, handProtectionDist, rotx, rotz, pos, lowerArmZoffset);
    }

    private void addJointHouseWrist1(RobotAppearance robotAppearance, VisualizationType visualizationType, JointSize wrist1Size, double handProtectionDist, Matrix3d rotx, Matrix3d rotz, Vector3d pos, double lowerArmZoffset) {
        JointHouse jointHouse = new JointHouse(wrist1Size, robotAppearance, visualizationType);
        rotx.rotX(-1.5707963267948966);
        rotz.rotZ(-1.5707963267948966);
        rotz.mul(rotx);
        pos.set(0.0, 0.0, lowerArmZoffset);
        jointHouse.setTransform(new Transform3D(rotz, pos, 1.0));
        this.addChild((Node)jointHouse);
        float cylRadius = JointHouse.getRadius(wrist1Size);
        double cylHeight = 1.5 * handProtectionDist;
        Cylinder handProtection = new Cylinder(cylRadius, (float)cylHeight, robotAppearance.metalAppearance());
        rotx.rotX(1.5707963267948966);
        pos.set(0.0, 0.0, lowerArmZoffset + cylHeight / 2.0 + ThirdLinkImpl.getHeightTriplet(wrist1Size)[0]);
        this.addChild((Primitive)handProtection, new Transform3D(rotx, pos, 1.0));
    }

    private void addJointCylinder(RobotAppearance robotAppearance, JointSize lowerArmSize, JointSize wrist1Size, Matrix3d rotx, Matrix3d rotz, Vector3d pos, double lowerArmZoffset, float radiusDiff) {
        float cylRadius = JointHouse.getRadius(lowerArmSize);
        double cylHeight = JointHouse.getRadius(lowerArmSize);
        Cylinder cylToCoverSphere = new Cylinder(cylRadius, (float)cylHeight, robotAppearance.metalAppearance());
        rotx.rotX(1.5707963267948966);
        pos.set(-this.dh.getA(), 0.0, lowerArmZoffset + cylHeight / 2.0 + (double)radiusDiff);
        this.addChild((Primitive)cylToCoverSphere, new Transform3D(rotx, pos, 1.0));
        cylRadius = JointHouse.getRadius(wrist1Size);
        cylHeight = (float)(-this.dh.getA());
        Cylinder lowerArm = new Cylinder(cylRadius, (float)cylHeight, robotAppearance.metalAppearance());
        rotz.rotZ(1.5707963267948966);
        pos.set(cylHeight / 2.0, 0.0, lowerArmZoffset);
        this.addChild((Primitive)lowerArm, new Transform3D(rotz, pos, 1.0));
    }

    private void addJointHouseBase(RobotAppearance robotAppearance, JointSize lowerArmSize, Matrix3d rotx, Vector3d pos, double lowerArmZoffset, double radiusDiff) {
        float radius = JointHouse.getRadius(lowerArmSize);
        Sphere ball = new Sphere(radius, robotAppearance.metalAppearance());
        rotx.setIdentity();
        pos.set(-this.dh.getA(), 0.0, lowerArmZoffset + radiusDiff);
        this.addChild((Primitive)ball, new Transform3D(rotx, pos, 1.0));
    }
}

