/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.robot.configuration.internal.visualization;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotDraw3D;
import com.ur.polyscope.robot.configuration.internal.RobotDraw3DInternal;
import com.ur.polyscope.robot.configuration.internal.RobotTypeContribution;
import com.ur.polyscope.robot.configuration.internal.TextResource;
import com.ur.polyscope.robot.configuration.internal.robotidentification.RobotTypeIdentificationProvider;
import com.ur.polyscope.robot.configuration.internal.visualization.FifthLink;
import com.ur.polyscope.robot.configuration.internal.visualization.FirstLink;
import com.ur.polyscope.robot.configuration.internal.visualization.FourthLink;
import com.ur.polyscope.robot.configuration.internal.visualization.JointHouseFootProvider;
import com.ur.polyscope.robot.configuration.internal.visualization.Link;
import com.ur.polyscope.robot.configuration.internal.visualization.SecondLink;
import com.ur.polyscope.robot.configuration.internal.visualization.SixthLink;
import com.ur.polyscope.robot.configuration.internal.visualization.ThirdLinkProvider;
import com.ur.polyscope.robot.configuration.kinematics.DHParameters;
import com.ur.polyscope.robot.configuration.visualization.RobotAppearance;
import com.ur.polyscope.robot.configuration.visualization.VisualizationProvider;
import com.ur.polyscope.robot.configuration.visualization.VisualizationType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.WarningDialogCreator;
import com.ur.swing.dialog.WarningMessage;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.robotsize.JointSize;
import com.ur.view.constants.dev.robotsize.RobotType;
import java.util.Set;
import javax.inject.Inject;
import javax.media.j3d.TransformGroup;

public class VisualizationProviderImpl
implements VisualizationProvider {
    private final Recipe<DHParameters> dhRecipe;
    private final JointHouseFootProvider jointHouseFootProvider;
    private final ThirdLinkProvider thirdLinkProvider;
    private final WarningDialogCreator warningDialogCreator;
    private final TextResource textResource;
    private final JointSize[] jointSizes;

    @Inject
    public VisualizationProviderImpl(RobotConfigurationProvider robotConfigurationProvider, @Source(value=DHParameters.class) Recipe<DHParameters> dhRecipe, JointHouseFootProvider jointHouseFootProvider, ThirdLinkProvider thirdLinkProvider, WarningDialogCreator warningDialogCreator, TextResource textResource, RobotTypeIdentificationProvider robotIdentificationProvider, Set<RobotTypeContribution> robotTypeContributions) {
        this.jointSizes = this.determineRobotJointSizes(robotIdentificationProvider, robotTypeContributions, robotConfigurationProvider.getRobotDraw3D());
        this.dhRecipe = dhRecipe;
        this.jointHouseFootProvider = jointHouseFootProvider;
        this.thirdLinkProvider = thirdLinkProvider;
        this.warningDialogCreator = warningDialogCreator;
        this.textResource = textResource;
    }

    public boolean isReady() {
        return this.dhRecipe.lastProvider().get() != null;
    }

    public JointPositionVector.LinkTransform[] initializeRobotLinks(TransformGroup armBase, RobotAppearance robotAppearance, VisualizationType visualizationType) {
        DHParameters dhParameters = (DHParameters)this.dhRecipe.lastProvider().get();
        JointPositionVector.LinkTransform[] link = new Link[6];
        try {
            link[0] = new FirstLink(armBase, dhParameters.joint(0), robotAppearance, visualizationType, this.jointSizes[0], this.jointHouseFootProvider);
            link[1] = new SecondLink((TransformGroup)link[0], dhParameters.joint(1), robotAppearance, visualizationType, this.jointSizes[1], this.jointSizes[2]);
            link[2] = this.thirdLinkProvider.constructLink((TransformGroup)link[1], dhParameters.joint(2), dhParameters.joint(3), robotAppearance, visualizationType, this.jointSizes[2], this.jointSizes[3]);
            link[3] = new FourthLink((TransformGroup)link[2], dhParameters.joint(3), robotAppearance, visualizationType, this.jointSizes[3]);
            link[4] = new FifthLink((TransformGroup)link[3], dhParameters.joint(4), robotAppearance, visualizationType, this.jointSizes[4]);
            link[5] = new SixthLink((TransformGroup)link[4], dhParameters.joint(5), robotAppearance, this.jointSizes[5]);
        }
        catch (Exception e) {
            this.logFailureToCreateLinks(link, e);
        }
        return link;
    }

    private JointSize[] determineRobotJointSizes(RobotTypeIdentificationProvider robotIdentificationProvider, Set<RobotTypeContribution> robotTypeContributions, RobotDraw3D robotDraw3D) {
        JointSize[] result;
        if (robotDraw3D instanceof RobotDraw3DInternal) {
            result = ((RobotDraw3DInternal)robotDraw3D).getJointSizesForRobot();
        } else {
            RobotType robotType = robotIdentificationProvider.getRobotTypeIdentification().robotType();
            result = this.getJointSizesFromContributions(robotTypeContributions, robotType);
        }
        return result;
    }

    private JointSize[] getJointSizesFromContributions(Set<RobotTypeContribution> robotTypeContributions, RobotType robotType) {
        JointSize[] result = null;
        for (RobotTypeContribution contribution : robotTypeContributions) {
            if (!contribution.supportsRobotType(robotType.getId())) continue;
            int[] jointIdsForRobotType = contribution.getJointIdsForRobotType();
            result = new JointSize[jointIdsForRobotType.length];
            for (int i = 0; i < jointIdsForRobotType.length; ++i) {
                int id = jointIdsForRobotType[i];
                result[i] = JointSize.byId((int)id);
            }
        }
        return result;
    }

    private void logFailureToCreateLinks(JointPositionVector.LinkTransform[] link, Exception e) {
        for (int i = 0; i < link.length; ++i) {
            if (link[i] != null) continue;
            this.warningDialogCreator.showWarningMessageDialog(new WarningMessage(this.textResource.Configuration(), this.textResource.errorInSettingLinkParameters(i)), new OkDialogListener());
            Log.error((String)"Unable to initialize link: ", (Throwable)e);
            break;
        }
    }
}

