/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.attachment;

import com.ur.polyscope.flightrecorder.attachment.FileAttachmentConfiguration;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class AttachmentCollector {
    private final List<FlightRecorderAttachment> attachments = new ArrayList<FlightRecorderAttachment>();
    private final FlightRecorderAttachmentFactory attachmentFactory;

    public AttachmentCollector(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
    }

    public void collect(File file, String mimeType) {
        if (file.exists()) {
            FileAttachmentConfiguration configuration = this.attachmentFactory.getFileAttachmentConfiguration();
            configuration.setFile(file).setMimeType(mimeType);
            this.collect(this.attachmentFactory.getTextFileAttachment(configuration));
        }
    }

    public void collect(File file, int maxSize, String mimeType) {
        if (file.exists()) {
            FileAttachmentConfiguration configuration = this.attachmentFactory.getFileAttachmentConfiguration();
            configuration.setFile(file).setMimeType(mimeType).setMaxTextFileSize(maxSize);
            this.collect(this.attachmentFactory.getTextFileAttachment(configuration));
        }
    }

    public void collect(File file, String targetDirectory, String mimeType) {
        if (file.exists()) {
            FileAttachmentConfiguration configuration = this.attachmentFactory.getFileAttachmentConfiguration();
            configuration.setFile(file).setMimeType(mimeType).setTargetDirectoryPath(targetDirectory);
            this.collect(this.attachmentFactory.getTextFileAttachment(configuration));
        }
    }

    public void collect(FlightRecorderAttachment attachment) {
        this.attachments.add(attachment);
    }

    public void collectAll(List<FlightRecorderAttachment> list) {
        this.attachments.addAll(list);
    }

    public List<FlightRecorderAttachment> asList() {
        return new ArrayList<FlightRecorderAttachment>(this.attachments);
    }
}

