/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.disk.Directories;
import com.ur.polyscope.calibration.BasicTreeNode;
import com.ur.polyscope.calibration.CalibrationTreeEvent;
import com.ur.polyscope.calibration.CalibrationTreeListener;
import com.ur.polyscope.calibration.ProgramContainerNode;
import com.ur.polyscope.calibration.ProgramCorrespondencePointNode;
import com.ur.polyscope.persistence.Serialization;
import com.ur.polyscope.persistence.SerializationFacade;
import com.ur.util.IterableEnumerationWrapper;
import com.ur.util.logging.Log;
import gui.tools.LanguagePack;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class CalibrationTreeContainer
implements Serializable {
    private static transient CalibrationTreeContainer treeContainerInstance = null;
    protected transient EventListenerList listenerList = null;
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private transient DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private transient boolean saved = false;
    private String name = "TreeContainer";
    private transient int number = 0;
    private String directory = Directories.programs().getPath();

    public static CalibrationTreeContainer getInstance() {
        return treeContainerInstance;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        boolean update = saved ^ this.saved;
        this.saved = saved;
        if (update) {
            this.fireCalibrationTreeEvent(new CalibrationTreeEvent(this));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CalibrationTreeContainer() {
        this.listenerList = new EventListenerList();
    }

    public String getFileName() {
        return this.directory + File.separator + this.getName() + ".calib";
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void addNode(BasicTreeNode child, BasicTreeNode parent) {
        this.treeModel.insertNodeInto(child, parent, parent.getChildCount());
        this.treeModel.nodeChanged(child);
        this.setSaved(false);
    }

    public void removeNode(BasicTreeNode node) {
        if (this.treeModel.getPathToRoot(node).length > 2) {
            this.treeModel.removeNodeFromParent(node);
            this.treeModel.reload();
            this.setSaved(false);
        } else {
            Log.info((String)"Unsuccessfull node removal...");
        }
    }

    public static boolean actualSave() {
        if (treeContainerInstance == null) {
            return false;
        }
        boolean succeed = true;
        File file = new File(CalibrationTreeContainer.getInstance().getFileName());
        try (FileOutputStream os = new FileOutputStream(file);
             GZIPOutputStream gzipos = new GZIPOutputStream(os);
             OutputStreamWriter oututf8 = new OutputStreamWriter((OutputStream)gzipos, StandardCharsets.UTF_8);){
            CalibrationTreeContainer.writeAsXML(treeContainerInstance, oututf8);
            Log.info((String)("Saved file \"" + file.getAbsolutePath()));
            treeContainerInstance.setSaved(true);
        }
        catch (Exception e) {
            Log.error((String)("Cannot write file " + e));
            succeed = false;
        }
        return succeed;
    }

    public boolean containAny(Class<?> type) {
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (current.getClass() != type) continue;
            return true;
        }
        return false;
    }

    public int containAmountOf(Class<?> type) {
        int sum = 0;
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (current.getClass() != type) continue;
            ++sum;
        }
        return sum;
    }

    public Vector<ProgramContainerNode> getListOfPrograms() {
        Vector<ProgramContainerNode> vec = new Vector<ProgramContainerNode>();
        DefaultMutableTreeNode root = this.rootNode;
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (!(current instanceof ProgramContainerNode)) continue;
            vec.add((ProgramContainerNode)current);
        }
        return vec;
    }

    public Vector<ProgramCorrespondencePointNode> getTestpoints() {
        this.number = 0;
        Vector<ProgramCorrespondencePointNode> vec = new Vector<ProgramCorrespondencePointNode>();
        DefaultMutableTreeNode root = this.rootNode;
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            ProgramCorrespondencePointNode t;
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (!(current instanceof ProgramCorrespondencePointNode) || !(t = (ProgramCorrespondencePointNode)current).isTeached()) continue;
            ((ProgramCorrespondencePointNode)current).indexNumber = ++this.number;
            vec.add((ProgramCorrespondencePointNode)current);
        }
        return vec;
    }

    public Vector<BasicTreeNode> getAllInstanceOf(Class<?> type) {
        this.number = 0;
        Vector<BasicTreeNode> vec = new Vector<BasicTreeNode>();
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
            if (!type.isInstance(current)) continue;
            vec.add((BasicTreeNode)current);
        }
        return vec;
    }

    public static void setInstance(CalibrationTreeContainer instance) {
        treeContainerInstance = instance;
        if (treeContainerInstance != null) {
            CalibrationTreeContainer.treeContainerInstance.treeModel = new DefaultTreeModel(CalibrationTreeContainer.treeContainerInstance.rootNode);
            CalibrationTreeContainer.treeContainerInstance.listenerList = new EventListenerList();
        }
    }

    static void writeAsXML(CalibrationTreeContainer calibrationTreeContainer, Writer writer) {
        Serialization marshaller = SerializationFacade.createMarshaller();
        marshaller.fromClass(CalibrationTreeContainer.class);
        marshaller.alias("gui.program.calibration.CalibrationTreeContainer", CalibrationTreeContainer.class);
        marshaller.toXML((Object)calibrationTreeContainer, writer);
    }

    public void setName(File file) {
        if (file != null) {
            this.directory = file.getParentFile().getPath();
            this.name = file.getName();
            if (this.name.endsWith(".calib")) {
                this.name = this.name.substring(0, this.name.length() - 6);
            }
        } else {
            this.setName(LanguagePack.getTextResource().placeholderUnnamed());
        }
    }

    public static void actualLoad(File file) throws Exception {
        if (!file.isFile() || !file.exists()) {
            throw new IOException("Missing calibration file");
        }
        Log.info((String)("program: loading file \"" + file.getPath() + "\""));
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
             GZIPInputStream gzipis = new GZIPInputStream(is);
             InputStreamReader inutf8 = new InputStreamReader((InputStream)gzipis, StandardCharsets.UTF_8);){
            CalibrationTreeContainer ctc = CalibrationTreeContainer.readFromXML(inutf8);
            CalibrationTreeContainer.setInstance(ctc);
            treeContainerInstance.setSaved(true);
        }
    }

    static CalibrationTreeContainer readFromXML(Reader reader) {
        Serialization unmarshaller = SerializationFacade.createUnmarshaller();
        unmarshaller.fromClass(CalibrationTreeContainer.class);
        unmarshaller.alias("gui.program.calibration.CalibrationTreeContainer", CalibrationTreeContainer.class);
        CalibrationTreeContainer container = (CalibrationTreeContainer)unmarshaller.fromXML(reader);
        CalibrationTreeContainer.bindChildToParent(container.rootNode);
        return container;
    }

    private static void bindChildToParent(DefaultMutableTreeNode treeNode) {
        for (TreeNode each : new IterableEnumerationWrapper(treeNode.children())) {
            if (!(each instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)each;
            node.setParent(treeNode);
            CalibrationTreeContainer.bindChildToParent(node);
        }
    }

    public static void newInstance(BasicTreeNode root, String name) {
        CalibrationTreeContainer newCalib = new CalibrationTreeContainer();
        newCalib.treeModel.setRoot(root);
        newCalib.treeModel.insertNodeInto(root, newCalib.rootNode, 0);
        newCalib.setName(name);
        CalibrationTreeContainer.setInstance(newCalib);
    }

    public void addSomethingChangedListener(CalibrationTreeListener listener) {
        this.listenerList.add(CalibrationTreeListener.class, listener);
    }

    public void removedSomethingChangedListener(CalibrationTreeListener listener) {
        this.listenerList.remove(CalibrationTreeListener.class, listener);
    }

    void fireCalibrationTreeEvent(CalibrationTreeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CalibrationTreeListener.class) continue;
            ((CalibrationTreeListener)listeners[i + 1]).somethingChanged(evt);
        }
    }
}

