/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.NewCalibration;
import com.ur.polyscope.calibration.ProgramTransSettingsAndOverviewNode;
import com.ur.polyscope.calibration.communication.CalibrationClientSocket;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibMain;
import com.ur.polyscope.calibration.dualrobot.DualRobotSlaveStatusCard;
import com.ur.polyscope.calibration.filemanager.CalibrationFileManagerConfiguration;
import com.ur.polyscope.calibration.programcorrection.ProgramTransPanel;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.swing.CardPanel;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import gui.polyscope.CalibrationModeService;
import gui.tools.DialogCreator;
import gui.tools.URFileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.GroupLayout;
import org.apache.commons.io.FilenameUtils;

@Singleton
public class MainCalibrationImpl
extends CardPanel
implements MainCalibration {
    private final String calibrationBackendStartScriptPath;
    private final FilePersistence filePersistence;
    private final CalibrationModeService calibrationModeService;
    private Provider<ProgramTransPanel> programTransPanelProvider;
    private FlippablePanel centerFlippablePanel;
    private FileContainer loadFileContainer;
    private FileContainer saveFileContainer;
    private CalibrationClientSocket socket;
    private boolean dualCalibActive = false;
    private boolean dualCalibSlaveActive = false;
    private boolean programCorrectionModeActive;
    private DialogCreator dialogCreator;
    private TextResource textResource;
    private File currentSelection = null;

    @Inject
    public MainCalibrationImpl(FilePersistence filePersistence, Provider<ProgramTransPanel> programTransPanelProvider, NewCalibration newCalibration, DualRobotSlaveStatusCard dualRobotSlaveStatusCard, DualRobotCalibMain dualRobotCalib, DialogCreator dialogCreator, CalibrationModeService calibrationModeService, Provider<RobotIdentification> robotIdentificationProvider, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, TextResource textResource) {
        this.filePersistence = filePersistence;
        this.calibrationModeService = calibrationModeService;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        this.calibrationBackendStartScriptPath = "/root".equals(System.getProperty("user.home")) ? "/usr/local/urcontrol/calibrationBackend &> /dev/tty12" : Directories.home() + "/.urcontrol/calibrationBackend";
        this.initComponents();
        this.socket = new CalibrationClientSocket("127.0.0.1", 29998, this, dialogCreator, robotIdentificationProvider, (Provider<KinematicsCalibration>)calibrationRecipe.lastProvider(), textResource);
        this.centerFlippablePanel = new FlippablePanel();
        this.centerFlippablePanel.setCardParent((CardPanel)this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.centerFlippablePanel, "Center");
        this.programTransPanelProvider = programTransPanelProvider;
        newCalibration.setMainCalibration(this);
        dualRobotCalib.setMainCalibration(this);
        dualRobotSlaveStatusCard.setMainCalibration(this);
        this.centerFlippablePanel.addCardPanel(NewCalibration.class, (CardPanel)newCalibration);
        this.centerFlippablePanel.addCardPanel((CardPanel)dualRobotCalib);
        this.centerFlippablePanel.addCardPanel((CardPanel)dualRobotSlaveStatusCard);
        this.socket.setProgramTransProvider(this.programTransPanelProvider);
    }

    @Override
    public CalibrationClientSocket getSocket() {
        return this.socket;
    }

    @Override
    public ProgramTransPanel getProgramTransPanel() {
        return (ProgramTransPanel)this.programTransPanelProvider.get();
    }

    public void enter(Object o) {
        this.calibrationModeService.setMode(CalibrationModeService.CalibrationMode.CALIBRATION_MODE);
        super.enter(o);
        this.loadUpdate();
        this.saveUpdate();
        this.update();
        this.centerFlippablePanel.enterActiveChild(o);
        this.getSocket().sendPacketProgramTrans_save();
    }

    private void loadUpdate() {
        if (this.loadFileContainer == null || this.loadFileContainer.getFile() == null) {
            this.loadFileContainer = null;
            return;
        }
        this.currentSelection = this.loadFileContainer.getFile();
        try {
            CalibrationTreeContainer.actualLoad(this.currentSelection);
        }
        catch (Exception e) {
            Log.error((String)("Error loading plate calibration file: " + this.currentSelection), (Throwable)e);
            this.showErrorLoadingCalibrationDialog(this.currentSelection);
        }
        this.loadFileContainer = null;
    }

    private void showErrorLoadingCalibrationDialog(File file) {
        String title = this.textResource.errorLoading();
        String message = this.textResource.errorLoadingPlateCalibrationFile(this.getFileNameFromFile(file));
        ErrorMessage errorMessage = new ErrorMessage(title, message);
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    private String getFileNameFromFile(File file) {
        return URFileUtils.getRelativeToProgramPath((String)FilenameUtils.getFullPathNoEndSeparator((String)file.getAbsolutePath()), (String)file.getName());
    }

    private void saveUpdate() {
        if (this.saveFileContainer != null) {
            if (this.saveFileContainer.getFile() != null) {
                CalibrationTreeContainer.getInstance().setName(this.saveFileContainer.getFile());
                Log.debug((String)("Calibration saved as " + this.saveFileContainer.getFile()));
                CalibrationTreeContainer.actualSave();
            }
            this.saveFileContainer = null;
        }
    }

    public void update() {
        if (this.dualCalibActive || this.dualCalibSlaveActive) {
            this.startBackend();
        } else {
            this.stopBackendIfCorrectionModeInactive();
        }
        if (this.dualCalibSlaveActive) {
            this.centerFlippablePanel.switchTo(DualRobotSlaveStatusCard.class);
        } else if (this.dualCalibActive) {
            this.centerFlippablePanel.switchTo(DualRobotCalibMain.class);
        } else if (CalibrationTreeContainer.getInstance() == null) {
            this.centerFlippablePanel.switchTo(NewCalibration.class);
        } else if (CalibrationTreeContainer.getInstance().containAny(ProgramTransSettingsAndOverviewNode.class)) {
            this.centerFlippablePanel.switchTo(((ProgramTransPanel)this.programTransPanelProvider.get()).getClass());
        }
    }

    public Object exit() {
        this.calibrationModeService.setMode(CalibrationModeService.CalibrationMode.NO_CALIBRATION_MODE);
        this.centerFlippablePanel.exitActiveChild();
        return super.exit();
    }

    @Override
    public void loadCalibration() {
        this.loadFileContainer = new FileContainer();
        this.loadFileContainer.setFile(this.currentSelection);
        this.filePersistence.openFile(this.loadFileContainer, (FileManagerConfiguration)new CalibrationFileManagerConfiguration(this.textResource.loadCalibration()));
    }

    @Override
    public void saveCalibration() {
        if (CalibrationTreeContainer.getInstance() != null) {
            this.saveFileContainer = new FileContainer();
            this.saveFileContainer.setFile(new File(CalibrationTreeContainer.getInstance().getName()));
            this.filePersistence.saveFile(this.saveFileContainer, (FileManagerConfiguration)new CalibrationFileManagerConfiguration(this.textResource.saveCalibration()));
        }
    }

    @Override
    public void startBackend() {
        if (!this.backendIsRunning()) {
            BashScriptRunner bs1 = new BashScriptRunner(this.calibrationBackendStartScriptPath);
            bs1.executeBackground();
        }
        if (!this.socket.isAlive() && !this.socket.isConnected()) {
            this.socket.start();
        }
        this.socket.reconnect();
    }

    public boolean backendIsRunning() {
        BashScriptRunner bs1 = new BashScriptRunner("ps -C calibrationBackend -Al | grep calibrationBack");
        String output = "";
        try {
            bs1.execute();
            output = bs1.getOutputString();
        }
        catch (Exception e) {
            Log.error((String)("Could not run script: " + e.toString()));
        }
        return output.lastIndexOf("calibrationBack") >= 0;
    }

    public void stopBackend() {
        if (this.backendIsRunning()) {
            this.socket.sendQuitRequest();
        }
    }

    @Override
    public void stopBackendIfCorrectionModeInactive() {
        if (!this.programCorrectionModeActive) {
            this.stopBackend();
        }
    }

    @Override
    public void enterDualCalib() {
        this.dualCalibActive = true;
        this.update();
    }

    @Override
    public void exitDualCalib() {
        this.dualCalibActive = false;
        this.update();
    }

    @Override
    public void enterSlaveCalib() {
        this.dualCalibSlaveActive = true;
        this.update();
    }

    @Override
    public void exitSlaveCalib() {
        this.dualCalibSlaveActive = false;
        this.update();
    }

    @Override
    public void receiveErrorMessage(String error) {
        Log.error((String)("ReceiveErrorMessage: " + error));
    }

    @Override
    public void receiveWarningMessage(String warning) {
        Log.warning((String)("receiveWarningMessage: " + warning));
    }

    @Override
    public void receiveStatusMessage(String status) {
        Log.info((String)("receiveStatusMessage: " + status));
    }

    @Override
    public void programCorrectionEnabled(boolean enabled) {
        this.programCorrectionModeActive = enabled;
        if (this.programCorrectionModeActive) {
            this.startBackend();
        } else {
            this.stopBackend();
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

