/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.polyscope.calibration.BasicTreeNode;
import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.NotAFixedWaypointNode;
import com.ur.polyscope.calibration.ProgramContainerCard;
import com.ur.polyscope.calibration.ProgramCorrespondencePointNode;
import com.ur.polyscope.calibration.RealNodeWrapperTreeNode;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.swing.CardPanel;
import com.ur.util.CollectionUtils;
import com.ur.util.logging.Log;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.calibration.KinematicDataComponent;
import gui.program.position.WaypointNode;
import java.io.File;
import java.util.Enumeration;

public class ProgramContainerNode
extends BasicTreeNode {
    private static final int MISSING_KINEMATICS_INFORMATION = -1;
    private ProgramRootNode loadedProgram = null;

    @Override
    public Class<? extends CardPanel> getCardClass() {
        return ProgramContainerCard.class;
    }

    public int loadProgram(File f) {
        try {
            this.loadedProgram = ProgramRootNodeLoad.loadWithOutKinematicCheck((File)f);
            if (this.loadedProgram.getComponent(KinematicDataComponent.class) == null || ((KinematicDataComponent)this.loadedProgram.getComponent(KinematicDataComponent.class)).getKinematics() == null) {
                return -1;
            }
            if (Log.canLog((Log.Level)Log.Level.TRACE)) {
                Enumeration e = this.loadedProgram.children();
                while (e.hasMoreElements()) {
                    Log.trace((String)("" + e.nextElement()));
                }
            }
            Log.debug((String)("ProgramContainerNode.loadedProgram has " + this.loadedProgram.getMainProgram().getChildCount() + " children"));
            this.extractNode((AbstractProgramNode)this.loadedProgram.getMainProgram(), this);
        }
        catch (Exception e) {
            Log.error((String)("ProgramContainerNode.loadProgram() caugt exception: " + e));
        }
        return 0;
    }

    private void extractNode(AbstractProgramNode programNode, BasicTreeNode treeNode) {
        for (AbstractProgramNode tmpNode : CollectionUtils.filter((Enumeration)programNode.children(), AbstractProgramNode.class)) {
            BasicTreeNode newTreeNode = this.newProgramTreeNode(tmpNode);
            this.extractNode(tmpNode, newTreeNode);
            CalibrationTreeContainer.getInstance().addNode(newTreeNode, treeNode);
        }
    }

    private BasicTreeNode newProgramTreeNode(AbstractProgramNode programNode) {
        RealNodeWrapperTreeNode newTreeNode = null;
        if (this.isWaypointOfType(programNode, PositionNodeType.FIXED)) {
            newTreeNode = new ProgramCorrespondencePointNode((WaypointNode)programNode, ((KinematicDataComponent)this.loadedProgram.getComponent(KinematicDataComponent.class)).getKinematics());
        } else if (!(programNode instanceof WaypointNode)) {
            newTreeNode = new NotAFixedWaypointNode(programNode);
        }
        return newTreeNode;
    }

    private boolean isWaypointOfType(AbstractProgramNode programNode, PositionNodeType desiredType) {
        if (programNode instanceof WaypointNode) {
            WaypointNode tmpWP = (WaypointNode)programNode;
            return tmpWP.getPositionNodeType() == desiredType;
        }
        return false;
    }

    public ProgramRootNode getLoadedProgram() {
        return this.loadedProgram;
    }

    @Override
    public String toString() {
        if (this.loadedProgram != null) {
            return "P:" + this.getLoadedProgram().getName();
        }
        return "P:<select program>";
    }
}

