/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramTransOverviewPlaceNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRobotPairNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRoot;
import com.ur.polyscope.calibration.communication.ICalibProgramTransKeyMapReceived;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.program.ProgramCorrectionService;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ProgramCorrectionServiceImpl
implements ProgramCorrectionService,
ICalibProgramTransKeyMapReceived {
    private final Provider<MainCalibration> mainCalibrationProvider;
    private Provider<RobotIdentification> robotIdentificationProvider;
    private boolean waitingForKeyMapReply;
    private ProgramTransOverviewRoot receivedKeyMap;
    private Provider<KinematicsCalibration> kinematicsProvider;

    @Inject
    public ProgramCorrectionServiceImpl(Provider<MainCalibration> mainCalibrationProvider, Provider<RobotIdentification> robotIdentificationProvider, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe) {
        this.mainCalibrationProvider = mainCalibrationProvider;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.kinematicsProvider = calibrationRecipe.lastProvider();
    }

    @Override
    public void keyMapReceived(ProgramTransOverviewRoot overview) {
        this.receivedKeyMap = overview;
        this.waitingForKeyMapReply = false;
    }

    public boolean isProgramCorrectionApplicable(String installationFileName, KinematicsCalibration kinematics, RobotIdentification robotSerialNumber) {
        String placeName = installationFileName;
        ((MainCalibration)this.mainCalibrationProvider.get()).startBackend();
        ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().addKeyMapReceivedListener(this);
        this.waitingForKeyMapReply = true;
        while (this.waitingForKeyMapReply) {
            try {
                Thread.sleep(100L);
                ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_KeyPairMapRequest(((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksum(), (RobotIdentification)this.robotIdentificationProvider.get());
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Log.info((String)("Failed: " + ex.getMessage()));
            }
        }
        ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().removedKeyMapReceivedListener(this);
        ((MainCalibration)this.mainCalibrationProvider.get()).stopBackendIfCorrectionModeInactive();
        if (this.receivedKeyMap == null) {
            return false;
        }
        for (int i = 0; i < this.receivedKeyMap.getChildCount(); ++i) {
            boolean robotMatches;
            ProgramTransOverviewRobotPairNode robotPair = (ProgramTransOverviewRobotPairNode)this.receivedKeyMap.getChildAt(i);
            boolean bl = robotMatches = kinematics.getMergedChecksum() == robotPair.getChecksum1() && ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksum() == robotPair.getChecksum2() && robotSerialNumber.equals(robotPair.getRobotName1()) && ((RobotIdentification)this.robotIdentificationProvider.get()).equals(robotPair.getRobotName2());
            if (!robotMatches) continue;
            for (int j = 0; j < robotPair.getChildCount(); ++j) {
                boolean found;
                ProgramTransOverviewPlaceNode placeNode = (ProgramTransOverviewPlaceNode)robotPair.getChildAt(j);
                boolean bl2 = found = placeNode.getRobotPlace1().equals(placeName) && placeNode.getRobotPlace2().equals(placeName) && placeNode.getChildCount() > 0;
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    public boolean applyProgramCorrection(String installationFileName, ProgramRootNode program) {
        ((MainCalibration)this.mainCalibrationProvider.get()).startBackend();
        boolean correctionResult = ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().correctProgram(installationFileName, installationFileName, ((FileManagementProgramComponent)program.getComponent(FileManagementProgramComponent.class)).getProgramFile(), program);
        ((MainCalibration)this.mainCalibrationProvider.get()).stopBackendIfCorrectionModeInactive();
        return correctionResult;
    }
}

