/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.lang.DecimalFormatFactory;
import com.ur.move.MoveTab;
import com.ur.polyscope.calibration.ProgramCorrespondencePointNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.swing.CardPanel;
import com.ur.util.logging.Log;
import gui.installation.services.LookupServiceFacade;
import gui.program.EntityFactory;
import gui.program.position.WaypointNode;
import java.awt.Container;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.vecmath.Point3d;

public class ProgramCorrespondencePointCard
extends CardPanel {
    private static DecimalFormat f2 = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.00");
    private static DecimalFormat f3 = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"00.###E0");
    private WaypointNode teachWaypointNode = null;
    private ProgramCorrespondencePointNode wp = null;
    private JLabel jResidualError;
    private JLabel labelNewConfiguration;
    private JLabel labelOldConfiguration;
    private JLabel labelPosition;
    private JLabel labelRotation;

    public ProgramCorrespondencePointCard() {
        this.initComponents();
    }

    public void enter(Object o) {
        super.enter(o);
        if (this.teachWaypointNode != null) {
            if (this.wp != null && this.teachWaypointNode.getJointPositionVector() != null) {
                this.wp.setTeachedJointPosition(this.teachWaypointNode.getJointPositionVector());
            } else {
                Log.error((String)"Error in ProgramCorrecpondancePointNode enter, wp was null with teachWaypointNode not null");
            }
            this.teachWaypointNode = null;
        }
        if (o instanceof ProgramCorrespondencePointNode) {
            this.wp = (ProgramCorrespondencePointNode)o;
            this.update();
        }
    }

    private void update() {
        if (this.wp == null) {
            return;
        }
        String UNDEFINED_TEXT = " --- ";
        if (this.wp.getOldJointPosition().isUndefined()) {
            this.labelRotation.setText(" --- ");
            this.labelPosition.setText(" --- ");
            this.labelOldConfiguration.setText(" --- ");
        } else {
            this.labelRotation.setText(this.point3dToString(this.wp.getToolAxisAngle(), f2));
            this.labelPosition.setText(this.point3dToString(this.wp.getToolPosition(), f2));
            this.labelOldConfiguration.setText(this.wp.getOldJointPosition().toString(f2));
        }
        if (this.wp.getTeachedJointPosition() == null || !this.wp.isTeached()) {
            this.labelNewConfiguration.setText(" --- ");
            this.jResidualError.setText(" --- ");
        } else {
            this.labelNewConfiguration.setText(this.wp.getTeachedJointPosition().toString(f2));
            this.jResidualError.setText(f3.format(this.wp.error));
        }
    }

    String point3dToString(Point3d value, DecimalFormat format) {
        return "[ " + format.format(value.x) + ", " + format.format(value.y) + ", " + format.format(value.z) + " ] ";
    }

    public void updateResidualErrorLabel() {
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.labelPosition = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.labelRotation = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.labelOldConfiguration = new JLabel();
        JButton jButtonTeach = new JButton();
        JLabel jLabel7 = new JLabel();
        this.labelNewConfiguration = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.jResidualError = new JLabel();
        jLabel1.setText("Waypoint");
        jLabel2.setText("Position:");
        this.labelPosition.setText("(0,0,0)");
        jLabel4.setText("Orientation");
        this.labelRotation.setText("(0,0,0)");
        jLabel6.setText("Old configuration");
        this.labelOldConfiguration.setText("[0,0,0,0,0,0]");
        jButtonTeach.setText("Teach new position");
        jButtonTeach.addActionListener(evt -> this.jButtonTeachActionPerformed());
        jLabel7.setText("New configuration");
        this.labelNewConfiguration.setText("[0,0,0,0,0,0]");
        jLabel3.setText("Residual error");
        this.jResidualError.setText("-----");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jButtonTeach, GroupLayout.Alignment.TRAILING, -1, 228, Short.MAX_VALUE).addComponent(jLabel1).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel4).addComponent(jLabel2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.labelPosition)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.labelRotation)).addComponent(jLabel6).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.labelOldConfiguration)).addComponent(jLabel7).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.labelNewConfiguration)).addComponent(jLabel3).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jResidualError))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPosition).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelRotation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelOldConfiguration).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelNewConfiguration).addGap(16, 16, 16).addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jResidualError).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jButtonTeach, -1, 89, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButtonTeachActionPerformed() {
        this.teachWaypointNode = ((EntityFactory)LookupServiceFacade.get(EntityFactory.class)).createWaypointNode();
        this.teachWaypointNode.setPositionNodeType(PositionNodeType.RELATIVE);
        this.teachWaypointNode.setRelativeFromPosition(this.wp.getOldJointPosition(), this.wp.getToolPosition(), this.wp.getToolAxisAngle());
        this.stackCurrentCardAndSwitchTo(MoveTab.class, this.teachWaypointNode);
    }
}

