/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.calibration.ProgramCorrespondencePointCard;
import com.ur.polyscope.calibration.RealNodeWrapperTreeNode;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.swing.CardPanel;
import gui.program.position.WaypointNode;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ProgramCorrespondencePointNode
extends RealNodeWrapperTreeNode {
    String name = "";
    Point3d toolPosition = null;
    Point3d toolAxisAngle = null;
    Point3d offsetPosition = null;
    Point3d offsetAxisAngle = null;
    JointPositionVector oldJointPosition = null;
    JointPositionVector teachedJointPosition = null;
    public transient int indexNumber = 0;
    public transient double error = 0.0;

    public void setName(String name) {
        this.name = name;
    }

    public void setOldJointPosition(JointPositionVector oldJointPosition) {
        if (this.oldJointPosition == null || !this.oldJointPosition.equals(oldJointPosition)) {
            this.oldJointPosition = oldJointPosition;
            this.somethingChanged();
        }
    }

    public void setToolAxisAngle(Point3d toolAxisAngle) {
        if (this.toolAxisAngle == null || !this.toolAxisAngle.equals((Tuple3d)toolAxisAngle)) {
            this.toolAxisAngle = toolAxisAngle;
            this.somethingChanged();
        }
    }

    public void setToolPosition(Point3d toolPosition) {
        if (this.toolPosition == null || !this.toolPosition.equals((Tuple3d)toolPosition)) {
            this.toolPosition = toolPosition;
            this.somethingChanged();
        }
    }

    public void setTeachedJointPosition(JointPositionVector TeachedJointPosition) {
        JointPositionVector position = new JointPositionVector(TeachedJointPosition);
        if (!this.teachedJointPosition.equals(position)) {
            this.teachedJointPosition = position;
            this.somethingChanged();
        }
    }

    public Point3d getOffsetAxisAngle() {
        return this.offsetAxisAngle;
    }

    public void setOffsetAxisAngle(Point3d offsetAxisAngle) {
        if (!this.offsetAxisAngle.equals((Tuple3d)offsetAxisAngle)) {
            this.offsetAxisAngle = offsetAxisAngle;
            this.somethingChanged();
        }
    }

    public Point3d getOffsetPosition() {
        return this.offsetPosition;
    }

    public void setOffsetPosition(Point3d offsetPosition) {
        if (offsetPosition != null && !this.offsetPosition.equals((Tuple3d)offsetPosition)) {
            this.offsetPosition = offsetPosition;
            this.somethingChanged();
        }
    }

    public JointPositionVector getTeachedJointPosition() {
        return this.teachedJointPosition;
    }

    public JointPositionVector getOldJointPosition() {
        return this.oldJointPosition;
    }

    public String getName() {
        return this.name;
    }

    public Point3d getToolAxisAngle() {
        return this.toolAxisAngle;
    }

    public Point3d getToolPosition() {
        return this.toolPosition;
    }

    public ProgramCorrespondencePointNode(WaypointNode wp, KinematicsCalibration parametersFromTheProgram) {
        super((AbstractProgramNode)wp);
        this.name = wp.toString();
        this.oldJointPosition = wp.getJointPositionVector();
        Transform3D end = parametersFromTheProgram.getBaseToEnd(this.oldJointPosition);
        Matrix3d rot = new Matrix3d();
        Vector3d pos = new Vector3d();
        end.get(rot, pos);
        this.toolPosition = new Point3d((Tuple3d)pos);
        AxisAngle4d rot4D = new AxisAngle4d();
        rot4D.set(rot);
        this.toolAxisAngle = new Point3d(rot4D.x * rot4D.angle, rot4D.y * rot4D.angle, rot4D.z * rot4D.angle);
        this.teachedJointPosition = this.oldJointPosition;
        this.offsetPosition = new Point3d(0.0, 0.0, 0.0);
        this.offsetAxisAngle = new Point3d(0.0, 0.0, 0.0);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Class<? extends CardPanel> getCardClass() {
        return ProgramCorrespondencePointCard.class;
    }

    public boolean isTeached() {
        return this.oldJointPosition != this.teachedJointPosition;
    }
}

