/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.calibration.ProgramTransProgramContainerNode;
import com.ur.polyscope.calibration.RealNodeWrapperTreeNode;
import com.ur.polyscope.calibration.programcorrection.ProgramTransKeyPairCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransPanel;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.swing.CardPanel;
import gui.program.position.WaypointNode;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ProgramTransKeyPairNode
extends RealNodeWrapperTreeNode {
    public transient double error = 0.0;
    String name = "";
    Point3d toolPosition = null;
    Point3d toolAxisAngle = null;
    JointPositionVector robot1JointPosition = null;
    ProgramTransProgramContainerNode programTransProgramContainerNode = null;
    private double[] correspondingToolPositionOffset = null;
    private ProgramTransPanel programTransPanel;

    public ProgramTransKeyPairNode(ProgramTransProgramContainerNode programRoot, WaypointNode wp, KinematicsCalibration parametersFromTheProgram, ProgramTransPanel programTransPanel) {
        super((AbstractProgramNode)wp);
        this.name = wp.toString();
        this.robot1JointPosition = wp.getJointPositionVector();
        this.programTransProgramContainerNode = programRoot;
        this.programTransPanel = programTransPanel;
        Transform3D end = parametersFromTheProgram.getBaseToEnd(this.robot1JointPosition);
        Matrix3d rot = new Matrix3d();
        Vector3d pos = new Vector3d();
        end.get(rot, pos);
        this.toolPosition = new Point3d((Tuple3d)pos);
        AxisAngle4d rot4D = new AxisAngle4d();
        rot4D.set(rot);
        this.toolAxisAngle = new Point3d(rot4D.x * rot4D.angle, rot4D.y * rot4D.angle, rot4D.z * rot4D.angle);
        this.correspondingToolPositionOffset = ((TCPSettings)programRoot.getRobotInstallation().getComponent(TCPSettings.class)).getSelectedTCP_Old().getOffsetPose().asArray();
        if (this.correspondingToolPositionOffset == null) {
            this.correspondingToolPositionOffset = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
    }

    public double[] getCorrespondingToolTransformationOffset() {
        return this.correspondingToolPositionOffset;
    }

    public void setCorrespondingToolTransformationOffset(double[] correspondingToolPosition) {
        this.correspondingToolPositionOffset = correspondingToolPosition;
    }

    public Point3d getCorrespondingToolOffset() {
        return new Point3d(this.correspondingToolPositionOffset[0], this.correspondingToolPositionOffset[1], this.correspondingToolPositionOffset[2]);
    }

    public JointPositionVector getRobot1JointPosition() {
        return this.robot1JointPosition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Point3d getToolAxisAngle() {
        return this.toolAxisAngle;
    }

    public void setToolAxisAngle(Point3d toolAxisAngle) {
        if (this.toolAxisAngle == null || !this.toolAxisAngle.equals((Tuple3d)toolAxisAngle)) {
            this.toolAxisAngle = toolAxisAngle;
            this.somethingChanged();
        }
    }

    public Point3d getToolPosition() {
        return this.toolPosition;
    }

    public void setToolPosition(Point3d toolPosition) {
        if (this.toolPosition == null || !this.toolPosition.equals((Tuple3d)toolPosition)) {
            this.toolPosition = toolPosition;
            this.somethingChanged();
        }
    }

    public ProgramTransProgramContainerNode getProgramTransProgramContainerNode() {
        return this.programTransProgramContainerNode;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Class<? extends CardPanel> getCardClass() {
        return ProgramTransKeyPairCard.class;
    }

    public boolean isReattached() {
        return this.programTransPanel.isReteached(this.robot1JointPosition);
    }
}

