/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.calibration.BasicTreeNode;
import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.NotAFixedWaypointNode;
import com.ur.polyscope.calibration.ProgramTransKeyPairNode;
import com.ur.polyscope.calibration.persistence.EventlessInstallationLoader;
import com.ur.polyscope.calibration.programcorrection.ProgramCorrectionHelper;
import com.ur.polyscope.calibration.programcorrection.ProgramTransPanel;
import com.ur.polyscope.calibration.programcorrection.ProgramTransProgramCard;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.PositionType;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.swing.CardPanel;
import com.ur.util.CollectionUtils;
import com.ur.util.logging.Log;
import gui.program.FileManagementProgramComponent;
import gui.program.MainProgram;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.calibration.KinematicDataComponent;
import gui.program.calibration.ProgramCorrectionKinematicStrategy;
import gui.program.position.WaypointNode;
import java.io.File;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Provider;

public class ProgramTransProgramContainerNode
extends BasicTreeNode {
    private final ProgramTransPanel programTransPanel;
    private ProgramRootNode loadedProgram = null;
    private Installation robotInstallation = null;
    private String placeName = "";
    private EventlessInstallationLoader eventlessInstallationLoader;
    private ProgramCorrectionKinematicStrategy kinematicStrategy;
    private Provider<KinematicsCalibration> kinematicsProvider;

    @Inject
    public ProgramTransProgramContainerNode(EventlessInstallationLoader eventlessInstallationLoader, ProgramTransPanel programTransPanel, ProgramCorrectionKinematicStrategy kinematicStrategy, Provider<KinematicsCalibration> kinematicsProvider) {
        this.eventlessInstallationLoader = eventlessInstallationLoader;
        this.programTransPanel = programTransPanel;
        this.kinematicStrategy = kinematicStrategy;
        this.kinematicsProvider = kinematicsProvider;
    }

    public Installation getRobotInstallation() {
        return this.robotInstallation;
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    @Override
    public Class<? extends CardPanel> getCardClass() {
        return ProgramTransProgramCard.class;
    }

    public boolean isProgramForThisRobot(RobotIdentification serialNumber) {
        if (FeatureToggle.isActive((String)"bypass-same-robot-check")) {
            return false;
        }
        return ((ProgramMetaDataComponent)this.getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification().equals(serialNumber);
    }

    public LoadProgram loadProgram(File programFile) {
        try {
            this.loadedProgram = ProgramRootNodeLoad.deserializeProgram((File)programFile);
            if (((KinematicDataComponent)this.loadedProgram.getComponent(KinematicDataComponent.class)).getKinematics() == null) {
                return LoadProgram.MISSING_KINEMATICS;
            }
            if (((KinematicDataComponent)this.loadedProgram.getComponent(KinematicDataComponent.class)).getKinematics().getJointChecksum() == null) {
                return LoadProgram.MISSING_KINEMATICS_CHECKSUM;
            }
            boolean prepareKinematicsCalibrationResult = this.kinematicStrategy.prepareProgramKinematicsCalibrationForCorrection(this.loadedProgram, (KinematicsCalibration)this.kinematicsProvider.get());
            if (!prepareKinematicsCalibrationResult) {
                return LoadProgram.FAILED_TO_LOAD;
            }
            this.robotInstallation = this.eventlessInstallationLoader.loadRobotInstallation(programFile, this.loadedProgram);
            if (Log.canLog((Log.Level)Log.Level.TRACE)) {
                Enumeration e = this.loadedProgram.children();
                while (e.hasMoreElements()) {
                    Log.trace((String)("" + e.nextElement()));
                }
            }
            this.extractProgram(this.loadedProgram.getMainProgram());
            this.setPlaceName(((FileManagementProgramComponent)this.loadedProgram.getComponent(FileManagementProgramComponent.class)).getInstallationFileName());
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            return LoadProgram.FAILED_TO_LOAD;
        }
        return LoadProgram.SUCCESS;
    }

    public void extractProgram(MainProgram program) {
        Log.debug((String)("ProgramContainerNode.loadedProgram isSpecified " + this.loadedProgram.getMainProgram().getChildCount() + " children"));
        this.extractNode((AbstractProgramNode)program, this);
    }

    private void extractNode(AbstractProgramNode programNode, BasicTreeNode treeNode) {
        for (AbstractProgramNode tmpNode : CollectionUtils.filter((Enumeration)programNode.children(), AbstractProgramNode.class)) {
            BasicTreeNode newTreeNode = this.newProgramTreeNode(tmpNode);
            this.extractNode(tmpNode, newTreeNode);
            CalibrationTreeContainer.getInstance().addNode(newTreeNode, treeNode);
        }
    }

    private BasicTreeNode newProgramTreeNode(AbstractProgramNode programNode) {
        String displayText = "Not a fixed waypoint";
        if (programNode instanceof WaypointNode) {
            WaypointNode tmpWP = (WaypointNode)programNode;
            if (ProgramCorrectionHelper.waypointIsEligibleForProgramCorrection(tmpWP)) {
                return new ProgramTransKeyPairNode(this, (WaypointNode)programNode, ((KinematicDataComponent)this.loadedProgram.getComponent(KinematicDataComponent.class)).getKinematics(), this.programTransPanel);
            }
            if (tmpWP.getPositionNodeType() != PositionNodeType.FIXED && tmpWP.getMotionDefiningNode().getPositionType() != PositionType.JOINT_ANGLES) {
                displayText = "Joint Angle Moves not supported";
            }
        }
        return new NotAFixedWaypointNode(programNode, displayText);
    }

    public ProgramRootNode getLoadedProgram() {
        return this.loadedProgram;
    }

    @Override
    public String toString() {
        if (this.loadedProgram != null) {
            return "P:" + this.getLoadedProgram().getName();
        }
        return "P:<select program>";
    }

    public static enum LoadProgram {
        SUCCESS,
        MISSING_KINEMATICS,
        MISSING_KINEMATICS_CHECKSUM,
        FAILED_TO_LOAD;

    }
}

