/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.communication;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.calibration.ProgramCorrespondencePointNode;
import com.ur.polyscope.calibration.programcorrection.ProgramCorrectionHelper;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.util.logging.Log;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicDataComponent;
import gui.program.position.WaypointNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Enumeration;
import java.util.Vector;
import javax.inject.Inject;
import javax.vecmath.Point3d;

public class CalibCommProtocol {
    private static final String FAILED_TO_SEND = "Failed to send";
    private static final String FAILED_TO_RECEIVE = "Failed to receive";
    private static RobotIdentificationProvider robotIdentificationProvider;

    @Inject
    public static void setRobotIdentificationProvider(RobotIdentificationProvider robotIdentificationProvider) {
        CalibCommProtocol.robotIdentificationProvider = robotIdentificationProvider;
    }

    public static void sendMessage(int packetType, String message, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendString(message, out);
        }
        catch (Exception e) {
            Log.error((String)"Failed to send message", (Throwable)e);
        }
    }

    public static void sendCommand(int packetType, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
        }
        catch (Exception e) {
            Log.error((String)"Failed to send command", (Throwable)e);
        }
    }

    public static void sendCommand(int packetType, int argument, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendInt(argument, out);
        }
        catch (Exception e) {
            Log.error((String)"Failed to send command", (Throwable)e);
        }
    }

    public static void sendPacketWithSelectedParametersAndTestNodes(int packetType, Vector<Vector<String>> selectedParameters, Vector<ProgramCorrespondencePointNode> testPoints, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendSelectedParameters(selectedParameters, out);
            CalibCommProtocol.sendTestNodeVector(testPoints, out);
        }
        catch (Exception e) {
            Log.error((String)"Failed to send packet with selected parameters and test Nodes", (Throwable)e);
        }
    }

    public static void sendPacketWithIntAndString(int packetType, int checksum, RobotIdentification robotIdentification, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendInt(checksum, out);
            CalibCommProtocol.sendRobotID(robotIdentification, out);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    public static void sendPacketWithIntAnd2Strings(int packetType, int checksum, RobotIdentification robotIdentification, String str2, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendInt(checksum, out);
            CalibCommProtocol.sendRobotID(robotIdentification, out);
            CalibCommProtocol.sendString(str2, out);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    public static void sendPacketWithTwoInts(int packetType, int i1, int i2, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendInt(i1, out);
            CalibCommProtocol.sendInt(i2, out);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    public static void sendPacketWith2Strings(int packetType, String str1, String str2, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendString(str1, out);
            CalibCommProtocol.sendString(str2, out);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    public static void sendPacketWithKeyPair(int packetType, int checksum1, RobotIdentification robotName1, String place1, double[] q1, int checksum2, RobotIdentification robotName2, String place2, double[] q2, String name, double[] ctp, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(packetType, out);
            CalibCommProtocol.sendInt(checksum1, out);
            CalibCommProtocol.sendRobotID(robotName1, out);
            CalibCommProtocol.sendString(place1, out);
            CalibCommProtocol.sendInt(checksum2, out);
            CalibCommProtocol.sendRobotID(robotName2, out);
            CalibCommProtocol.sendString(place2, out);
            CalibCommProtocol.sendDoubleVector(q1, out);
            if (q2 != null) {
                CalibCommProtocol.sendDoubleVector(q2, out);
                CalibCommProtocol.sendString(name, out);
                CalibCommProtocol.sendDoubleVector(ctp, out);
            }
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    public static int receiveInt(DataInput in) {
        int i = 0;
        try {
            int length = in.readInt();
            if (length != 4) {
                Log.error((String)("receiveInt receiveing " + length + "bytes, Only use the first four"));
            }
            if (length > 0) {
                i = in.readInt();
            } else {
                Log.error((String)("Length was " + length));
            }
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_RECEIVE, (Throwable)e);
        }
        return i;
    }

    public static double receiveDouble(DataInput in) {
        double i = 0.0;
        try {
            int length = in.readInt();
            if (length != 8) {
                Log.error((String)("receiveInt receiveing " + length + "bytes, Only use the first"));
            }
            i = in.readDouble();
        }
        catch (Exception e) {
            Log.error((String)"CalibCommProtocol.receiveDouble() Error: ", (Throwable)e);
        }
        Log.debug((String)(" Double(" + i + ")"));
        return i;
    }

    public static RobotIdentification receiveRobotIdentification(DataInput in) {
        return robotIdentificationProvider.fromStringHydrateProgram(CalibCommProtocol.receiveString(in));
    }

    public static String receiveString(DataInput in) {
        String output = "";
        try {
            int parameterLength = in.readInt();
            Log.debug((String)("Received " + parameterLength + " bytes"));
            StringBuilder builder = new StringBuilder("");
            for (int i = 0; i < parameterLength; ++i) {
                builder.append(Character.toChars(in.readByte()));
            }
            output = builder.toString();
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_RECEIVE, (Throwable)e);
        }
        return output;
    }

    public static String[] receiveStringArray(DataInput in) {
        String[] sv = null;
        try {
            int size = CalibCommProtocol.receiveInt(in);
            sv = new String[size];
            for (int i = 0; i < size; ++i) {
                sv[i] = CalibCommProtocol.receiveString(in);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to receive message", (Throwable)e);
        }
        return sv;
    }

    public static int[] receiveIntArray(DataInput in) {
        int[] dv = null;
        try {
            int size = CalibCommProtocol.receiveInt(in);
            dv = new int[size];
            for (int i = 0; i < size; ++i) {
                dv[i] = CalibCommProtocol.receiveInt(in);
            }
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_RECEIVE, (Throwable)e);
        }
        return dv;
    }

    public static double[] receiveDoubleArray(DataInput in) {
        double[] dv = null;
        try {
            int size = CalibCommProtocol.receiveInt(in);
            dv = new double[size];
            for (int i = 0; i < size; ++i) {
                dv[i] = CalibCommProtocol.receiveDouble(in);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to send Double Array", (Throwable)e);
        }
        return dv;
    }

    public static Vector<JointPositionVector> receiveJointPositionVector(DataInput in) {
        try {
            int size = CalibCommProtocol.receiveInt(in);
            Vector<JointPositionVector> out = new Vector<JointPositionVector>();
            for (int i = 0; i < size; ++i) {
                out.add(CalibCommProtocol.receiveJointPosition(in));
            }
            return out;
        }
        catch (Exception e) {
            Log.error((String)"Failed to create vector", (Throwable)e);
            return new Vector<JointPositionVector>();
        }
    }

    public static void sendApplyWithChecksum(DataOutput out, KinematicsCalibration kinematicsCalibration) {
        try {
            kinematicsCalibration.getJointChecksum();
        }
        catch (Exception e) {
            Log.error((String)"Missing joint check sum information: ", (Throwable)e);
            CalibCommProtocol.sendMessage(1, "Missing joint check sum information ", out);
            return;
        }
        try {
            CalibCommProtocol.sendInt(515, out);
            CalibCommProtocol.sendIntVector(kinematicsCalibration.getJointChecksum(), out);
        }
        catch (Exception e) {
            Log.error((String)"Could not send: ", (Throwable)e);
        }
    }

    public static void sendCorrectProgramRequest(int packetType, String place1, String place2, ProgramRootNode program, RobotIdentification robotIdentification, DataOutput out, KinematicsCalibration kinematicsCalibration) {
        CalibCommProtocol.sendInt(packetType, out);
        CalibCommProtocol.sendInt(((KinematicDataComponent)program.getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), out);
        CalibCommProtocol.sendRobotID(((ProgramMetaDataComponent)program.getComponent(ProgramMetaDataComponent.class)).getRobotIdentification(), out);
        CalibCommProtocol.sendString(place1, out);
        CalibCommProtocol.sendInt(kinematicsCalibration.getMergedChecksumIfValid(), out);
        CalibCommProtocol.sendRobotID(robotIdentification, out);
        CalibCommProtocol.sendString(place2, out);
        CalibCommProtocol.sendKinematicsParamter(((KinematicDataComponent)program.getComponent(KinematicDataComponent.class)).getKinematics(), out);
        CalibCommProtocol.sendKinematicsParamter(kinematicsCalibration, out);
        Vector<JointPositionVector> configurationsNeededToBeCorrected = new Vector<JointPositionVector>();
        Enumeration e = program.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            WaypointNode tmpWNode;
            Object o = e.nextElement();
            if (!(o instanceof WaypointNode) || !ProgramCorrectionHelper.waypointIsEligibleForProgramCorrection(tmpWNode = (WaypointNode)o)) continue;
            configurationsNeededToBeCorrected.add(tmpWNode.getJointPositionVector());
        }
        CalibCommProtocol.sendJointPositionVector(configurationsNeededToBeCorrected, out);
    }

    private static JointPositionVector receiveJointPosition(DataInput in) {
        double[] outputArray = CalibCommProtocol.receiveDoubleArray(in);
        if (outputArray.length > 6) {
            Log.error((String)(" receiveing " + outputArray.length + " doubles, use only the first six"));
        } else if (outputArray.length < 5) {
            Log.error((String)("Receiveing " + outputArray.length + " doubles, need six, returning null"));
            return null;
        }
        return new JointPositionVector(outputArray);
    }

    private static void sendTestNode(ProgramCorrespondencePointNode in, DataOutput out) {
        CalibCommProtocol.sendString(in.getName(), out);
        CalibCommProtocol.sendJointPosition(in.getOldJointPosition(), out);
        CalibCommProtocol.sendPoint3d(in.getToolPosition(), out);
        CalibCommProtocol.sendPoint3d(in.getToolAxisAngle(), out);
        CalibCommProtocol.sendPoint3d(in.getOffsetPosition(), out);
        CalibCommProtocol.sendPoint3d(in.getOffsetAxisAngle(), out);
        CalibCommProtocol.sendJointPosition(in.getTeachedJointPosition(), out);
        CalibCommProtocol.sendInt(in.indexNumber, out);
    }

    private static void sendTestNodeVector(Vector<ProgramCorrespondencePointNode> in, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(in.size(), out);
            for (int i = 0; i < in.size(); ++i) {
                CalibCommProtocol.sendTestNode(in.elementAt(i), out);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to send test Node vector", (Throwable)e);
        }
    }

    private static void sendSelectedParameters(Vector<Vector<String>> sp, DataOutput out) {
        CalibCommProtocol.sendInt(sp.size(), out);
        for (int j = 0; j < sp.size(); ++j) {
            CalibCommProtocol.sendInt(sp.elementAt(j).size(), out);
            for (int p = 0; p < sp.elementAt(j).size(); ++p) {
                CalibCommProtocol.sendString(sp.elementAt(j).elementAt(p), out);
                byte checked = 15;
                CalibCommProtocol.sendByte(checked, out);
            }
        }
    }

    private static void sendKinematicsParamter(KinematicsCalibration kinematik, DataOutput out) {
        CalibCommProtocol.sendDoubleVector(kinematik.getDeltaTheta(), out);
        CalibCommProtocol.sendDoubleVector(kinematik.getD(), out);
        CalibCommProtocol.sendDoubleVector(kinematik.getAlpha(), out);
        CalibCommProtocol.sendDoubleVector(kinematik.getA(), out);
        CalibCommProtocol.sendIntVector(kinematik.getJointChecksum(), out);
        CalibCommProtocol.sendInt(kinematik.getMergedChecksumIfValid(), out);
    }

    private static void sendByte(byte i, DataOutput out) {
        try {
            out.writeInt(1);
            out.writeByte(i);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    private static void sendInt(int i, DataOutput out) {
        try {
            out.writeInt(4);
            out.writeInt(i);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    private static void sendPoint3d(Point3d in, DataOutput out) {
        double[] outputArray = new double[3];
        in.get(outputArray);
        CalibCommProtocol.sendDoubleVector(outputArray, out);
    }

    private static void sendJointPosition(JointPositionVector in, DataOutput out) {
        double[] outputArray = in.getJoints();
        CalibCommProtocol.sendDoubleVector(outputArray, out);
    }

    private static void sendJointPositionVector(Vector<JointPositionVector> in, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(in.size(), out);
            for (JointPositionVector jpv : in) {
                CalibCommProtocol.sendJointPosition(jpv, out);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to send JointPosition", (Throwable)e);
        }
    }

    private static void sendIntVector(int[] in, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(in.length, out);
            for (int i : in) {
                CalibCommProtocol.sendInt(i, out);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to send message", (Throwable)e);
        }
    }

    private static void sendDoubleVector(double[] in, DataOutput out) {
        try {
            CalibCommProtocol.sendInt(in.length, out);
            for (double v : in) {
                CalibCommProtocol.sendDouble(v, out);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to send double", (Throwable)e);
        }
    }

    private static void sendRobotID(RobotIdentification robotIdentification, DataOutput out) {
        CalibCommProtocol.sendString(robotIdentification.getSerialNumber().getSerialNumber(), out);
    }

    private static void sendString(String str, DataOutput out) {
        try {
            int parameterLength = str.length();
            out.writeInt(parameterLength);
            if (parameterLength > 0) {
                for (int i = 0; i < parameterLength; ++i) {
                    out.writeByte(str.charAt(i));
                }
            }
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }

    private static void sendDouble(double i, DataOutput out) {
        try {
            out.writeInt(8);
            out.writeDouble(i);
        }
        catch (Exception e) {
            Log.error((String)FAILED_TO_SEND, (Throwable)e);
        }
    }
}

