/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.communication;

import com.ur.i18n.TextResource;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.calibration.ProgramTransOverviewKeyPairNode;
import com.ur.polyscope.calibration.ProgramTransOverviewPlaceNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRobotPairNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRoot;
import com.ur.polyscope.calibration.communication.CalibCommProtocol;
import com.ur.polyscope.calibration.communication.CalibrationResult;
import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.communication.ICalibBasicSocketReceiveActionList;
import com.ur.polyscope.calibration.communication.ICalibDualRobotSocketReceiveActionList;
import com.ur.polyscope.calibration.communication.ICalibSocketSendActionList;
import com.ur.polyscope.calibration.programcorrection.ProgramTransPanel;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.WarningMessage;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.CalibrationVerificationType;
import gui.program.ProgramRootNode;
import gui.tools.DialogCreator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;

public class CalibrationClientSocket
extends Thread
implements ICalibSocketSendActionList {
    public static final int MAX_LENGTH_SKIPPED_WAYPOINT_MESSAGE = 150;
    static final int PROCEED_COMMAND = 1;
    static final int ABORT_COMMAND = 2;
    private static final int END_SOCKET = 0;
    private static final int DUAL_ROBOT_RESULTS = 1298;
    private static final int DUAL_ROBOT_CALIBRATION = 1297;
    private static final int DUAL_ROBOT_CALIBRATION_POPUP_MESSAGE = 1283;
    private static final int ROBOT_PAIR = 1049;
    private static final int KEY_MAP_PAIRS = 1047;
    private static final int KEY_PAIR_DATA = 1046;
    private static final int ROBOT_PLACE_LIST = 1041;
    private static final int UPDATE_ERROR = 521;
    private static final int PARAMETER_LOG = 520;
    private static final int CALIBRATION_STATUS_CODE = 516;
    private static final int CALIBRATION_LOG = 512;
    private static final int STATUS_MESSAGE = 3;
    private static final int WARNING_MESSAGE = 2;
    private static final int ERROR_MESSAGE = 1;
    private static final int PROGRAM_CORRECTION_STATUS_MESSAGE = 1024;
    private boolean shutdown = true;
    private String host = "";
    private int port = 0;
    private DataInputStream in = null;
    private Socket clientSocket = null;
    private DataOutputStream out = null;
    private ICalibBasicSocketReceiveActionList basicActionList = null;
    private Provider<ProgramTransPanel> programTransProvider = null;
    private ICalibDualRobotSocketReceiveActionList dualRobotCalib = new DualRobotCalibState();
    private DialogCreator dialogCreator;
    private TextResource textResource;
    private Provider<RobotIdentification> robotIdentificationProvider;
    private Provider<KinematicsCalibration> kinematicsProvider;

    public CalibrationClientSocket(String host, int port, ICalibBasicSocketReceiveActionList basicActionList, DialogCreator dialogCreator, Provider<RobotIdentification> robotIdentificationProvider, Provider<KinematicsCalibration> kinematicsProvider, TextResource textResource) {
        this.host = host;
        this.port = port;
        this.basicActionList = basicActionList;
        this.dialogCreator = dialogCreator;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.kinematicsProvider = kinematicsProvider;
        this.textResource = textResource;
    }

    public void setProgramTransProvider(Provider<ProgramTransPanel> programTransProvider) {
        this.programTransProvider = programTransProvider;
    }

    public DataInputStream getIn() {
        return this.in;
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public void run() {
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.clientSocket = new Socket(this.host, this.port);
            }
            catch (Exception e) {
                this.clientSocket = null;
            }
            if (this.clientSocket != null) {
                try {
                    this.in = new DataInputStream(this.clientSocket.getInputStream());
                    this.out = new DataOutputStream(this.clientSocket.getOutputStream());
                }
                catch (Exception e) {
                    this.in = null;
                    this.out = null;
                    Log.error((String)"DataInput/OutputStream failed");
                }
                while (this.clientSocket.isConnected() && this.receive(CalibCommProtocol.receiveInt(this.in))) {
                }
                try {
                    this.in.close();
                    this.out.close();
                    this.clientSocket.close();
                    Log.error((String)"socket closed");
                }
                catch (Exception e) {
                    Log.error((String)"socket connection failed2");
                }
                this.in = null;
                this.out = null;
            }
            try {
                CalibrationClientSocket.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown = true;
        super.finalize();
    }

    public boolean receive(int messageType) {
        int checksum1 = 0;
        int checksum2 = 0;
        String place1 = "";
        String place2 = "";
        double[] q1 = null;
        double[] q2 = null;
        double[] ctp = null;
        String waypointName = "";
        int messageCode = 0;
        String messageStr = "";
        Log.debug((String)("calib receive packet type " + Integer.toHexString(messageType)));
        block1 : switch (messageType) {
            case 0: {
                ((ProgramTransPanel)this.programTransProvider.get()).endSocket();
                return false;
            }
            case 1: {
                this.basicActionList.receiveErrorMessage(CalibCommProtocol.receiveString(this.in));
                break;
            }
            case 2: {
                this.basicActionList.receiveWarningMessage(CalibCommProtocol.receiveString(this.in));
                break;
            }
            case 3: {
                this.basicActionList.receiveStatusMessage(CalibCommProtocol.receiveString(this.in));
                CalibCommProtocol.receiveString(this.in);
                break;
            }
            case 512: {
                CalibCommProtocol.receiveString(this.in);
                break;
            }
            case 516: {
                CalibCommProtocol.receiveInt(this.in);
                break;
            }
            case 520: {
                CalibCommProtocol.receiveString(this.in);
                break;
            }
            case 521: {
                CalibCommProtocol.receiveIntArray(this.in);
                CalibCommProtocol.receiveDoubleArray(this.in);
                break;
            }
            case 1041: {
                int checksum = CalibCommProtocol.receiveInt(this.in);
                String robotName = CalibCommProtocol.receiveString(this.in);
                String[] places = CalibCommProtocol.receiveStringArray(this.in);
                ((ProgramTransPanel)this.programTransProvider.get()).receiveRobotPlace(checksum, robotName, places);
                break;
            }
            case 1046: {
                checksum1 = CalibCommProtocol.receiveInt(this.in);
                RobotIdentification robotName1 = CalibCommProtocol.receiveRobotIdentification(this.in);
                place1 = CalibCommProtocol.receiveString(this.in);
                checksum2 = CalibCommProtocol.receiveInt(this.in);
                RobotIdentification robotName2 = CalibCommProtocol.receiveRobotIdentification(this.in);
                place2 = CalibCommProtocol.receiveString(this.in);
                q1 = CalibCommProtocol.receiveDoubleArray(this.in);
                q2 = CalibCommProtocol.receiveDoubleArray(this.in);
                waypointName = CalibCommProtocol.receiveString(this.in);
                ctp = CalibCommProtocol.receiveDoubleArray(this.in);
                double error = CalibCommProtocol.receiveDouble(this.in);
                ((ProgramTransPanel)this.programTransProvider.get()).receiveCorrespondingKey(checksum1, robotName1, place1, q1, checksum2, robotName2, place2, q2, ctp, error);
                break;
            }
            case 1047: {
                HashMap<JointPositionVector, JointPositionVector> reteachedMap = new HashMap<JointPositionVector, JointPositionVector>();
                ProgramTransOverviewRoot treeroot = new ProgramTransOverviewRoot();
                int robotplacePairLength = CalibCommProtocol.receiveInt(this.in);
                for (int i = 0; i < robotplacePairLength; ++i) {
                    checksum1 = CalibCommProtocol.receiveInt(this.in);
                    RobotIdentification robotName1 = CalibCommProtocol.receiveRobotIdentification(this.in);
                    place1 = CalibCommProtocol.receiveString(this.in);
                    checksum2 = CalibCommProtocol.receiveInt(this.in);
                    RobotIdentification robotName2 = CalibCommProtocol.receiveRobotIdentification(this.in);
                    place2 = CalibCommProtocol.receiveString(this.in);
                    DefaultMutableTreeNode rp = null;
                    Enumeration<TreeNode> e = treeroot.children();
                    while (e.hasMoreElements()) {
                        ProgramTransOverviewRobotPairNode tmpRp;
                        DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                        if (!(current instanceof ProgramTransOverviewRobotPairNode) || (tmpRp = (ProgramTransOverviewRobotPairNode)current).getChecksum1() != checksum1 || tmpRp.getChecksum2() != checksum2 || !tmpRp.getRobotName1().equals(robotName1) || !tmpRp.getRobotName2().equals(robotName2)) continue;
                        rp = tmpRp;
                        break;
                    }
                    if (rp == null) {
                        rp = new ProgramTransOverviewRobotPairNode(checksum1, robotName1, checksum2, robotName2);
                        treeroot.add(rp);
                    }
                    ProgramTransOverviewPlaceNode inst = null;
                    Enumeration<TreeNode> e2 = rp.children();
                    while (e2.hasMoreElements()) {
                        ProgramTransOverviewPlaceNode tmpInst;
                        DefaultMutableTreeNode current = (DefaultMutableTreeNode)e2.nextElement();
                        if (!(current instanceof ProgramTransOverviewPlaceNode) || !(tmpInst = (ProgramTransOverviewPlaceNode)current).getRobotPlace1().equals(place1) || !tmpInst.getRobotPlace2().equals(place2)) continue;
                        inst = tmpInst;
                        break;
                    }
                    if (inst == null) {
                        inst = new ProgramTransOverviewPlaceNode(place1, place2);
                        rp.add(inst);
                    }
                    int keyPairLength = CalibCommProtocol.receiveInt(this.in);
                    for (int j = 0; j < keyPairLength; ++j) {
                        q1 = CalibCommProtocol.receiveDoubleArray(this.in);
                        q2 = CalibCommProtocol.receiveDoubleArray(this.in);
                        waypointName = CalibCommProtocol.receiveString(this.in);
                        ctp = CalibCommProtocol.receiveDoubleArray(this.in);
                        ProgramTransOverviewKeyPairNode kp = new ProgramTransOverviewKeyPairNode(new JointPositionVector(q1), new JointPositionVector(q2), waypointName, ctp);
                        inst.add(kp);
                        if (reteachedMap.containsKey(new JointPositionVector(q1))) continue;
                        reteachedMap.put(new JointPositionVector(q1), new JointPositionVector(q2));
                    }
                }
                ((ProgramTransPanel)this.programTransProvider.get()).receiveReteachedWaypoints(reteachedMap);
                ((ProgramTransPanel)this.programTransProvider.get()).receiveKeyMap(treeroot);
                break;
            }
            case 1049: {
                checksum1 = CalibCommProtocol.receiveInt(this.in);
                RobotIdentification robotName1 = CalibCommProtocol.receiveRobotIdentification(this.in);
                place1 = CalibCommProtocol.receiveString(this.in);
                checksum2 = CalibCommProtocol.receiveInt(this.in);
                RobotIdentification robotName2 = CalibCommProtocol.receiveRobotIdentification(this.in);
                place2 = CalibCommProtocol.receiveString(this.in);
                Vector<JointPositionVector> original = CalibCommProtocol.receiveJointPositionVector(this.in);
                Vector<JointPositionVector> corrected = CalibCommProtocol.receiveJointPositionVector(this.in);
                List<String> skippedWaypointNodes = ((ProgramTransPanel)this.programTransProvider.get()).receiveCorrectedProgramConfigurations(checksum1, robotName1, place1, checksum2, robotName2, place2, original, corrected);
                if (skippedWaypointNodes == null || skippedWaypointNodes.size() <= 0) break;
                String skippedWaypoints = StringUtils.join(skippedWaypointNodes, (String)", ");
                String message = skippedWaypointNodes.size() > 1 ? this.textResource.programCorrectionWaypointsSkippedPlural() : this.textResource.programCorrectionWaypointsSkipped();
                Log.warning((String)(message + skippedWaypoints));
                if (skippedWaypoints.length() > 150) {
                    skippedWaypoints = skippedWaypoints.substring(0, 150) + "...";
                }
                this.dialogCreator.showWarningMessageDialog(new WarningMessage(this.textResource.programCorrection(), message + skippedWaypoints), null);
                break;
            }
            case 1283: {
                messageCode = CalibCommProtocol.receiveInt(this.in);
                int id = CalibCommProtocol.receiveInt(this.in);
                String messageTitle = CalibCommProtocol.receiveString(this.in);
                messageStr = CalibCommProtocol.receiveString(this.in);
                switch (messageCode) {
                    case 1: {
                        this.dialogCreator.showMessageDialog(new DialogMessage(messageTitle, messageStr), MessageDialogType.MESSAGE, null);
                        break block1;
                    }
                    case 2: {
                        this.showConfirmationDialog(id, messageTitle, messageStr);
                        break block1;
                    }
                }
                break;
            }
            case 1297: {
                messageCode = CalibCommProtocol.receiveInt(this.in);
                messageStr = CalibCommProtocol.receiveString(this.in);
                this.dualRobotCalib.receiveMessageCode(messageCode, messageStr);
                Log.debug((String)("Dual Robot Calib socket receive messageCode '0x" + Integer.toHexString(messageCode) + "' with string: '" + messageStr + "'"));
                break;
            }
            case 1298: {
                messageCode = CalibCommProtocol.receiveInt(this.in);
                double tmp1 = CalibCommProtocol.receiveDouble(this.in);
                double tmp2 = CalibCommProtocol.receiveDouble(this.in);
                double tmp3 = CalibCommProtocol.receiveDouble(this.in);
                double tmp4 = CalibCommProtocol.receiveDouble(this.in);
                double tmp5 = CalibCommProtocol.receiveDouble(this.in);
                double tmp6 = CalibCommProtocol.receiveDouble(this.in);
                double tmp7 = CalibCommProtocol.receiveDouble(this.in);
                double tmp8 = CalibCommProtocol.receiveDouble(this.in);
                this.dualRobotCalib.receiveResults(messageCode, new CalibrationResult(tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7, tmp8));
                break;
            }
            case 1024: {
                Log.debug((String)("Program Correction status message: " + CalibCommProtocol.receiveString(this.in)));
                break;
            }
            default: {
                Log.error((String)("Calib socket receive unexpected packet type: " + messageType));
                try {
                    while (this.in.available() > 0) {
                        this.in.readByte();
                    }
                    break;
                }
                catch (Exception e) {
                    Log.error((String)"sendInt failed");
                }
            }
        }
        return true;
    }

    void showConfirmationDialog(final int id, String title, String message) {
        ConfirmationMessage confirmationMessage = new ConfirmationMessage(title, message, "Proceed >", "Abort Calibration");
        confirmationMessage.setId(id);
        ConfirmationDialogListener okCancelDialogListener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                CalibrationClientSocket.this.sendPopupDialogResponse(id, 1);
            }

            public void onCancelClicked() {
                CalibrationClientSocket.this.sendPopupDialogResponse(id, 2);
            }
        };
        this.dialogCreator.showConfirmationDialog(confirmationMessage, okCancelDialogListener);
    }

    @Override
    public boolean isConnected() {
        if (this.clientSocket == null) {
            return false;
        }
        return this.clientSocket.isConnected();
    }

    public synchronized boolean reconnect() {
        if (this.out != null) {
            return true;
        }
        boolean connectionOk = Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return CalibrationClientSocket.this.out != null;
            }
        }, (int)300, (TimeUnit)TimeUnit.MILLISECONDS);
        if (!connectionOk) {
            Log.error((String)"Socket connection to calibration backend failed");
        }
        return connectionOk;
    }

    @Override
    public void sendQuitRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(16, this.out);
        }
    }

    @Override
    public void sendPacketProgramTrans_ListRobotPlaneRequest(int checksum, RobotIdentification robotName) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithIntAndString(1025, checksum, robotName, this.out);
        }
    }

    @Override
    public void sendPacketProgramTrans_AddRobotPlace(int checksum, RobotIdentification robotName, String placename) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithIntAnd2Strings(1026, checksum, robotName, placename, this.out);
        }
    }

    @Override
    public void sendPacketProgramTrans_RemoveRobotPlace(int checksum, RobotIdentification robotName, String placename) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithIntAnd2Strings(1027, checksum, robotName, placename, this.out);
            this.updateReteachedWaypoints();
        }
    }

    @Override
    public void sendPacketProgramTrans_AddKeyPair(int checksum1, RobotIdentification robotName1, String placename1, double[] q1, int checksum2, RobotIdentification robotName2, String placename2, double[] q2, String name, double[] ctp) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithKeyPair(1028, checksum1, robotName1, placename1, q1, checksum2, robotName2, placename2, q2, name, ctp, this.out);
            this.updateReteachedWaypoints();
        }
    }

    @Override
    public void sendPacketProgramTrans_RemoveKeyPair(int checksum1, RobotIdentification robotName1, String placename1, double[] q1, int checksum2, RobotIdentification robotName2, String placename2, double[] q2) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithKeyPair(1029, checksum1, robotName1, placename1, q1, checksum2, robotName2, placename2, q2, "", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, this.out);
            this.updateReteachedWaypoints();
        }
    }

    private void updateReteachedWaypoints() {
        this.sendPacketProgramTrans_KeyPairMapRequest(((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid(), (RobotIdentification)this.robotIdentificationProvider.get());
    }

    @Override
    public void sendPacketProgramTrans_CorrespondingKeyRequest(int checksum1, RobotIdentification robotName1, String placename1, double[] q1, int checksum2, RobotIdentification robotName2, String placename2) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithKeyPair(1030, checksum1, robotName1, placename1, q1, checksum2, robotName2, placename2, null, "", null, this.out);
        }
    }

    @Override
    public void sendPacketProgramTrans_KeyPairMapRequest(int checksum, RobotIdentification robotIdentification) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithIntAndString(1031, checksum, robotIdentification, this.out);
        }
    }

    @Override
    public void sendPacketProgramTrans_save() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1032, this.out);
        }
    }

    @Override
    public void sendPacketProgramTrans_CorrectProgramRequest(String place1, String place2, ProgramRootNode program) {
        if (this.reconnect()) {
            CalibCommProtocol.sendCorrectProgramRequest(1033, place1, place2, program, (RobotIdentification)this.robotIdentificationProvider.get(), this.out, (KinematicsCalibration)this.kinematicsProvider.get());
        }
    }

    public void sendPackeDualcalib_disconnectResetAndFlushRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1293, this.out);
        }
    }

    @Override
    public void sendPackeDualcalib_setHostNameRequest(String hostnameRobot1, String hostnameRobot2) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWith2Strings(1281, hostnameRobot1, hostnameRobot2, this.out);
        }
    }

    public void sendPackeDualcalib_sendStopRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1282, this.out);
        }
    }

    public void sendPackeDualcalib_sendStartManualRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1283, this.out);
        }
    }

    public void sendPackeDualcalib_sendStartAutoRequest(int argument) {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1284, argument, this.out);
        }
    }

    public void sendPackeDualcalib_sendStartCalibRequest(int argument) {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1285, argument, this.out);
        }
    }

    public void sendPackeDualcalib_sendSaveCalibRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1286, this.out);
        }
    }

    public void sendPackeDualcalib_sendApplyCalibRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1287, this.out);
        }
    }

    public void sendPackeDualcalib_sendStartAutoConnectRobotsRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1288, this.out);
        }
    }

    public void sendPackeDualcalib_sendZeroHome() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1289, this.out);
        }
    }

    public void sendPackeDualcalib_sendSaveAndZeroParameterRequest(boolean zeroHomeRobot1, boolean saveCalibrationRobot1, boolean zeroHomeRobot2, boolean saveCalibrationRobot2) {
        int code = 0;
        code |= zeroHomeRobot1 ? 1 : 0;
        code |= saveCalibrationRobot1 ? 2 : 0;
        code |= zeroHomeRobot2 ? 4 : 0;
        code |= saveCalibrationRobot2 ? 8 : 0;
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1292, code, this.out);
        }
    }

    public void sendPackeDualcalib_sendStartAutoDisconnectRobotsRequest() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1290, this.out);
        }
    }

    public void sendPackeDualcalib_sendStartVerificationRequest(CalibrationVerificationType verificationType) {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1291, verificationType.getId(), this.out);
        }
    }

    public void sendPopupDialogResponse(int id, int response) {
        if (this.reconnect()) {
            CalibCommProtocol.sendPacketWithTwoInts(1299, id, response, this.out);
        }
    }

    public void sendPackeDualcalib_sendSaveCalibrationToFile() {
        if (this.reconnect()) {
            CalibCommProtocol.sendCommand(1294, this.out);
        }
    }
}

