/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.communication;

import com.ur.polyscope.calibration.communication.CalibrationResult;
import com.ur.polyscope.calibration.communication.ICalibDualRobotSocketReceiveActionList;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.util.logging.Log;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.SwingUtilities;

public class DualRobotCalibState
implements ICalibDualRobotSocketReceiveActionList {
    private static final double DIFF_CALIB_CONTROL_RESULT = 0.5;
    private static final double MAX_POSITION_MEAN_ERROR = 0.001;
    private static final double MAX_POSITION_STD_ERROR = 5.0E-4;
    private static final double MAX_ORIENTATION_MEAN_ERROR = 0.002;
    private static final double MAX_ORIENTATION_STD_ERROR = 0.001;
    private static CopyOnWriteArraySet<DualRobotCalibStateListener> stateListenerSet = new CopyOnWriteArraySet();
    private static DualRobotCalibState lastState = new DualRobotCalibState();
    private int robot1State = 0;
    private int robot2State = 0;
    private int mainState = 0;
    private int manualState = 0;
    private int calibrationState = 0;
    private int numberOfMeasurements = 0;
    private int numberOfExpectedMeasurements = 0;
    private boolean robot1Connected = false;
    private boolean robot1InNewHome = false;
    private boolean robot2Connected = false;
    private boolean robot2InNewHome = false;
    private boolean calibrationRunning = false;
    private boolean chainIsClosed = false;
    private int autoMoveStatus = 0;
    private int calibrationStatus = 0;
    private boolean calibrationEnoughMeasurements = false;
    private int robot1calibrationIsApplied = 0;
    private int robot2calibrationIsApplied = 0;
    private int robot1calibrationIsSaved = 0;
    private int robot2calibrationIsSaved = 0;
    private int robot1ZeroIsApplied = 0;
    private int robot2ZeroIsApplied = 0;
    private boolean verificationSucceed = false;
    private CalibrationResult calibratioResult = null;
    private CalibrationResult controlResult = null;

    public static DualRobotCalibState getLastState() {
        return lastState;
    }

    public static void subscribe(DualRobotCalibStateListener listener) {
        stateListenerSet.add(listener);
        if (stateListenerSet.size() > 10) {
            Log.error((String)("There are now " + stateListenerSet.size() + " dual robot calibration state subscribers!"));
        }
        listener.handleDualRobotCalibState(lastState);
    }

    public static boolean unsubscribe(DualRobotCalibStateListener listener) {
        return stateListenerSet.remove(listener);
    }

    private static void handleRobotMessagesSwingThreadSafe(DualRobotCalibState dualRobotCalibState) {
        for (DualRobotCalibStateListener listener : stateListenerSet) {
            listener.handleDualRobotCalibState(dualRobotCalibState);
        }
    }

    public static void notifyAllSubscribers() {
        DualRobotCalibState.notifyAllSubscribers(DualRobotCalibState.getLastState());
    }

    private static void notifyAllSubscribers(DualRobotCalibState dualRobotCalibState) {
        lastState = dualRobotCalibState;
        Runnable doWorkRunnable = () -> DualRobotCalibState.handleRobotMessagesSwingThreadSafe(dualRobotCalibState);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    @Override
    public void receiveMessageCode(int messageCode, String messageStr) {
        String robot1 = "Robot1";
        String robot2 = "Robot2";
        String main = "MainState";
        String numberOfMeasurementsStr = "NumberOfMeasurements";
        String numberOfExpectedMeasurementsStr = "NumberOfExpectedMeasurements";
        if (messageStr.equals(numberOfMeasurementsStr)) {
            this.numberOfMeasurements = messageCode;
        } else if (messageStr.equals(numberOfExpectedMeasurementsStr)) {
            this.numberOfExpectedMeasurements = messageCode;
        }
        this.handleMainMessage(messageCode, messageStr, main);
        this.handleRobot1Message(messageCode, messageStr, robot1);
        this.handleRobot2Message(messageCode, messageStr, robot2);
        Log.debug((String)("Dual calib packet from " + messageStr + ": 0x" + Integer.toHexString(messageCode)));
        DualRobotCalibState.notifyAllSubscribers(this);
    }

    private void handleRobot2Message(int messageCode, String messageStr, String robot2) {
        if (messageStr.equals(robot2)) {
            switch (messageCode) {
                case 1: {
                    this.robot2Connected = true;
                    break;
                }
                case 257: {
                    this.robot2Connected = false;
                    break;
                }
                case 2: {
                    this.robot2InNewHome = true;
                    break;
                }
                case 258: {
                    this.robot2InNewHome = false;
                    break;
                }
                case 4: {
                    this.robot2calibrationIsApplied = 1;
                    break;
                }
                case 260: {
                    this.robot2calibrationIsApplied = 0;
                    break;
                }
                case 5: {
                    this.robot2calibrationIsSaved = 1;
                    break;
                }
                case 261: {
                    this.robot2calibrationIsSaved = 0;
                    break;
                }
                case 517: {
                    this.robot2calibrationIsSaved = 2;
                    break;
                }
                case 262: {
                    this.robot2ZeroIsApplied = 0;
                    break;
                }
                case 6: {
                    this.robot2ZeroIsApplied = 1;
                    break;
                }
                case 518: {
                    this.robot2ZeroIsApplied = 2;
                    break;
                }
            }
            if ((messageCode & 0xFF00) == 32768) {
                this.robot2State = messageCode & 0xFF;
            }
        }
    }

    private void handleRobot1Message(int messageCode, String messageStr, String robot1) {
        if (messageStr.equals(robot1)) {
            switch (messageCode) {
                case 1: {
                    this.robot1Connected = true;
                    break;
                }
                case 257: {
                    this.robot1Connected = false;
                    break;
                }
                case 2: {
                    this.robot1InNewHome = true;
                    break;
                }
                case 258: {
                    this.robot1InNewHome = false;
                    break;
                }
                case 4: {
                    this.robot1calibrationIsApplied = 1;
                    break;
                }
                case 5: {
                    this.robot1calibrationIsSaved = 1;
                    break;
                }
                case 261: {
                    this.robot1calibrationIsSaved = 0;
                    break;
                }
                case 260: {
                    this.robot1calibrationIsApplied = 0;
                    break;
                }
                case 517: {
                    this.robot1calibrationIsSaved = 2;
                    break;
                }
                case 262: {
                    this.robot1ZeroIsApplied = 0;
                    break;
                }
                case 6: {
                    this.robot1ZeroIsApplied = 1;
                    break;
                }
                case 518: {
                    this.robot1ZeroIsApplied = 2;
                    break;
                }
            }
            if ((messageCode & 0xFF00) == 32768) {
                this.robot1State = messageCode & 0xFF;
            }
        }
    }

    private void handleMainMessage(int messageCode, String messageStr, String main) {
        if (messageStr.equals(main)) {
            switch (messageCode) {
                case 4353: {
                    this.calibratioResult = null;
                    this.controlResult = null;
                    this.calibrationRunning = true;
                    break;
                }
                case 2: {
                    this.chainIsClosed = true;
                    break;
                }
                case 258: {
                    this.chainIsClosed = false;
                    break;
                }
                case 3: {
                    this.calibrationEnoughMeasurements = true;
                    break;
                }
                case 259: {
                    this.calibrationEnoughMeasurements = false;
                    break;
                }
                case 7: {
                    this.verificationSucceed = true;
                    break;
                }
                case 263: {
                    this.verificationSucceed = false;
                    break;
                }
            }
            if ((messageCode & 0xFF00) == 32768) {
                this.mainState = messageCode & 0xFF;
            }
            if ((messageCode & 0xFF00) == 16384) {
                this.manualState = messageCode & 0xFF;
            }
            if ((messageCode & 0xFF00) == 4096) {
                this.calibrationState = messageCode & 0xFF;
            }
            if (messageCode == 4354 || messageCode == 4355) {
                this.calibrationRunning = false;
            }
            if ((messageCode & 0xFF00) == 4352) {
                this.calibrationStatus = messageCode & 0xFF;
            }
            if ((messageCode & 0xFF00) == 4608) {
                this.autoMoveStatus = messageCode & 0xFF;
            }
        }
    }

    @Override
    public void receiveResults(int resultCode, CalibrationResult result) {
        if (resultCode == 1) {
            this.calibratioResult = result;
        }
        if (resultCode == 2) {
            this.controlResult = result;
        }
        DualRobotCalibState.notifyAllSubscribers(this);
    }

    public int getNumberOfMeasurements() {
        return this.numberOfMeasurements;
    }

    public int getNumberOfExpectedMeasurements() {
        return this.numberOfExpectedMeasurements;
    }

    public int getMainState() {
        return this.mainState;
    }

    public boolean isMainStateInIdle() {
        return this.mainState == 1;
    }

    public int getManualState() {
        return this.manualState;
    }

    public boolean isRobot1Connected() {
        return this.robot1Connected;
    }

    public boolean isRobot1InNewHome() {
        return this.robot1InNewHome;
    }

    public int getRobot1State() {
        return this.robot1State;
    }

    public boolean isRobot2Connected() {
        return this.robot2Connected;
    }

    public boolean isRobot2InNewHome() {
        return this.robot2InNewHome;
    }

    public int getRobot2State() {
        return this.robot2State;
    }

    public boolean areBothRobotsConnected() {
        return this.isRobot1Connected() && this.isRobot2Connected();
    }

    private String getStateText(int state) {
        switch (state) {
            case 0: {
                return "No state";
            }
            case 1: {
                return "Idle";
            }
            case 2: {
                return "Starting";
            }
            case 3: {
                return "Executing";
            }
            case 4: {
                return "Completing";
            }
            case 5: {
                return "Complete";
            }
            case 6: {
                return "Resetting";
            }
            case 7: {
                return "Holding";
            }
            case 8: {
                return "Held";
            }
            case 9: {
                return "Unholding";
            }
            case 10: {
                return "Stopping";
            }
            case 11: {
                return "Stopped";
            }
            case 12: {
                return "Aborting";
            }
            case 13: {
                return "Aborted";
            }
            case 14: {
                return "Clearing";
            }
        }
        return "Unknown state";
    }

    private String getManualStateText(int state) {
        switch (state) {
            case 0: {
                return "No state";
            }
            case 1: {
                return "Start step";
            }
            case 2: {
                return "Sensor change";
            }
            case 3: {
                return "Enough data";
            }
            case 4: {
                return "Stop robots";
            }
            case 5: {
                return "Pause movement";
            }
            case 6: {
                return "Stopping movement";
            }
            case 7: {
                return "Save data";
            }
            case 8: {
                return "Start movement";
            }
            case 9: {
                return "Done";
            }
        }
        return "Unknown state";
    }

    public String getMainStateText() {
        return this.getStateText(this.mainState);
    }

    public String getStepStateText() {
        return this.getManualStateText(this.manualState);
    }

    public String getRobot1StateText() {
        return this.getStateText(this.robot1State);
    }

    public String getRobot2StateText() {
        return this.getStateText(this.robot2State);
    }

    public CalibrationResult getCalibratioResult() {
        return this.calibratioResult;
    }

    public CalibrationResult getControlResult() {
        return this.controlResult;
    }

    public int getCalibrationState() {
        return this.calibrationState;
    }

    public boolean isCalibrationRunning() {
        return this.calibrationRunning;
    }

    public boolean isChainClosed() {
        return this.chainIsClosed;
    }

    public int getCalibrationStatus() {
        return this.calibrationStatus;
    }

    public int getAutoMoveStatus() {
        return this.autoMoveStatus;
    }

    public boolean isCalibrationEnoughMeasurements() {
        return this.calibrationEnoughMeasurements;
    }

    public int isRobot1CalibrationIsApplied() {
        return this.robot1calibrationIsApplied;
    }

    public int isRobot1CalibrationIsSaved() {
        return this.robot1calibrationIsSaved;
    }

    public int isRobot2CalibrationIsApplied() {
        return this.robot2calibrationIsApplied;
    }

    public int isRobot2CalibrationIsSaved() {
        return this.robot2calibrationIsSaved;
    }

    public int isRobot1ZeroIsApplied() {
        return this.robot1ZeroIsApplied;
    }

    public int isRobot2ZeroIsApplied() {
        return this.robot2ZeroIsApplied;
    }

    public boolean isVerificationSucceed() {
        return this.verificationSucceed;
    }

    private double compareRatio(double a, double b) {
        double min = Math.min(a, b);
        double max = Math.max(a, b);
        if (max == 0.0) {
            return 1.0;
        }
        return min / max;
    }

    private boolean interRelation() {
        if (this.calibratioResult == null || this.controlResult == null) {
            return false;
        }
        return this.compareRatio(this.calibratioResult.getMeanPos(), this.controlResult.getMeanPos()) > 0.5 && this.compareRatio(this.calibratioResult.getMeanRot(), this.controlResult.getMeanRot()) > 0.5 && this.compareRatio(this.calibratioResult.getStdPos(), this.controlResult.getStdPos()) > 0.5 && this.compareRatio(this.calibratioResult.getStdRot(), this.controlResult.getStdRot()) > 0.5;
    }

    private boolean absoluteRange() {
        return this.calibratioResult.getMeanPos() < 0.001 && this.controlResult.getMeanPos() < 0.001 && this.calibratioResult.getStdPos() < 5.0E-4 && this.controlResult.getStdPos() < 5.0E-4 && this.calibratioResult.getMeanRot() < 0.002 && this.controlResult.getMeanRot() < 0.002 && this.calibratioResult.getStdRot() < 0.001 && this.controlResult.getStdRot() < 0.001;
    }

    public boolean isReferenceDistanceWithinToleranceRange() {
        if (this.controlResult == null) {
            return false;
        }
        return Math.abs(this.controlResult.getRefDist()) < this.controlResult.getRefTol();
    }

    public boolean doesCalibAndControlMatch() {
        if (this.calibratioResult == null || this.controlResult == null) {
            return false;
        }
        return this.absoluteRange() && this.interRelation();
    }

    public boolean areAllResultsOkToProceed() {
        return this.doesCalibAndControlMatch() && this.isReferenceDistanceWithinToleranceRange();
    }
}

