/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibMain;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.swing.CardPanel;
import com.ur.util.logging.Log;
import com.ur.util.swing.SecretSwipeCallback;
import com.ur.util.swing.SecretSwipeListener;
import com.ur.view.constants.comm.CalibrationVerificationType;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DualRobotAutoCard
extends CardPanel
implements DualRobotCalibStateListener,
SecretSwipeCallback<JButton> {
    private DualRobotCalibMain dualRobotCalibMain = null;
    private MainCalibration mainCalibWindow = null;
    private int lastAutoStep = 0;
    private boolean actionNeedToBeManuel = true;
    private boolean overwriteCheck = false;
    private JButton jButton;
    private JCheckBox jCheckBoxAuto;

    public DualRobotAutoCard(MainCalibration mainCalibWindow, DualRobotCalibMain dualRobotCalibMain) {
        this.initComponents();
        this.mainCalibWindow = mainCalibWindow;
        this.dualRobotCalibMain = dualRobotCalibMain;
        this.jButton.addMouseMotionListener((MouseMotionListener)new SecretSwipeListener((SecretSwipeCallback)this, (Object)this.jButton, 400));
        DualRobotCalibState.subscribe(this);
    }

    @Override
    public void handleDualRobotCalibState(DualRobotCalibState status) {
        if (status == null) {
            return;
        }
        this.updateText(status);
        this.autoStep(status);
    }

    private void updateText(DualRobotCalibState status) {
        int autoStepCount = this.dualRobotCalibMain.getAutoStepCount();
        this.jCheckBoxAuto.setVisible(true);
        boolean isManual = !this.jCheckBoxAuto.isSelected() && status.isMainStateInIdle();
        this.jButton.setEnabled(isManual);
        switch (autoStepCount) {
            case 0: {
                this.jButton.setText("nop");
                this.jButton.setEnabled(true);
                this.actionNeedToBeManuel = true;
                break;
            }
            case 1: {
                this.jButton.setText("Connect robots");
                this.jButton.setEnabled(true);
                this.actionNeedToBeManuel = true;
                break;
            }
            case 2: 
            case 4: {
                this.jButton.setText("Start motion");
                this.actionNeedToBeManuel = false;
                break;
            }
            case 3: 
            case 5: {
                this.jButton.setText("Calculate");
                this.actionNeedToBeManuel = false;
                break;
            }
            case 6: {
                this.jButton.setText("Apply calibration");
                this.jButton.setEnabled(this.dualRobotCalibMain.isResultPassed() && isManual);
                this.actionNeedToBeManuel = false;
                break;
            }
            case 7: {
                this.jButton.setText("Disconnect robots");
                this.actionNeedToBeManuel = false;
                break;
            }
            case 8: {
                this.jButton.setText("Correct home position");
                this.actionNeedToBeManuel = false;
                break;
            }
            case 9: {
                this.jButton.setText("Verify");
                this.actionNeedToBeManuel = false;
                break;
            }
            case 10: {
                this.jButton.setText("Save calibration");
                this.actionNeedToBeManuel = false;
                break;
            }
            case 11: {
                this.jButton.setText("Completed");
                this.jButton.setEnabled(false);
                this.jCheckBoxAuto.setVisible(false);
                if (status.getMainState() == 1) break;
                this.jButton.setEnabled(false);
                break;
            }
        }
    }

    private void nextAction() {
        switch (this.dualRobotCalibMain.getAutoStepCount()) {
            case 1: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartAutoConnectRobotsRequest();
                break;
            }
            case 2: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartAutoRequest(0);
                break;
            }
            case 3: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartCalibRequest(0);
                break;
            }
            case 4: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartAutoRequest(1);
                break;
            }
            case 5: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartCalibRequest(1);
                break;
            }
            case 6: {
                if (!this.dualRobotCalibMain.isResultPassed() && !this.overwriteCheck) break;
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendSaveCalibRequest();
                this.overwriteCheck = false;
                break;
            }
            case 7: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartAutoDisconnectRobotsRequest();
                break;
            }
            case 8: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendZeroHome();
                break;
            }
            case 9: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartVerificationRequest(CalibrationVerificationType.NORMAL);
                break;
            }
            case 10: {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendSaveCalibrationToFile();
                break;
            }
            case 11: {
                break;
            }
        }
    }

    private void autoStep(DualRobotCalibState status) {
        if (this.jCheckBoxAuto.isSelected() && this.lastAutoStep != this.dualRobotCalibMain.getAutoStepCount() && status.isMainStateInIdle() && !this.actionNeedToBeManuel) {
            this.nextAction();
            Log.debug((String)("Dual robot Auto step count = " + this.dualRobotCalibMain.getAutoStepCount()));
            this.lastAutoStep = this.dualRobotCalibMain.getAutoStepCount();
        }
    }

    public void handleSecretSwipe(JButton o) {
        if (this.dualRobotCalibMain.getAutoStepCount() == 6) {
            o.setEnabled(true);
            this.overwriteCheck = true;
        }
    }

    private void initComponents() {
        this.jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.jCheckBoxAuto = new JCheckBox();
        JPanel jPanel1 = new JPanel();
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 32828));
        this.setMinimumSize(new Dimension(110, 61));
        this.setPreferredSize(new Dimension(300, 95));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.jButton.setText("Start");
        this.jButton.setMaximumSize(new Dimension(1000, 41));
        this.jButton.setMinimumSize(new Dimension(110, 41));
        this.jButton.setPreferredSize(new Dimension(110, 41));
        this.jButton.addActionListener(evt -> this.nextAction());
        this.add(this.jButton);
        jPanel2.setMaximumSize(new Dimension(1000, 10));
        jPanel2.setMinimumSize(new Dimension(0, 10));
        jPanel2.setPreferredSize(new Dimension(500, 10));
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.add(jPanel2);
        this.jCheckBoxAuto.setSelected(true);
        this.jCheckBoxAuto.setText("Auto step");
        this.jCheckBoxAuto.addActionListener(evt -> {
            this.lastAutoStep = this.dualRobotCalibMain.getAutoStepCount();
            this.updateText(DualRobotCalibState.getLastState());
        });
        this.add(this.jCheckBoxAuto);
        jPanel1.setPreferredSize(new Dimension(271, 34));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 350, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.add(jPanel1);
    }
}

