/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.lang.Defense;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.automove.AutoMoveTab;
import com.ur.polyscope.calibration.AssignIP;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotAutoCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibrationCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibrationResultCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotConnectCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotConnectionStatusCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotManualCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotManualConfirmCloseChainCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotSelectConnectTypeCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotSelectRoutineCard;
import com.ur.polyscope.calibration.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import com.ur.view.Settings;
import com.ur.view.constants.comm.CalibrationVerificationType;
import gui.tools.DialogCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.swingx.JXTitledSeparator;

@Singleton
public class DualRobotCalibMain
extends CardPanel
implements DualRobotCalibStateListener,
DualRobotSelectConnectTypeCard.SetConnectionType {
    public static final int AT_BEGINNING_CONNECTED_NETWORK = 0;
    public static final int MOUNT_THE_ROBOTS = 1;
    public static final int COLLECT_INITIAL_MEASUREMENTS = 2;
    public static final int CALCULATE_INITIAL_CALIBRATION = 3;
    public static final int COLLECT_MAIN_MEASUREMENTS = 4;
    public static final int CALCULATE_FINAL_CALIBRATION = 5;
    public static final int STATISTICS_CALIBRATION = 6;
    public static final int APPLIED_CALIBRATION = 7;
    public static final int ROBOTS_ARE_DISCONNECTED = 8;
    public static final int VERIFICATION = 9;
    public static final int SAVING_CALIBRATION_TO_FILE = 10;
    public static final int COMPLETED = 11;
    private static final String SELECT_A_CONNECTION_TYPE_TEXT = "<html>Select a connection type:<ul><li>Choose one robot as Master and the other as Slave or</li><li>Select Manual and connect to another robot via an IP address</li></ul></html>";
    private static final String CONNECT_TO_ETHERNET_MASTER_TEXT = "<html><ol><li>Connect the two robots to a Ethernet network</li><p><li>Select the other robot as slave and press 'Connect'</li></ol></html>";
    private static final String CONNECT_TO_ETHERNET_TEXT_ENTER_IP = "<html><ol><li>Connect the two robots to a Ethernet network</li><p><li>Connect this robot with the other robot by entering the IP address and press 'Connect network'</li></ol></html>";
    private static final String MOUNT_THE_ROBOTS_TEXT = "<html>Connect robots<ol><li>Mount the robots tool flanges together.</li><p><li>Press \"Connect robots\" to connect the tools. <br><b>Caution: The Robots will begin to move</b>.</li><p></ol></html>";
    private static final String COLLECT_INITIAL_MEASUREMENTS_TEXT = "<html>Collect 'initial' measurements</html>";
    private static final String COLLECTING_INITIAL_MEASUREMENTS_TEXT = "<html>Collecting 'initial' measurements...</html>";
    private static final String COLLECT_MEASUREMENTS_ABORT_TEXT = "<html>Collect measurements - Aborted!<p> In wrong start position or could not find path file</html>";
    private static final String CALCULATE_INITIAL_CALIBRATION_TEXT = "<html>Calculate the 'initial' calibration</html>";
    private static final String CALCULATING_INITIAL_CALIBRATION_TEXT = "<html>Calculating the 'initial' calibration...</html>";
    private static final String COLLECT_MEASUREMENTS_TEXT = "<html>Collect measurements</html>";
    private static final String COLLECTING_MEASUREMENTS_TEXT = "<html>Collecting measurements...</html>";
    private static final String CALCULATE_CALIBRATION_TEXT = "<html>Calculate the calibration</html>";
    private static final String CALCULATING_CALIBRATION_TEXT = "<html>Calculating the calibration...</html>";
    private static final String CALIBRATION_ABORTED_TEXT = "<html>The calibration was aborted</html>";
    private static final String NOT_ENOUGH_MEASUREMENTS_TEXT = "<html>Not enough measurements collected to preform a calibration</html>";
    private static final String APPLY_THE_CALIBRATION_TEXT = "<html>Apply the calibration</html>";
    private static final String CALIBRATION_DID_NOT_SUCCEED_TEXT = "<html>The calibration did not succeed.<br>Please verify that the robots are properly assembled and connected, and try again<p>Press 'Exit' to try again</html>";
    private static final String CALIBRATION_APPLIED_TEXT = "<html>The calibration has been applied. It will be saved permanently after successful verification.<p>Press 'Disconnect Robots' to disconnecting the robots.</html>";
    private static final String ROBOT_HAVE_BEEN_DISCONNECTED_TEXT = "<html>The robot have been disconnected.<p>Press 'Exit' to finish or 'Correct Home Position' correct the home position.<p><p>It is not recommended and only optional to 'Correct joints zero angle' since this can introduces errors to existing programs if the robot was not calibrated in the first place.</html>";
    private static final String PRESS_VERIFIFY_TO_RUN_VERIFICATION_TEXT = "<html>The joints home position have been adjusted.<p>Press 'Verify' to run a verification routine</html>";
    private static final String PRESS_SAVE_TO_SAVE_CALIBRATION = "<html>Press 'Save calibration' to write calibration result to robot(s)</html>";
    private static final String MOUNT_TOOL_FLANGES_TEXT = "<html>Important<ol><li>Mount the tool flanges of the robots together.</li><p><li>Confirm that the robots tools is mounted together.</li></ol></html>";
    private static final String COLLECT_MEASUREMENT_DATA_TEXT = "<html>Collect measurement data<ol><li>Press 'Make them Moveable' to toggle the freedrive mode in both robots.</li><p><li>Move the chain in various positions as different as possible.</li></ol></html>";
    private static final String CALIBRATE_ROBOTS_INFO_TEXT = "<html>Calibrate robots<ol><li>Press 'Calibrate' to start the calibration process using the measurements collected.</li><p><li>Press 'Apply' to activate the new calibration to the robot controllers.</li><li>Press 'Save' to override the old default with the new calibration.</li></ol></html>";
    private static final String CONNECTION_TO_ROBOT_LOST = "<html>Connection between the robots is lost. <br>Fix the issue to resume the process or press Exit to abort.</html>";
    private static final int NOT_STARTED_NO_NETWORK = -1;
    private final FlippablePanel flStatusPanel = new FlippablePanel();
    private final FlippablePanel flStepPanel = new FlippablePanel();
    private final TextResource textResource;
    private final DialogCreator dialogCreator;
    private URFontFactory fontFactory;
    private MainCalibration mainCalibWindow = null;
    private DualRobotConnectionStatusCard connectionStatusCard = null;
    private DualRobotConnectCard connectionCard = null;
    private DualRobotSelectRoutineCard routineCard = null;
    private DualRobotCalibrationResultCard calibResultCard = null;
    private int manStepCount = -1;
    private int autoStepCount = -1;
    private ConnectionType connectionType = ConnectionType.UNSELECTED;
    private JCheckBox jCheckBoxRobot1CorrectHomePosition;
    private JCheckBox jCheckBoxRobot1SaveCalibration;
    private JCheckBox jCheckBoxRobot2CorrectHomePosition;
    private JCheckBox jCheckBoxRobot2SaveCalibration;
    private JLabel jLabelDescription;
    private JPanel jPanelSettings;
    private JPanel jPanelStatus;
    private JButton backButton;
    private JButton homeButton;

    @Inject
    public DualRobotCalibMain(ViewContext viewContext, DialogCreator dialogCreator) {
        this.fontFactory = viewContext.getFontFactory();
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.dialogCreator = dialogCreator;
    }

    public void setMainCalibration(MainCalibration mainCalibration) {
        this.mainCalibWindow = mainCalibration;
        this.initComponents();
        DualRobotCalibState.subscribe(this);
    }

    public void enter(Object o) {
        super.enter(o);
        this.flStepPanel.enterActiveChild(o);
        this.flStatusPanel.enterActiveChild(o);
        if (this.connectionType == ConnectionType.UNSELECTED) {
            this.jLabelDescription.setText(SELECT_A_CONNECTION_TYPE_TEXT);
        }
    }

    public Object exit() {
        this.flStepPanel.exitActiveChild();
        this.flStatusPanel.exitActiveChild();
        return super.exit();
    }

    public DualRobotSelectRoutineCard getRoutineCard() {
        return this.routineCard;
    }

    public void sendCommandAutoDisconnect() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartAutoDisconnectRobotsRequest();
    }

    public void sendCommandZero() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendZeroHome();
    }

    public void sendCommandVerification(CalibrationVerificationType verificationType) {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartVerificationRequest(verificationType);
    }

    public void sendCommandSaveCalibrationToFile() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendSaveCalibrationToFile();
    }

    private void autoNextStep(DualRobotCalibState status) {
        if (status.isMainStateInIdle() && this.autoStepCount < 11) {
            ++this.autoStepCount;
            DualRobotCalibState.notifyAllSubscribers();
        }
    }

    private void autoPrevStep() {
        switch (this.autoStepCount) {
            case -1: {
                this.jLabelDescription.setText(SELECT_A_CONNECTION_TYPE_TEXT);
                return;
            }
            case 0: {
                this.atBeginningConnectedNetwork();
                this.showConnectionCard();
                break;
            }
            case 1: {
                this.mountRobots();
                this.showConnectionCard();
                break;
            }
            case 2: {
                if (DualRobotCalibState.getLastState().getNumberOfMeasurements() != 0) break;
                this.autoStepCount = 1;
                this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartAutoConnectRobotsRequest();
                break;
            }
        }
        if (DualRobotCalibState.getLastState().getMainState() == 3) {
            this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStopRequest();
        }
        DualRobotCalibState.notifyAllSubscribers();
    }

    private void mountRobots() {
        this.autoStepCount = 0;
        this.mainCalibWindow.getSocket().sendPackeDualcalib_disconnectResetAndFlushRequest();
        Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.connectionCard.modeReconnect();
    }

    private void atBeginningConnectedNetwork() {
        this.autoStepCount = -1;
        this.connectionCard.modeReconnect();
        this.doMasterSlaveDisconnect();
        this.mainCalibWindow.getSocket().sendPackeDualcalib_disconnectResetAndFlushRequest();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Log.error((String)"Interrupted while waiting for socket", (Throwable)ex);
        }
        this.autoStepCount = -1;
        this.manStepCount = -1;
        this.connectionType = ConnectionType.UNSELECTED;
    }

    void manNextStep(DualRobotCalibState status) {
        if (status.isMainStateInIdle() && this.manStepCount < 10) {
            ++this.manStepCount;
            DualRobotCalibState.notifyAllSubscribers();
        }
    }

    private ConfirmationMessage confirmDisconnectAndFlushMeasurements() {
        return new ConfirmationMessage("Warning", "You are about to disconnect and flush measurements.Do you want to continue?", "Exit", this.textResource.cancel());
    }

    private void manPrevStep() {
        if (this.manStepCount == -1) {
            return;
        }
        --this.manStepCount;
        if (DualRobotCalibState.getLastState().getMainState() == 3) {
            this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStopRequest();
        }
        if (this.manStepCount == -1) {
            if (DualRobotCalibState.getLastState().isRobot2Connected() && DualRobotCalibState.getLastState().getNumberOfMeasurements() == 0) {
                this.mainCalibWindow.getSocket().sendPackeDualcalib_disconnectResetAndFlushRequest();
            } else {
                this.manPrevStepDialogHandler();
            }
        }
        DualRobotCalibState.notifyAllSubscribers();
    }

    private void manPrevStepDialogHandler() {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onClick(DialogReturnValue returnValue) {
                if (returnValue == DialogReturnValue.OK) {
                    DualRobotCalibMain.this.mainCalibWindow.getSocket().sendPackeDualcalib_disconnectResetAndFlushRequest();
                } else {
                    DualRobotCalibMain.this.manStepCount = 0;
                }
            }
        };
        ConfirmationMessage m = this.confirmDisconnectAndFlushMeasurements();
        this.dialogCreator.showConfirmationDialog(m, listener);
    }

    private boolean isBackButtonEnabledInCurrentState() {
        boolean autoBackButton = this.flStepPanel.getCurrentCard() instanceof DualRobotConnectCard || this.autoStepCount == 0 || this.autoStepCount == 1 || this.autoStepCount == 2 && DualRobotCalibState.getLastState().isChainClosed() && DualRobotCalibState.getLastState().getNumberOfMeasurements() == 0;
        boolean notInConnectTypeCard = !(this.flStepPanel.getCurrentCard() instanceof DualRobotSelectConnectTypeCard);
        return notInConnectTypeCard && autoBackButton;
    }

    private void updateBackButton() {
        this.backButton.setEnabled(this.isBackButtonEnabledInCurrentState());
    }

    private void updateHomeButton() {
        this.homeButton.setEnabled(this.homeButtonBeEnabled());
    }

    private boolean homeButtonBeEnabled() {
        return !(this.autoStepCount >= 2 && this.autoStepCount < 8 || this.manStepCount >= 2 && this.manStepCount < 8);
    }

    @Override
    public void handleDualRobotCalibState(DualRobotCalibState status) {
        this.jCheckBoxRobot1SaveCalibration.setEnabled(status.isRobot1CalibrationIsSaved() == 0);
        this.jCheckBoxRobot2SaveCalibration.setEnabled(status.isRobot2CalibrationIsSaved() == 0);
        this.jCheckBoxRobot1CorrectHomePosition.setEnabled(status.isRobot1ZeroIsApplied() == 0);
        this.jCheckBoxRobot2CorrectHomePosition.setEnabled(status.isRobot2ZeroIsApplied() == 0);
        this.updateBackButton();
        this.routineCard.updateCard(status);
        this.updateHomeButton();
        Log.debug((String)("manStepCount:\t" + this.manStepCount + "\nautoStepCount:\t" + this.autoStepCount + "\nautoMoveState:\t" + status.getAutoMoveStatus()));
        if (status.isRobot2Connected()) {
            if (this.isAutoManualStepsAtConnectedState()) {
                this.connectionCard.setConnectStatusMessage(true);
            }
        } else if (this.isAutoManualStepsBetweenConnectedAndCompleteState()) {
            Log.debug((String)"Network Disconnect detected");
            this.jLabelDescription.setText(CONNECTION_TO_ROBOT_LOST);
            this.connectionStatusCard.handleDualRobotCalibState(status);
            return;
        }
        if (this.routineCard.isRoutineSelectionEnabled() && status.areBothRobotsConnected()) {
            if (this.routineCard.isManualRoutineSelected()) {
                this.updateManState(status);
            } else if (this.routineCard.isAutoRoutineSelected()) {
                this.updateAutoState(status);
            } else {
                this.flStepPanel.switchTo(DualRobotSelectRoutineCard.class);
            }
        } else {
            this.updateAutoState(status);
        }
    }

    private boolean isAutoManualStepsBetweenConnectedAndCompleteState() {
        return this.manStepCount >= 0 && this.manStepCount < 11 || this.autoStepCount >= 0 && this.autoStepCount < 11;
    }

    private boolean isAutoManualStepsAtConnectedState() {
        return this.manStepCount == 0 && this.autoStepCount == 0;
    }

    private void updateAutoState(DualRobotCalibState status) {
        switch (this.autoStepCount) {
            case -1: {
                this.notStartedNoNetwork(status);
                break;
            }
            case 0: {
                this.nextStepIfCondition(status, status.areBothRobotsConnected());
                break;
            }
            case 1: {
                this.connectionStatusCard.showStateStepStatus(false);
                this.flStatusPanel.switchTo(DualRobotConnectionStatusCard.class);
                this.flStepPanel.switchTo(DualRobotAutoCard.class);
                this.jLabelDescription.setText(MOUNT_THE_ROBOTS_TEXT);
                this.nextStepIfCondition(status, status.isChainClosed());
                break;
            }
            case 2: {
                this.calibrationMessage(COLLECT_INITIAL_MEASUREMENTS_TEXT, COLLECTING_INITIAL_MEASUREMENTS_TEXT, status.isMainStateInIdle());
                this.collectMainMeasurements(status, 2);
                break;
            }
            case 3: {
                this.flStatusPanel.switchTo(DualRobotConnectionStatusCard.class);
                this.calibrationMessage(CALCULATE_INITIAL_CALIBRATION_TEXT, CALCULATING_INITIAL_CALIBRATION_TEXT, status.isMainStateInIdle());
                this.calculateCalibration(status, 2, 13);
                break;
            }
            case 4: {
                this.calibrationMessage(COLLECT_MEASUREMENTS_TEXT, COLLECTING_MEASUREMENTS_TEXT, status.isMainStateInIdle());
                this.collectMainMeasurements(status, 3);
                break;
            }
            case 5: {
                this.calibrationMessage(CALCULATE_CALIBRATION_TEXT, CALCULATING_CALIBRATION_TEXT, status.isMainStateInIdle());
                this.calculateCalibration(status, 4, 3);
                break;
            }
            case 6: {
                this.flStatusPanel.switchTo(DualRobotCalibrationResultCard.class);
                this.calibrationMessage(APPLY_THE_CALIBRATION_TEXT, CALIBRATION_DID_NOT_SUCCEED_TEXT, this.calibResultCard.isResultPassed());
                if (status.isRobot1CalibrationIsApplied() <= 0 || status.isRobot2CalibrationIsApplied() <= 0) break;
                this.routineCard.autoRoutineDone();
                this.autoNextStep(status);
                break;
            }
            case 7: {
                this.flStatusPanel.switchTo(DualRobotCalibrationResultCard.class);
                this.jLabelDescription.setText(CALIBRATION_APPLIED_TEXT);
                this.nextStepIfCondition(status, status.isRobot1InNewHome() && status.isRobot2InNewHome());
                break;
            }
            case 8: {
                this.flStatusPanel.switchTo(DualRobotCalibrationResultCard.class);
                this.jLabelDescription.setText(ROBOT_HAVE_BEEN_DISCONNECTED_TEXT);
                if (status.isRobot1ZeroIsApplied() <= 0 || status.isRobot2ZeroIsApplied() <= 0) break;
                this.autoNextStep(status);
                break;
            }
            case 9: {
                this.flStatusPanel.switchTo(DualRobotCalibrationResultCard.class);
                this.jLabelDescription.setText(PRESS_VERIFIFY_TO_RUN_VERIFICATION_TEXT);
                this.nextStepIfCondition(status, status.isVerificationSucceed());
                break;
            }
            case 10: {
                this.flStatusPanel.switchTo(DualRobotCalibrationResultCard.class);
                this.jLabelDescription.setText(PRESS_SAVE_TO_SAVE_CALIBRATION);
                if (status.isRobot1CalibrationIsSaved() <= 0 || status.isRobot2CalibrationIsSaved() <= 0) break;
                this.autoNextStep(status);
                break;
            }
            case 11: {
                this.jPanelStatus.setVisible(true);
                this.jPanelSettings.setVisible(false);
                String SUCCESSFULLY_COMPLETED_TEXT = "<html>The calibration was completed successfully<br>Press Exit to leave the screen</html>";
                this.jLabelDescription.setText(SUCCESSFULLY_COMPLETED_TEXT);
                break;
            }
        }
    }

    private void collectMainMeasurements(DualRobotCalibState status, int i) {
        if (status.getAutoMoveStatus() == i) {
            this.autoNextStep(status);
        } else if (status.getAutoMoveStatus() == 1) {
            this.jLabelDescription.setText(COLLECT_MEASUREMENTS_ABORT_TEXT);
        }
    }

    private void calculateCalibration(DualRobotCalibState status, int starting, int aborting) {
        if (status.getCalibrationStatus() == starting) {
            this.autoNextStep(status);
        } else if (status.getCalibrationStatus() == aborting) {
            this.jLabelDescription.setText(CALIBRATION_ABORTED_TEXT);
        } else if (!status.isCalibrationEnoughMeasurements()) {
            this.jLabelDescription.setText(NOT_ENOUGH_MEASUREMENTS_TEXT);
        }
    }

    private void calibrationMessage(String mainStateInIdleMessage, String otherwiseMessage, boolean mainStateInIdle) {
        if (mainStateInIdle) {
            this.jLabelDescription.setText(mainStateInIdleMessage);
        } else {
            this.jLabelDescription.setText(otherwiseMessage);
        }
    }

    private void nextStepIfCondition(DualRobotCalibState status, boolean isCondition) {
        if (isCondition) {
            this.autoNextStep(status);
        }
    }

    private void notStartedNoNetwork(DualRobotCalibState status) {
        if (status.areBothRobotsConnected()) {
            this.autoNextStep(status);
        } else {
            this.connectionCard.modeReconnect();
            this.showConnectionCard();
        }
    }

    public boolean isResultPassed() {
        return this.calibResultCard.isResultPassed();
    }

    private void updateManState(DualRobotCalibState status) {
        if (!(this.flStepPanel.getCurrentCard() instanceof DualRobotManualCard)) {
            this.flStepPanel.switchTo(DualRobotManualCard.class);
        }
        switch (this.manStepCount) {
            case -1: {
                if (status.areBothRobotsConnected()) {
                    this.manNextStep(status);
                    break;
                }
                this.connectionCard.modeReconnect();
                this.showConnectionCard();
                break;
            }
            case 0: {
                if (!status.areBothRobotsConnected()) break;
                this.manNextStep(status);
                break;
            }
            case 1: {
                this.connectionStatusCard.showStateStepStatus(true);
                this.flStatusPanel.switchTo(DualRobotConnectionStatusCard.class);
                this.flStepPanel.switchTo(DualRobotManualConfirmCloseChainCard.class);
                this.jLabelDescription.setText(MOUNT_TOOL_FLANGES_TEXT);
                break;
            }
            case 2: {
                this.flStatusPanel.switchTo(DualRobotConnectionStatusCard.class);
                this.flStepPanel.switchTo(DualRobotManualCard.class);
                this.jLabelDescription.setText(COLLECT_MEASUREMENT_DATA_TEXT);
                break;
            }
            case 3: {
                this.flStatusPanel.switchTo(DualRobotCalibrationResultCard.class);
                this.flStepPanel.switchTo(DualRobotCalibrationCard.class);
                this.calibrationMessage(CALIBRATE_ROBOTS_INFO_TEXT, NOT_ENOUGH_MEASUREMENTS_TEXT, status.isCalibrationEnoughMeasurements());
                break;
            }
        }
    }

    public int getAutoStepCount() {
        return this.autoStepCount;
    }

    private void setAutoStepCount(int count) {
        this.autoStepCount = count;
        DualRobotCalibState.notifyAllSubscribers();
    }

    @Override
    public void set(ConnectionType ct) {
        this.connectionType = ct;
        switch (ct) {
            case MANUAL_IP: {
                this.connectionCard.reset();
                break;
            }
            case MASTER: {
                ct.setUp();
                this.connectionCard.setAsMaster(ConnectionType.SLAVE.ip);
                break;
            }
            case SLAVE: {
                ct.setUp();
                this.mainCalibWindow.enterSlaveCalib();
            }
        }
        this.showConnectionCard();
        this.sendHomeAndSaveChoice();
        this.updateBackButton();
    }

    private void sendHomeAndSaveChoice() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendSaveAndZeroParameterRequest(this.jCheckBoxRobot1CorrectHomePosition.isSelected(), this.jCheckBoxRobot1SaveCalibration.isSelected(), this.jCheckBoxRobot2CorrectHomePosition.isSelected(), this.jCheckBoxRobot2SaveCalibration.isSelected());
    }

    private void showConnectionCard() {
        switch (this.connectionType) {
            case UNSELECTED: {
                this.flStepPanel.switchTo(DualRobotSelectConnectTypeCard.class);
                this.jLabelDescription.setText(SELECT_A_CONNECTION_TYPE_TEXT);
                break;
            }
            case MANUAL_IP: {
                this.flStepPanel.switchTo(DualRobotConnectCard.class);
                this.jLabelDescription.setText(CONNECT_TO_ETHERNET_TEXT_ENTER_IP);
                break;
            }
            case MASTER: {
                this.flStepPanel.switchTo(DualRobotConnectCard.class);
                this.jLabelDescription.setText(CONNECT_TO_ETHERNET_MASTER_TEXT);
                break;
            }
        }
    }

    private void doMasterSlaveDisconnect() {
        switch (this.connectionType) {
            case MASTER: 
            case SLAVE: {
                this.connectionType.tearDown();
                break;
            }
        }
    }

    private void resetAutoAndManualStepCount() {
        this.autoStepCount = -1;
        this.manStepCount = -1;
    }

    public void performExit() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_disconnectResetAndFlushRequest();
        this.doMasterSlaveDisconnect();
        this.mainCalibWindow.exitDualCalib();
        this.resetAutoAndManualStepCount();
        this.connectionType = ConnectionType.UNSELECTED;
    }

    public void exitAndResetCalibrationProcess() {
        Log.debug((String)"Exit and Reset Calibration Process");
        this.performExit();
        if (this.routineCard.isRoutineSelectionEnabled()) {
            Log.debug((String)"Disabling Routine Selection Card");
            this.routineCard.setRoutineSelectionEnabled(false);
            this.routineCard.manualRoutineDone();
            this.routineCard.autoRoutineDone();
        }
        this.connectionCard.reset();
        this.connectionType = ConnectionType.UNSELECTED;
        this.connectionCard.modeReconnect();
        this.jPanelStatus.setVisible(true);
        this.jPanelSettings.setVisible(true);
        this.flStatusPanel.switchTo(DualRobotConnectionStatusCard.class);
        this.flStepPanel.switchTo(DualRobotSelectConnectTypeCard.class);
        this.jLabelDescription.setText(SELECT_A_CONNECTION_TYPE_TEXT);
    }

    private void initComponents() {
        JPanel jPanelLeft = new JPanel();
        JPanel jPanelCalib = new JPanel();
        this.jPanelSettings = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.jCheckBoxRobot1SaveCalibration = new JCheckBox();
        this.jCheckBoxRobot1CorrectHomePosition = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        this.jCheckBoxRobot2SaveCalibration = new JCheckBox();
        this.jCheckBoxRobot2CorrectHomePosition = new JCheckBox();
        this.jPanelStatus = new JPanel();
        JPanel jPanelRight = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton exitButton = new JButton();
        this.backButton = new JButton();
        this.jLabelDescription = new JLabel();
        jPanelCalib.setMinimumSize(new Dimension(350, 150));
        jPanelCalib.setPreferredSize(new Dimension(350, 150));
        jPanelCalib.setLayout(new BorderLayout());
        jPanel1.setLayout(new BorderLayout());
        jPanel1.add((Component)new JXTitledSeparator("Master"), "North");
        this.jCheckBoxRobot1SaveCalibration.setSelected(true);
        this.jCheckBoxRobot1SaveCalibration.setText("Save calibration");
        this.jCheckBoxRobot1SaveCalibration.addActionListener(evt -> {
            this.sendHomeAndSaveChoice();
            this.jCheckBoxRobot1CorrectHomePosition.setSelected(this.jCheckBoxRobot1SaveCalibration.isSelected());
        });
        jPanel1.add((Component)this.jCheckBoxRobot1SaveCalibration, "Center");
        this.jCheckBoxRobot1CorrectHomePosition.setSelected(true);
        this.jCheckBoxRobot1CorrectHomePosition.setText("Correct home position");
        this.jCheckBoxRobot1CorrectHomePosition.addActionListener(evt -> this.sendHomeAndSaveChoice());
        jPanel1.add((Component)this.jCheckBoxRobot1CorrectHomePosition, "Last");
        jPanel1.getAccessibleContext().setAccessibleName("Master");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JXTitledSeparator("Slave"), "North");
        this.jCheckBoxRobot2SaveCalibration.setSelected(true);
        this.jCheckBoxRobot2SaveCalibration.setText("Save calibration");
        this.jCheckBoxRobot2SaveCalibration.addActionListener(evt -> {
            this.sendHomeAndSaveChoice();
            this.jCheckBoxRobot2CorrectHomePosition.setSelected(this.jCheckBoxRobot2SaveCalibration.isSelected());
        });
        jPanel2.add((Component)this.jCheckBoxRobot2SaveCalibration, "Center");
        this.jCheckBoxRobot2CorrectHomePosition.setSelected(true);
        this.jCheckBoxRobot2CorrectHomePosition.setText("Correct home position");
        this.jCheckBoxRobot2CorrectHomePosition.addActionListener(evt -> this.sendHomeAndSaveChoice());
        jPanel2.add((Component)this.jCheckBoxRobot2CorrectHomePosition, "Last");
        jPanel2.getAccessibleContext().setAccessibleName("Slave");
        this.jPanelSettings.setMaximumSize(new Dimension(500, 65));
        this.jPanelSettings.setMinimumSize(new Dimension(350, 65));
        this.jPanelSettings.setPreferredSize(new Dimension(350, 65));
        this.jPanelSettings.setLayout(new GridLayout(1, 2, 5, 5));
        this.jPanelSettings.add(jPanel1);
        this.jPanelSettings.add(jPanel2);
        this.jPanelStatus.setMinimumSize(new Dimension(430, 0));
        this.jPanelStatus.setPreferredSize(new Dimension(430, 0));
        this.jPanelStatus.setLayout(new BorderLayout());
        GroupLayout jPanelLeftLayout = new GroupLayout(jPanelLeft);
        jPanelLeft.setLayout(jPanelLeftLayout);
        jPanelLeftLayout.setHorizontalGroup(jPanelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLeftLayout.createSequentialGroup().addGroup(jPanelLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jPanelCalib, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelSettings, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelStatus, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        jPanelLeftLayout.setVerticalGroup(jPanelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLeftLayout.createSequentialGroup().addComponent(jPanelCalib, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelStatus, -1, -1, Short.MAX_VALUE)));
        exitButton.setText("Exit");
        exitButton.setPreferredSize(new Dimension(120, -1));
        exitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DualRobotCalibMain.this.exitButtonMouseReleased(evt);
            }
        });
        exitButton.addActionListener(evt -> this.exitButtonActionPerformed());
        this.backButton.setText("Back");
        this.backButton.setEnabled(false);
        this.backButton.setPreferredSize(new Dimension(120, 38));
        this.backButton.addActionListener(evt -> this.backButtonActionPerformed());
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.backButton);
        jPanel4.add(Box.createHorizontalStrut(5));
        this.homeButton = new JButton("Home");
        this.homeButton.addActionListener(e -> {
            JointPositionVector jpv = new JointPositionVector(0.0, -1.5707963267948966, 0.0, -1.5707963267948966, 0.0, 0.0);
            this.stackCurrentCardAndSwitchTo(AutoMoveTab.class, jpv);
        });
        jPanel4.add(this.homeButton);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(exitButton);
        this.jLabelDescription.setText("...status...");
        this.jLabelDescription.setVerticalAlignment(1);
        GroupLayout jPanelRightLayout = new GroupLayout(jPanelRight);
        jPanelRight.setLayout(jPanelRightLayout);
        jPanelRightLayout.setHorizontalGroup(jPanelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDescription, -2, 0, Short.MAX_VALUE).addComponent(jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanelRightLayout.setVerticalGroup(jPanelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRightLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDescription, -2, 228, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 137, Short.MAX_VALUE).addComponent(jPanel4, -2, -1, -2)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanelLeft, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanelRight, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanelLeft, -1, -1, Short.MAX_VALUE).addComponent(jPanelRight, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        DualRobotSelectConnectTypeCard selectConnectTypeCard = new DualRobotSelectConnectTypeCard(this);
        this.connectionStatusCard = new DualRobotConnectionStatusCard();
        this.calibResultCard = new DualRobotCalibrationResultCard(this.fontFactory);
        this.flStatusPanel.addCardPanel((CardPanel)this.connectionStatusCard);
        this.flStatusPanel.addCardPanel((CardPanel)this.calibResultCard);
        this.jPanelStatus.add((Component)this.flStatusPanel);
        this.jPanelStatus.validate();
        this.connectionCard = new DualRobotConnectCard(this.mainCalibWindow);
        this.routineCard = new DualRobotSelectRoutineCard(this, this.textResource, this.dialogCreator);
        DualRobotManualConfirmCloseChainCard manualConfirmCloseChainCard = new DualRobotManualConfirmCloseChainCard(this.mainCalibWindow, this);
        DualRobotManualCard manualCard = new DualRobotManualCard(this.mainCalibWindow, this);
        DualRobotAutoCard autoCard = new DualRobotAutoCard(this.mainCalibWindow, this);
        DualRobotCalibrationCard calibrationCard = new DualRobotCalibrationCard(this.mainCalibWindow);
        this.flStepPanel.addCardPanel((CardPanel)selectConnectTypeCard);
        this.flStepPanel.addCardPanel((CardPanel)this.connectionCard);
        this.flStepPanel.addCardPanel((CardPanel)this.routineCard);
        this.flStepPanel.addCardPanel((CardPanel)manualConfirmCloseChainCard);
        this.flStepPanel.addCardPanel((CardPanel)manualCard);
        this.flStepPanel.addCardPanel((CardPanel)autoCard);
        this.flStepPanel.addCardPanel((CardPanel)calibrationCard);
        jPanelCalib.add((Component)this.flStepPanel);
        jPanelCalib.validate();
    }

    private void exitButtonActionPerformed() {
        if (DualRobotCalibState.getLastState().getNumberOfMeasurements() == 0 || this.autoStepCount >= 10) {
            this.exitAndResetCalibrationProcess();
            return;
        }
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                DualRobotCalibMain.this.exitAndResetCalibrationProcess();
            }
        };
        this.dialogCreator.showConfirmationDialog(this.confirmDisconnectAndFlushMeasurements(), listener);
    }

    private void backButtonActionPerformed() {
        if (this.flStepPanel.getCurrentCard() instanceof DualRobotConnectCard) {
            this.autoStepCount = -1;
            this.manStepCount = -1;
            this.flStepPanel.switchTo(DualRobotSelectConnectTypeCard.class);
            this.jLabelDescription.setText(SELECT_A_CONNECTION_TYPE_TEXT);
            this.doMasterSlaveDisconnect();
        } else if (this.autoStepCount >= 0) {
            this.autoPrevStep();
        } else if (this.manStepCount >= 0) {
            this.manPrevStep();
        }
        this.updateBackButton();
    }

    private void exitButtonMouseReleased(MouseEvent evt) {
        if (evt.getX() < -290) {
            this.routineCard.setRoutineSelectionEnabled(!this.routineCard.isRoutineSelectionEnabled());
            Log.debug((String)("Manual routine selection: " + this.routineCard.isRoutineSelectionEnabled()));
            if (!this.routineCard.isRoutineSelectionEnabled()) {
                this.setAutoStepCount(1);
            }
        }
    }

    static enum ConnectionType {
        UNSELECTED(""),
        MASTER("10.17.17.18"),
        SLAVE("10.17.17.19"),
        MANUAL_IP("");

        private final String ip;

        private ConnectionType(String ip) {
            this.ip = ip;
        }

        private void setUp() {
            Defense.notNullOrEmpty((String)this.ip);
            String networkInterface = Settings.getNetworkInterface();
            AssignIP.runShellCommand("ifconfig %s up && ifconfig %s:0 %s netmask 255.255.255.0 up", networkInterface, networkInterface, this.ip);
        }

        public void tearDown() {
            String networkInterface = Settings.getNetworkInterface();
            AssignIP.runShellCommand("ifconfig %s:0 down", networkInterface);
        }

        public String getIP() {
            return this.ip;
        }
    }
}

