/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.swing.CardPanel;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class DualRobotCalibrationCard
extends CardPanel
implements DualRobotCalibStateListener {
    private MainCalibration mainCalibWindow = null;
    private int lastReceivedStatus = 0;
    private JButton jButtonApply;
    private JButton jButtonCalibrate;
    private JButton jButtonSave;

    public DualRobotCalibrationCard(MainCalibration mainCalibWindow) {
        this.initComponents();
        this.mainCalibWindow = mainCalibWindow;
    }

    public void enter(Object o) {
        DualRobotCalibState.subscribe(this);
        super.enter(o);
    }

    public Object exit() {
        DualRobotCalibState.unsubscribe(this);
        return super.exit();
    }

    @Override
    public void handleDualRobotCalibState(DualRobotCalibState status) {
        this.lastReceivedStatus = status.getMainState();
        if (this.lastReceivedStatus == 1) {
            this.jButtonCalibrate.setEnabled(true);
            this.jButtonCalibrate.setText("Calculate");
            this.jButtonCalibrate.setEnabled(true);
        } else if (this.lastReceivedStatus == 3) {
            this.jButtonCalibrate.setEnabled(true);
            this.jButtonCalibrate.setText("Stop");
        } else {
            this.jButtonCalibrate.setEnabled(false);
            this.jButtonCalibrate.setEnabled(false);
        }
        if (status.getCalibratioResult() == null) {
            this.jButtonApply.setEnabled(false);
            this.jButtonSave.setEnabled(false);
        } else {
            this.jButtonApply.setEnabled(true);
            this.jButtonSave.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jButtonCalibrate = new JButton();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.jButtonApply = new JButton();
        this.jButtonSave = new JButton();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.jButtonCalibrate.setText("Calibrate");
        this.jButtonCalibrate.setMaximumSize(new Dimension(1000, 29));
        this.jButtonCalibrate.setMinimumSize(new Dimension(110, 29));
        this.jButtonCalibrate.setPreferredSize(new Dimension(110, 41));
        this.jButtonCalibrate.addActionListener(evt -> this.jButtonCalibrateActionPerformed());
        this.add(this.jButtonCalibrate);
        jPanel3.setMaximumSize(new Dimension(1000, 10));
        jPanel3.setMinimumSize(new Dimension(0, 10));
        jPanel3.setPreferredSize(new Dimension(500, 10));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 311, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.add(jPanel3);
        jPanel4.setMaximumSize(new Dimension(1000, 32));
        jPanel4.setMinimumSize(new Dimension(0, 32));
        jPanel4.setPreferredSize(new Dimension(500, 32));
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(evt -> this.jButtonApplyActionPerformed());
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(evt -> this.jButtonSaveActionPerformed());
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonApply, -1, 154, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave, -1, 151, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonSave)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(jPanel4);
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 311, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 35, Short.MAX_VALUE));
        this.add(jPanel1);
        jPanel2.setMaximumSize(new Dimension(1000, 29));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.add(jPanel2);
    }

    private void jButtonCalibrateActionPerformed() {
        if (this.lastReceivedStatus == 1) {
            this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartCalibRequest(0);
        } else if (this.lastReceivedStatus == 3) {
            this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStopRequest();
        }
    }

    private void jButtonApplyActionPerformed() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendApplyCalibRequest();
    }

    private void jButtonSaveActionPerformed() {
        this.mainCalibWindow.getSocket().sendPackeDualcalib_sendSaveCalibRequest();
    }
}

