/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.polyscope.calibration.dualrobot.DualRobotResultCard;
import com.ur.polyscope.calibration.dualrobot.DualRobotResultScaleCard;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.flippable.FlippablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class DualRobotCalibrationResultCard
extends CardPanel
implements DualRobotCalibStateListener {
    private DualRobotResultCard calibResult = null;
    private DualRobotResultCard controlResult = null;
    private DualRobotResultScaleCard scaleResult = null;
    private JPanel jPanelCalib;
    private JPanel jPanelControl;
    private JPanel jPanelScale;

    public DualRobotCalibrationResultCard(URFontFactory fontFactory) {
        this.initComponents();
        this.calibResult = new DualRobotResultCard("Calibration Results", fontFactory);
        this.controlResult = new DualRobotResultCard("Control Results", fontFactory);
        this.scaleResult = new DualRobotResultScaleCard("Scale Result", fontFactory);
        FlippablePanel flCalibResult = new FlippablePanel();
        flCalibResult.addCardPanel((CardPanel)this.calibResult);
        FlippablePanel flControlResult = new FlippablePanel();
        flControlResult.addCardPanel((CardPanel)this.controlResult);
        FlippablePanel flScaleResult = new FlippablePanel();
        flScaleResult.addCardPanel((CardPanel)this.scaleResult);
        this.jPanelCalib.add((Component)flCalibResult);
        this.jPanelCalib.validate();
        this.jPanelControl.add((Component)flControlResult);
        this.jPanelControl.validate();
        this.jPanelScale.add((Component)flScaleResult);
        this.jPanelScale.validate();
    }

    public void enter(Object o) {
        DualRobotCalibState.subscribe(this);
        super.enter(o);
    }

    public Object exit() {
        DualRobotCalibState.unsubscribe(this);
        return super.exit();
    }

    @Override
    public void handleDualRobotCalibState(DualRobotCalibState status) {
        if (status == null) {
            return;
        }
        boolean calibResultPassed = status.doesCalibAndControlMatch();
        boolean controlResultPassed = status.doesCalibAndControlMatch();
        boolean scaleResultPassed = status.isReferenceDistanceWithinToleranceRange();
        this.calibResult.setResult(calibResultPassed);
        this.controlResult.setResult(controlResultPassed);
        this.scaleResult.setResult(scaleResultPassed);
        this.calibResult.update(status.getCalibratioResult());
        this.controlResult.update(status.getControlResult());
        this.scaleResult.update(status.getControlResult());
    }

    public boolean isResultPassed() {
        return DualRobotCalibState.getLastState().areAllResultsOkToProceed();
    }

    private void initComponents() {
        this.jPanelCalib = new JPanel();
        this.jPanelControl = new JPanel();
        this.jPanelScale = new JPanel();
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.jPanelCalib.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanelCalib.setLayout(new BorderLayout());
        this.add(this.jPanelCalib);
        this.jPanelControl.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanelControl.setLayout(new BorderLayout());
        this.add(this.jPanelControl);
        this.jPanelScale.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanelScale.setLayout(new BorderLayout());
        this.add(this.jPanelScale);
    }
}

