/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibMain;
import com.ur.swing.CardPanel;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

class DualRobotConnectCard
extends CardPanel {
    private static final String DEFAULT_IP_TEXT = "IP address or host name";
    private MainCalibration mainCalibWindow = null;
    private Timer timer = null;
    private boolean isMaster = false;
    private JButton jButtonConnect;
    private JLabel jLabelConnectingStatus;
    private JTextField jTextHost;

    public DualRobotConnectCard(MainCalibration mainCalibWindow) {
        this.initComponents();
        this.mainCalibWindow = mainCalibWindow;
        this.reset();
        TextFieldUtils.bindGhostText((JTextField)this.jTextHost, (String)DEFAULT_IP_TEXT);
        TextFieldUtils.bindTextPicker((JComponent)this.jTextHost, (TextHolder)new TextHolder(){

            public String getText() {
                if (DualRobotConnectCard.this.jTextHost.getText() != null && DualRobotConnectCard.this.jTextHost.getText().matches(DualRobotConnectCard.DEFAULT_IP_TEXT)) {
                    DualRobotConnectCard.this.jTextHost.setText("");
                }
                return DualRobotConnectCard.this.jTextHost.getText();
            }

            public void setText(String text) {
                DualRobotConnectCard.this.jTextHost.setText(text);
            }
        });
    }

    public void modeReconnect() {
        this.jButtonConnect.setText("Connect network");
        this.jButtonConnect.setEnabled(true);
        this.jTextHost.setEditable(!this.isMaster);
        this.jTextHost.setEnabled(!this.isMaster);
    }

    public void setAsMaster(String ip) {
        this.reset();
        this.isMaster = true;
        this.jTextHost.setText(ip);
        this.jTextHost.setEditable(false);
        this.jTextHost.setEnabled(false);
    }

    public void reset() {
        this.jLabelConnectingStatus.setForeground(Color.BLACK);
        this.jLabelConnectingStatus.setText(" ");
        this.jTextHost.setEditable(true);
        this.jTextHost.setEnabled(true);
        this.isMaster = false;
    }

    public synchronized void setConnectStatusMessage(boolean isConnected) {
        if (isConnected) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.jLabelConnectingStatus.setForeground(Color.BLACK);
            this.jLabelConnectingStatus.setText("Network Connected");
        } else {
            this.jLabelConnectingStatus.setForeground(Color.RED);
            this.jLabelConnectingStatus.setText("<html>Couldn't connect.<br>Verify IP address and network connectivity</html>");
            this.jButtonConnect.setEnabled(true);
        }
        this.jTextHost.setEnabled(!this.isMaster);
    }

    private void startConnectionTimer() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    DualRobotConnectCard.this.setConnectStatusMessage(false);
                }
                catch (Exception e) {
                    Log.error((String)"failed", (Throwable)e);
                }
            }
        };
        try {
            this.timer = new Timer();
            this.timer.schedule(timerTask, 3000L);
        }
        catch (Exception e) {
            Log.error((String)"timer scheduling failed", (Throwable)e);
        }
    }

    private boolean isSameAddresAsLocalHost(String otherRobotIPAddress) {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface localNetworkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> LocalAddressList = localNetworkInterface.getInetAddresses();
                while (LocalAddressList.hasMoreElements()) {
                    InetAddress localIPAddress = LocalAddressList.nextElement();
                    if (!otherRobotIPAddress.equals(localIPAddress.getHostAddress())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getHostIPAddress() {
        if (this.isMaster) {
            return DualRobotCalibMain.ConnectionType.MASTER.getIP();
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface localNetworkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> LocalAddressList = localNetworkInterface.getInetAddresses();
                while (LocalAddressList.hasMoreElements()) {
                    InetAddress localIPAddress = LocalAddressList.nextElement();
                    if (!localIPAddress.isSiteLocalAddress()) continue;
                    return localIPAddress.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"Unable to get the host IP Address, returning localhost");
        }
        return "127.0.0.1";
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jTextHost = new JTextField();
        this.jButtonConnect = new JButton();
        this.jLabelConnectingStatus = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jLabel1.setText("Enter the other robot's IP address");
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.addActionListener(evt -> this.jButtonConnectActionPerformed());
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(jLabel1).addContainerGap(88, Short.MAX_VALUE)).addComponent(this.jTextHost, -1, 303, Short.MAX_VALUE).addComponent(this.jButtonConnect, -1, 303, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextHost, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonConnect, -1, 41, Short.MAX_VALUE)));
        this.jLabelConnectingStatus.setText("Connecting...");
        this.jLabelConnectingStatus.setVerticalAlignment(1);
        this.jLabelConnectingStatus.setMaximumSize(new Dimension(84, 50));
        this.jLabelConnectingStatus.setMinimumSize(new Dimension(84, 50));
        this.jLabelConnectingStatus.setPreferredSize(new Dimension(340, 50));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelConnectingStatus, -2, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelConnectingStatus, -1, 75, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButtonConnectActionPerformed() {
        if (this.isSameAddresAsLocalHost(this.jTextHost.getText())) {
            this.jLabelConnectingStatus.setForeground(Color.RED);
            this.jLabelConnectingStatus.setText("The IP address entered is used by this robot");
            return;
        }
        String masterIp = this.getHostIPAddress();
        Log.debug((String)("Master ip is " + masterIp));
        Log.debug((String)("Slave address  " + this.jTextHost.getText()));
        this.mainCalibWindow.getSocket().sendPackeDualcalib_setHostNameRequest(masterIp, this.jTextHost.getText());
        this.jLabelConnectingStatus.setForeground(Color.BLACK);
        this.jLabelConnectingStatus.setText("Connecting...");
        this.startConnectionTimer();
        this.jButtonConnect.setEnabled(false);
        this.jTextHost.setEnabled(false);
    }
}

