/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.swing.CardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class DualRobotConnectionStatusCard
extends CardPanel
implements DualRobotCalibStateListener {
    private boolean showStateStepStatus = false;
    private JLabel jLabelNumberOfMeasurments;
    private JLabel jLabelRobot1;
    private JLabel jLabelRobot2;
    private JLabel jLabelStateMain;
    private JLabel jLabelStateRobot1;
    private JLabel jLabelStateRobot2;
    private JLabel jLabelStateStep;
    private JPanel jPanelConnection;

    public DualRobotConnectionStatusCard() {
        this.initComponents();
        this.jPanelConnection.setVisible(false);
        this.showStateStepStatus(false);
    }

    public final void showStateStepStatus(boolean show) {
        this.showStateStepStatus = show;
        if (!show) {
            this.jLabelStateStep.setText(" ");
        } else {
            this.jLabelStateStep.setText(DualRobotCalibState.getLastState().getStepStateText());
        }
    }

    public void enter(Object o) {
        super.enter(o);
        DualRobotCalibState.subscribe(this);
    }

    public Object exit() {
        DualRobotCalibState.unsubscribe(this);
        return super.exit();
    }

    @Override
    public void handleDualRobotCalibState(DualRobotCalibState status) {
        if (status == null) {
            return;
        }
        this.jLabelNumberOfMeasurments.setText(String.format("%d of %d", status.getNumberOfMeasurements(), status.getNumberOfExpectedMeasurements()));
        this.jLabelStateMain.setText(status.getMainStateText());
        if (this.showStateStepStatus) {
            this.jLabelStateStep.setText(status.getStepStateText());
        }
        this.jLabelStateRobot1.setText(status.getRobot1StateText());
        if (status.isRobot1Connected()) {
            this.jLabelRobot1.setText("This robot is connected");
        } else {
            this.jLabelRobot1.setText("This robot not connected");
        }
        this.jLabelStateRobot2.setText(status.getRobot2StateText());
        if (status.isRobot2Connected()) {
            this.jLabelRobot2.setText("Second robot is connected");
        } else {
            this.jLabelRobot2.setText("Second robot not connected");
        }
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JPanel jPanelMeasurements = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jLabelNumberOfMeasurments = new JLabel();
        this.jPanelConnection = new JPanel();
        this.jLabelRobot1 = new JLabel();
        this.jLabelRobot2 = new JLabel();
        JPanel jPanelStateStatus = new JPanel();
        JPanel jPanelRobotStateStatus = new JPanel();
        JLabel jLabelRobot4 = new JLabel();
        JLabel jLabelRobot5 = new JLabel();
        this.jLabelStateRobot2 = new JLabel();
        this.jLabelStateRobot1 = new JLabel();
        JPanel jPanelMainStateStatus = new JPanel();
        JLabel jLabelRobot3 = new JLabel();
        this.jLabelStateMain = new JLabel();
        this.jLabelStateStep = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(32779, 200));
        this.setMinimumSize(new Dimension(12, 200));
        this.setPreferredSize(new Dimension(423, 200));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        jPanel1.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        jPanel1.setPreferredSize(new Dimension(376, 25));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 386, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        this.add(jPanel1);
        jPanelMeasurements.setBorder(BorderFactory.createTitledBorder("Measurement status"));
        jPanelMeasurements.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        jPanelMeasurements.setPreferredSize(new Dimension(392, 50));
        jLabel1.setText("Number saved");
        this.jLabelNumberOfMeasurments.setHorizontalAlignment(4);
        this.jLabelNumberOfMeasurments.setText("0");
        GroupLayout jPanelMeasurementsLayout = new GroupLayout(jPanelMeasurements);
        jPanelMeasurements.setLayout(jPanelMeasurementsLayout);
        jPanelMeasurementsLayout.setHorizontalGroup(jPanelMeasurementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMeasurementsLayout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNumberOfMeasurments, -1, 244, Short.MAX_VALUE).addContainerGap()));
        jPanelMeasurementsLayout.setVerticalGroup(jPanelMeasurementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMeasurementsLayout.createSequentialGroup().addGroup(jPanelMeasurementsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jLabelNumberOfMeasurments)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(jPanelMeasurements);
        this.jPanelConnection.setBorder(BorderFactory.createTitledBorder("Connection status"));
        this.jPanelConnection.setMaximumSize(new Dimension(Short.MAX_VALUE, 75));
        this.jPanelConnection.setPreferredSize(new Dimension(392, 75));
        this.jLabelRobot1.setText("Waiting for connection to this robot");
        this.jLabelRobot2.setText("Waiting for connection to the second robot");
        GroupLayout jPanelConnectionLayout = new GroupLayout(this.jPanelConnection);
        this.jPanelConnection.setLayout(jPanelConnectionLayout);
        jPanelConnectionLayout.setHorizontalGroup(jPanelConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelConnectionLayout.createSequentialGroup().addContainerGap().addGroup(jPanelConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelRobot1, -1, 362, Short.MAX_VALUE).addGroup(jPanelConnectionLayout.createSequentialGroup().addComponent(this.jLabelRobot2, -1, 350, Short.MAX_VALUE).addContainerGap()))));
        jPanelConnectionLayout.setVerticalGroup(jPanelConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelConnectionLayout.createSequentialGroup().addComponent(this.jLabelRobot1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelRobot2).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(this.jPanelConnection);
        jPanelStateStatus.setBorder(BorderFactory.createTitledBorder("State status"));
        jPanelStateStatus.setMaximumSize(new Dimension(Short.MAX_VALUE, 115));
        jPanelStateStatus.setMinimumSize(new Dimension(0, 0));
        jPanelStateStatus.setPreferredSize(new Dimension(392, 115));
        jPanelStateStatus.setLayout(new BorderLayout());
        jPanelRobotStateStatus.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jPanelRobotStateStatus.setMaximumSize(new Dimension(Short.MAX_VALUE, 115));
        jLabelRobot4.setText("This Robot");
        jLabelRobot5.setText("Second Robot");
        this.jLabelStateRobot2.setHorizontalAlignment(4);
        this.jLabelStateRobot2.setText("Not connected");
        this.jLabelStateRobot1.setHorizontalAlignment(4);
        this.jLabelStateRobot1.setText("Not connected");
        GroupLayout jPanelRobotStateStatusLayout = new GroupLayout(jPanelRobotStateStatus);
        jPanelRobotStateStatus.setLayout(jPanelRobotStateStatusLayout);
        jPanelRobotStateStatusLayout.setHorizontalGroup(jPanelRobotStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRobotStateStatusLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRobotStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRobotStateStatusLayout.createSequentialGroup().addComponent(jLabelRobot5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStateRobot2, -1, 246, Short.MAX_VALUE)).addGroup(jPanelRobotStateStatusLayout.createSequentialGroup().addComponent(jLabelRobot4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStateRobot1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelRobotStateStatusLayout.setVerticalGroup(jPanelRobotStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRobotStateStatusLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanelRobotStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStateRobot1).addComponent(jLabelRobot4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRobotStateStatusLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelRobot5).addComponent(this.jLabelStateRobot2))));
        jPanelStateStatus.add((Component)jPanelRobotStateStatus, "Center");
        jPanelMainStateStatus.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jPanelMainStateStatus.setMaximumSize(new Dimension(Short.MAX_VALUE, 115));
        jLabelRobot3.setText("Main state");
        this.jLabelStateMain.setHorizontalAlignment(4);
        this.jLabelStateMain.setText("Not connected");
        this.jLabelStateStep.setHorizontalAlignment(4);
        this.jLabelStateStep.setText("step text");
        GroupLayout jPanelMainStateStatusLayout = new GroupLayout(jPanelMainStateStatus);
        jPanelMainStateStatus.setLayout(jPanelMainStateStatusLayout);
        jPanelMainStateStatusLayout.setHorizontalGroup(jPanelMainStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainStateStatusLayout.createSequentialGroup().addGroup(jPanelMainStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainStateStatusLayout.createSequentialGroup().addContainerGap().addComponent(jLabelRobot3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStateMain, -1, 270, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainStateStatusLayout.createSequentialGroup().addGap(85, 85, 85).addComponent(this.jLabelStateStep, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelMainStateStatusLayout.setVerticalGroup(jPanelMainStateStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainStateStatusLayout.createSequentialGroup().addGroup(jPanelMainStateStatusLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelRobot3).addComponent(this.jLabelStateMain)).addGap(3, 3, 3).addComponent(this.jLabelStateStep)));
        jPanelStateStatus.add((Component)jPanelMainStateStatus, "North");
        this.add(jPanelStateStatus);
        jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        jPanel3.setMinimumSize(new Dimension(0, 2));
        jPanel3.setPreferredSize(new Dimension(435, 2));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 386, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 2, Short.MAX_VALUE));
        this.add(jPanel3);
    }
}

