/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibMain;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibStateListener;
import com.ur.swing.CardPanel;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JButton;

public class DualRobotManualCard
extends CardPanel
implements DualRobotCalibStateListener {
    private DualRobotCalibMain dualRobotCalibMain = null;
    private MainCalibration mainCalibWindow = null;
    private int lastReceivedStatus = 0;
    private JButton jButtonCalibrate;
    private JButton jButtonConfirm;
    private JButton jButtonDone;

    public DualRobotManualCard(MainCalibration mainCalibWindow, DualRobotCalibMain dualRobotCalibMain) {
        this.initComponents();
        this.mainCalibWindow = mainCalibWindow;
        this.dualRobotCalibMain = dualRobotCalibMain;
    }

    public void enter(Object o) {
        DualRobotCalibState.subscribe(this);
        super.enter(o);
    }

    public Object exit() {
        DualRobotCalibState.unsubscribe(this);
        return super.exit();
    }

    @Override
    public void handleDualRobotCalibState(DualRobotCalibState status) {
        this.lastReceivedStatus = status.getMainState();
        if (this.lastReceivedStatus == 1) {
            this.jButtonConfirm.setEnabled(true);
            this.jButtonConfirm.setText("Make them moveable");
            this.jButtonCalibrate.setEnabled(true);
        } else if (this.lastReceivedStatus == 3) {
            this.jButtonConfirm.setEnabled(true);
            this.jButtonConfirm.setText("Stop");
        } else {
            this.jButtonConfirm.setEnabled(false);
            this.jButtonCalibrate.setEnabled(false);
        }
        this.jButtonDone.setEnabled(this.lastReceivedStatus == 1);
    }

    private void initComponents() {
        this.jButtonConfirm = new JButton();
        this.jButtonCalibrate = new JButton();
        this.jButtonDone = new JButton();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.jButtonConfirm.setText("Make them moveable");
        this.jButtonConfirm.setMaximumSize(new Dimension(1000, 29));
        this.jButtonConfirm.setMinimumSize(new Dimension(110, 29));
        this.jButtonConfirm.setPreferredSize(new Dimension(110, 41));
        this.jButtonConfirm.addActionListener(evt -> this.jButtonConfirmActionPerformed());
        this.add(this.jButtonConfirm);
        this.jButtonCalibrate.setText("Calibrate");
        this.jButtonCalibrate.setMaximumSize(new Dimension(1000, 29));
        this.jButtonCalibrate.setMinimumSize(new Dimension(110, 29));
        this.jButtonCalibrate.setPreferredSize(new Dimension(110, 41));
        this.jButtonCalibrate.addActionListener(evt -> this.jButtonCalibrateActionPerformed());
        this.add(this.jButtonCalibrate);
        this.jButtonDone.setText("Done");
        this.jButtonDone.setMaximumSize(new Dimension(1000, 29));
        this.jButtonDone.setMinimumSize(new Dimension(110, 29));
        this.jButtonDone.setPreferredSize(new Dimension(110, 41));
        this.jButtonDone.addActionListener(evt -> this.jButtonDoneActionPerformed());
        this.add(this.jButtonDone);
    }

    private void jButtonConfirmActionPerformed() {
        if (this.lastReceivedStatus == 1) {
            this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStartManualRequest();
        } else if (this.lastReceivedStatus == 3) {
            this.mainCalibWindow.getSocket().sendPackeDualcalib_sendStopRequest();
        }
    }

    private void jButtonCalibrateActionPerformed() {
        this.dualRobotCalibMain.manNextStep(DualRobotCalibState.getLastState());
    }

    private void jButtonDoneActionPerformed() {
        this.dualRobotCalibMain.getRoutineCard().manualRoutineDone();
        this.dualRobotCalibMain.handleDualRobotCalibState(DualRobotCalibState.getLastState());
    }
}

