/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.calibration.communication.CalibrationResult;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXTitledSeparator;

class DualRobotResultCard
extends CardPanel {
    static final DecimalFormat decimalformat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"####0.000");
    static final int NUMBER_UNIT_SPACE = 5;
    static final int VALUE_SPACE = 75;
    static final int UNIT_SPACE = 35;
    static final int TITLE_SPACE = 160;
    private String title = "";
    private final URFontFactory fontFactory;
    private JLabel jLabelMaxPos;
    private JLabel jLabelMaxRot;
    private JLabel jLabelMeanPos;
    private JLabel jLabelMeanRot;
    private JLabel jLabelStdPos;
    private JLabel jLabelStdRot;
    private JPanel jTitlePanel;

    public DualRobotResultCard(String title, URFontFactory fontFactory) {
        this.fontFactory = fontFactory;
        this.title = title;
        this.initComponents();
    }

    public void update(CalibrationResult result) {
        if (result == null) {
            String noResult = "-";
            this.jLabelMeanPos.setText(noResult);
            this.jLabelMeanRot.setText(noResult);
            this.jLabelStdPos.setText(noResult);
            this.jLabelStdRot.setText(noResult);
            this.jLabelMaxPos.setText(noResult);
            this.jLabelMaxRot.setText(noResult);
        } else {
            this.jLabelMeanPos.setText(decimalformat.format(result.getMeanPos() * 1000.0));
            this.jLabelMeanRot.setText(decimalformat.format(result.getMeanRot() * 1000.0));
            this.jLabelStdPos.setText(decimalformat.format(result.getStdPos() * 1000.0));
            this.jLabelStdRot.setText(decimalformat.format(result.getStdRot() * 1000.0));
            this.jLabelMaxPos.setText(decimalformat.format(result.getMaxPos() * 1000.0));
            this.jLabelMaxRot.setText(decimalformat.format(result.getMaxRot() * 1000.0));
        }
    }

    static void setBorderTitleAndColor(JPanel panel, Boolean result) {
        Color c = Color.BLACK;
        EmptyBorder margin = new EmptyBorder(2, 2, 2, 4);
        if (result == null) {
            panel.setBorder(BorderFactory.createTitledBorder(panel.getName()));
        } else {
            c = result != false ? Color.GREEN.darker().darker() : Color.RED.darker().darker();
            panel.setBorder(BorderFactory.createTitledBorder(new CompoundBorder(BorderFactory.createLineBorder(c), margin), panel.getName()));
            TitledBorder tmp = (TitledBorder)panel.getBorder();
            tmp.setTitleColor(c);
        }
        for (Component jc : panel.getComponents()) {
            if (!(jc instanceof JLabel)) continue;
            JLabel label = (JLabel)jc;
            label.setForeground(c);
        }
    }

    public void setResult(Boolean result) {
        DualRobotResultCard.setBorderTitleAndColor(this.jTitlePanel, result);
    }

    static JLabel makeSmallLabel(String str, URFontFactory fontFactory, int alignment) {
        JLabel label = new JLabel();
        label.setFont(fontFactory.getRelativeFont(URFontFactory.Size.SMALL));
        label.setHorizontalAlignment(alignment);
        label.setText(str);
        return label;
    }

    private void initComponents() {
        JLabel jLabelMeanDeviation = DualRobotResultCard.makeSmallLabel("Mean deviation", this.fontFactory, 2);
        JLabel jLabel3mm = DualRobotResultCard.makeSmallLabel("mm", this.fontFactory, 2);
        JLabel jLabel4mrad = DualRobotResultCard.makeSmallLabel("mrad", this.fontFactory, 2);
        JLabel jLabelStandardDeviation = DualRobotResultCard.makeSmallLabel("Standard deviation", this.fontFactory, 2);
        JLabel jLabel5mm = DualRobotResultCard.makeSmallLabel("mm", this.fontFactory, 2);
        JLabel jLabel6mrad = DualRobotResultCard.makeSmallLabel("mrad", this.fontFactory, 2);
        JLabel jLabelMaxDeviation = DualRobotResultCard.makeSmallLabel("Max deviation", this.fontFactory, 2);
        JLabel jLabel8mm = DualRobotResultCard.makeSmallLabel("mm", this.fontFactory, 2);
        JLabel jLabel9mrad = DualRobotResultCard.makeSmallLabel("mrad", this.fontFactory, 2);
        this.jTitlePanel = new JPanel();
        this.jTitlePanel.setName(this.title);
        this.jTitlePanel.add((Component)new JXTitledSeparator(this.title));
        this.jTitlePanel.setMaximumSize(new Dimension(1000, 100));
        this.jTitlePanel.setMinimumSize(new Dimension(0, 60));
        this.jTitlePanel.setPreferredSize(new Dimension(500, 80));
        this.jLabelMeanPos = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.jLabelMeanRot = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.jLabelStdPos = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.jLabelStdRot = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.jLabelMaxPos = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.jLabelMaxRot = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        GroupLayout jTitlePanelLayout = new GroupLayout(this.jTitlePanel);
        this.jTitlePanel.setLayout(jTitlePanelLayout);
        jTitlePanelLayout.setHorizontalGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(jTitlePanelLayout.createSequentialGroup().addContainerGap().addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabelMeanDeviation, 160, 160, 160).addComponent(jLabelStandardDeviation, 160, 160, 160).addComponent(jLabelMaxDeviation, 160, 160, 160)).addGap(0, 5, 200).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelMeanRot, 75, 75, 75).addComponent(this.jLabelStdRot, 75, 75, 75).addComponent(this.jLabelMaxRot, 75, 75, 75)).addGap(5, 5, 5).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel4mrad, 35, 35, 35).addComponent(jLabel6mrad, 35, 35, 35).addComponent(jLabel9mrad, 35, 35, 35)).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelMeanPos, 75, 75, 75).addComponent(this.jLabelStdPos, 75, 75, 75).addComponent(this.jLabelMaxPos, 75, 75, 75)).addGap(5, 5, 5).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel3mm, 35, 35, 35).addComponent(jLabel5mm, 35, 35, 35).addComponent(jLabel8mm, 35, 35, 35))));
        jTitlePanelLayout.setVerticalGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(jTitlePanelLayout.createSequentialGroup().addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabelMeanDeviation).addComponent(this.jLabelMeanRot).addComponent(jLabel4mrad).addComponent(this.jLabelMeanPos).addComponent(jLabel3mm)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabelStandardDeviation).addComponent(this.jLabelStdRot).addComponent(jLabel6mrad).addComponent(this.jLabelStdPos).addComponent(jLabel5mm)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabelMaxDeviation).addComponent(this.jLabelMaxRot).addComponent(jLabel9mrad).addComponent(this.jLabelMaxPos).addComponent(jLabel8mm))));
        this.add(this.jTitlePanel);
    }
}

