/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.communication.CalibrationResult;
import com.ur.polyscope.calibration.dualrobot.DualRobotResultCard;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.swingx.JXTitledSeparator;

class DualRobotResultScaleCard
extends CardPanel {
    private String title = "";
    private final URFontFactory fontFactory;
    private JLabel jLabelScaleTolerance;
    private JLabel jLabelScaleError;
    private JPanel jTitlePanel;

    public DualRobotResultScaleCard(String title, URFontFactory fontFactory) {
        this.fontFactory = fontFactory;
        this.title = title;
        this.initComponents();
    }

    public void update(CalibrationResult result) {
        if (result == null) {
            String noResult = "-";
            this.jLabelScaleError.setText(noResult);
            this.jLabelScaleTolerance.setText(noResult);
        } else {
            this.jLabelScaleError.setText(DualRobotResultCard.decimalformat.format(result.getRefDist() * 1000.0));
            this.jLabelScaleTolerance.setText(DualRobotResultCard.decimalformat.format(result.getRefTol() * 1000.0));
        }
    }

    public void setResult(Boolean result) {
        DualRobotResultCard.setBorderTitleAndColor(this.jTitlePanel, result);
    }

    private void initComponents() {
        JLabel jLabelScale = DualRobotResultCard.makeSmallLabel("Error", this.fontFactory, 2);
        JLabel jLabel3mm = DualRobotResultCard.makeSmallLabel("mm", this.fontFactory, 2);
        JLabel jLabelLimit = DualRobotResultCard.makeSmallLabel("Limit", this.fontFactory, 2);
        JLabel jLabel5mm = DualRobotResultCard.makeSmallLabel("mm", this.fontFactory, 2);
        this.jTitlePanel = new JPanel();
        this.jTitlePanel.setName(this.title);
        this.jLabelScaleTolerance = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.jLabelScaleError = DualRobotResultCard.makeSmallLabel("0", this.fontFactory, 4);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.jTitlePanel.add((Component)new JXTitledSeparator(this.title));
        this.jTitlePanel.setMaximumSize(new Dimension(1000, 100));
        this.jTitlePanel.setMinimumSize(new Dimension(0, 50));
        this.jTitlePanel.setPreferredSize(new Dimension(500, 60));
        GroupLayout jTitlePanelLayout = new GroupLayout(this.jTitlePanel);
        this.jTitlePanel.setLayout(jTitlePanelLayout);
        jTitlePanelLayout.setHorizontalGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(jTitlePanelLayout.createSequentialGroup().addContainerGap().addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabelScale, 160, 160, 160).addComponent(jLabelLimit, 160, 160, 160)).addGap(0, 5, 200).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelScaleError, 75, 75, 75).addComponent(this.jLabelScaleTolerance, 75, 75, 75)).addGap(5, 5, 5).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel3mm, 35, 35, 35).addComponent(jLabel5mm, 35, 35, 35))));
        jTitlePanelLayout.setVerticalGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(jTitlePanelLayout.createSequentialGroup().addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabelScale).addComponent(this.jLabelScaleError).addComponent(jLabel3mm)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jTitlePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelScaleTolerance).addComponent(jLabelLimit).addComponent(jLabel5mm))));
        this.add(this.jTitlePanel);
    }
}

