/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.dualrobot;

import com.ur.polyscope.calibration.communication.DualRobotCalibState;
import com.ur.polyscope.calibration.dualrobot.DualRobotCalibMain;
import com.ur.polyscope.calibration.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.view.constants.comm.CalibrationVerificationType;
import gui.tools.DialogCreator;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;

public class DualRobotSelectRoutineCard
extends CardPanel {
    private final TextResource textResource;
    private final DialogCreator dialogCreator;
    private DualRobotCalibMain dualRobotCalibMain = null;
    private boolean enableRoutineSelection = false;
    private boolean autoRoutineSelected = false;
    private boolean manualRoutineSelected = false;
    private JButton jButtonAuto;
    private JButton jButtonDisconnect;
    private JButton jButtonMan;
    private JButton jButtonVerificationNormal;
    private JButton jButtonVerification3Point;
    private JButton jButtonZero;
    private JButton jButtonSaveCalibToFile;

    public DualRobotSelectRoutineCard(DualRobotCalibMain dualRobotCalibMain, TextResource textResource, DialogCreator dialogCreator) {
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
        this.initComponents();
        this.dualRobotCalibMain = dualRobotCalibMain;
    }

    public void updateCard(DualRobotCalibState state) {
        boolean enableAllButtons = state.isMainStateInIdle();
        this.jButtonAuto.setEnabled(enableAllButtons);
        this.jButtonDisconnect.setEnabled(enableAllButtons);
        this.jButtonMan.setEnabled(enableAllButtons);
        this.jButtonVerificationNormal.setEnabled(enableAllButtons);
        this.jButtonVerification3Point.setEnabled(enableAllButtons);
        this.jButtonZero.setEnabled(enableAllButtons);
        this.jButtonSaveCalibToFile.setEnabled(enableAllButtons);
    }

    public boolean isRoutineSelectionEnabled() {
        return this.enableRoutineSelection;
    }

    public void setRoutineSelectionEnabled(boolean enabled) {
        this.enableRoutineSelection = enabled;
    }

    public boolean isAutoRoutineSelected() {
        return this.autoRoutineSelected;
    }

    public boolean isManualRoutineSelected() {
        return this.manualRoutineSelected;
    }

    public void manualRoutineDone() {
        this.manualRoutineSelected = false;
    }

    public void autoRoutineDone() {
        this.autoRoutineSelected = false;
    }

    private void jButtonVerificationActionPerformed(CalibrationVerificationType verificationType) {
        this.dualRobotCalibMain.sendCommandVerification(verificationType);
    }

    private void jButtonSaveCalibrationToFile() {
        this.dualRobotCalibMain.sendCommandSaveCalibrationToFile();
    }

    private void initComponents() {
        this.jButtonAuto = new JButton();
        this.jButtonMan = new JButton();
        this.jButtonDisconnect = new JButton();
        this.jButtonZero = new JButton();
        this.jButtonVerificationNormal = new JButton();
        this.jButtonVerification3Point = new JButton();
        this.jButtonSaveCalibToFile = new JButton();
        this.setLayout(new GridLayout(4, 2));
        this.jButtonAuto.setText("Automatic");
        this.jButtonAuto.setMaximumSize(new Dimension(1000, 29));
        this.jButtonAuto.setMinimumSize(new Dimension(110, 29));
        this.jButtonAuto.setPreferredSize(new Dimension(110, 41));
        this.jButtonAuto.addActionListener(evt -> this.jButtonAutoActionPerformed());
        this.add(this.jButtonAuto);
        this.jButtonMan.setText("Manual");
        this.jButtonMan.setMaximumSize(new Dimension(1000, 20));
        this.jButtonMan.setMinimumSize(new Dimension(119, 20));
        this.jButtonMan.setPreferredSize(new Dimension(110, 41));
        this.jButtonMan.addActionListener(evt -> this.jButtonManActionPerformed());
        this.add(this.jButtonMan);
        this.jButtonDisconnect.setText("Disconnect");
        this.jButtonDisconnect.setMaximumSize(new Dimension(1000, 20));
        this.jButtonDisconnect.setMinimumSize(new Dimension(147, 20));
        this.jButtonDisconnect.setPreferredSize(new Dimension(110, 41));
        this.jButtonDisconnect.addActionListener(evt -> this.jButtonDisconnectActionPerformed());
        this.add(this.jButtonDisconnect);
        this.jButtonZero.setText("Zero");
        this.jButtonZero.setMaximumSize(new Dimension(1000, 20));
        this.jButtonZero.setMinimumSize(new Dimension(112, 20));
        this.jButtonZero.setPreferredSize(new Dimension(110, 41));
        this.jButtonZero.addActionListener(evt -> this.jButtonZeroActionPerformed());
        this.add(this.jButtonZero);
        this.jButtonVerificationNormal.setText("Verification");
        this.jButtonVerificationNormal.setMaximumSize(new Dimension(1000, 20));
        this.jButtonVerificationNormal.setMinimumSize(new Dimension(147, 20));
        this.jButtonVerificationNormal.setPreferredSize(new Dimension(110, 41));
        this.jButtonVerificationNormal.addActionListener(evt -> this.jButtonVerificationActionPerformed(CalibrationVerificationType.NORMAL));
        this.add(this.jButtonVerificationNormal);
        this.jButtonVerification3Point.setText("3 point verification");
        this.jButtonVerification3Point.setMaximumSize(new Dimension(1000, 20));
        this.jButtonVerification3Point.setMinimumSize(new Dimension(147, 20));
        this.jButtonVerification3Point.setPreferredSize(new Dimension(110, 41));
        this.jButtonVerification3Point.addActionListener(evt -> this.jButtonVerificationActionPerformed(CalibrationVerificationType.THREE_POINT));
        this.add(this.jButtonVerification3Point);
        this.jButtonSaveCalibToFile.setText("Save calibration to file");
        this.jButtonSaveCalibToFile.setMaximumSize(new Dimension(1000, 20));
        this.jButtonSaveCalibToFile.setMinimumSize(new Dimension(147, 20));
        this.jButtonSaveCalibToFile.setPreferredSize(new Dimension(110, 41));
        this.jButtonSaveCalibToFile.addActionListener(evt -> this.jButtonSaveCalibrationToFile());
        this.add(this.jButtonSaveCalibToFile);
    }

    private void jButtonManActionPerformed() {
        this.manualRoutineSelected = true;
        this.dualRobotCalibMain.manNextStep(DualRobotCalibState.getLastState());
    }

    private void jButtonAutoActionPerformed() {
        this.autoRoutineSelected = true;
        this.dualRobotCalibMain.handleDualRobotCalibState(DualRobotCalibState.getLastState());
    }

    private ConfirmationMessage confirmZeroAllRobotsAtThisPosition() {
        return new ConfirmationMessage("Warning", "Zero all robot to this position", "Zero all robot to this position", this.textResource.cancel());
    }

    private void jButtonZeroActionPerformed() {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                DualRobotSelectRoutineCard.this.dualRobotCalibMain.sendCommandZero();
            }
        };
        this.dialogCreator.showConfirmationDialog(this.confirmZeroAllRobotsAtThisPosition(), listener);
    }

    private void jButtonDisconnectActionPerformed() {
        this.dualRobotCalibMain.sendCommandAutoDisconnect();
    }
}

