/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.forcetorque;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveTab;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.swing.CardPanel;
import com.ur.swing.FontFactory;
import com.ur.swing.URFontFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

@Singleton
public class FTCalibrationPanel
extends CardPanel {
    private final URFontFactory fontFactory;

    @Inject
    public FTCalibrationPanel(FontFactory fontFactory) {
        this.fontFactory = fontFactory;
        this.initComponents();
    }

    private void initComponents() {
        JPanel calibrationPanel = new JPanel();
        calibrationPanel.setLayout(new BoxLayout(calibrationPanel, 3));
        JPanel buttonPanel = this.createButtonPanel();
        calibrationPanel.add(buttonPanel);
        calibrationPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JLabel calibrationStatusLabel = this.createCalibrationStatusLabel();
        calibrationPanel.add(calibrationStatusLabel);
        calibrationPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel calibrationStatusPanel = this.createCalibrationStatusPanel();
        calibrationPanel.add(calibrationStatusPanel);
        JLabel checklist = FTCalibrationPanel.createCheckList();
        this.assemblePanel(calibrationPanel, checklist);
    }

    private void assemblePanel(JPanel calibrationPanel, JLabel checklist) {
        this.setLayout(new BorderLayout());
        this.setBorder((Border)new CardBorder("Force Torque Sensor Calibration"));
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(0, 2, 5, 5));
        gridPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        gridPanel.add(calibrationPanel);
        gridPanel.add(checklist);
        this.add(gridPanel);
    }

    private static JLabel createCheckList() {
        JLabel checklist = new JLabel();
        checklist.setText("<html>Before starting the FT sensor Calibration:<br><ul><li>Remove all external equipment from the robot arm.</li><li>Make sure the TCP is [0,0,0] and the Active Payload is 0 kg.</li><li>Press \"Set Calibration Position\" and move the arm to a convenient position with the tool aligned with gravity</li><li>Press \"Start Calibration\"</li><li>If a calibration already exists, you need to reset it before a new calibration can be made</li></ul></html>");
        checklist.setVerticalAlignment(1);
        return checklist;
    }

    private JLabel createCalibrationStatusLabel() {
        JLabel calibrationStatusLabel = new JLabel("Calibration Status");
        calibrationStatusLabel.setAlignmentX(0.5f);
        calibrationStatusLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, calibrationStatusLabel.getPreferredSize().height));
        Font boldFont = this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD);
        calibrationStatusLabel.setFont(boldFont);
        return calibrationStatusLabel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        Dimension dimension = new Dimension(Short.MAX_VALUE, 40);
        JButton setPositionButton = new JButton("Set Calibration Position");
        setPositionButton.setMaximumSize(dimension);
        setPositionButton.setAlignmentX(0.5f);
        setPositionButton.addActionListener(e -> this.flipManager.stackCurrentCardAndSwitchTo(MoveTab.class, (Object)this.createEmptyMoveCallback()));
        JButton resetCalibrationButton = new JButton("Reset Calibration");
        resetCalibrationButton.setMaximumSize(dimension);
        resetCalibrationButton.setAlignmentX(0.5f);
        JButton startCalibrationButton = new JButton("Start Calibration");
        startCalibrationButton.setMaximumSize(dimension);
        startCalibrationButton.setAlignmentX(0.5f);
        buttonPanel.add(setPositionButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(resetCalibrationButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(startCalibrationButton);
        return buttonPanel;
    }

    private JPanel createCalibrationStatusPanel() {
        JPanel calibrationStatusPanel = new JPanel();
        calibrationStatusPanel.setAlignmentX(0.5f);
        calibrationStatusPanel.setLayout(new BoxLayout(calibrationStatusPanel, 3));
        calibrationStatusPanel.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE), new EmptyBorder(5, 5, 5, 5)));
        Box calibrationValidStatusPanel = Box.createHorizontalBox();
        calibrationValidStatusPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, calibrationStatusPanel.getPreferredSize().height));
        calibrationValidStatusPanel.add(new JLabel("Valid calibration: "));
        JLabel yesLabel = new JLabel("Yes");
        yesLabel.setForeground(G5LookAndFeel.RUN_GREEN_FOREGROUND);
        calibrationValidStatusPanel.add(yesLabel);
        Box calibrationDatePanel = Box.createHorizontalBox();
        calibrationDatePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, calibrationStatusPanel.getPreferredSize().height));
        calibrationDatePanel.add(new JLabel("Date of calibration: "));
        LocalDate date = LocalDate.now();
        calibrationDatePanel.add(new JLabel(date.format(DateTimeFormatter.ISO_DATE)));
        calibrationStatusPanel.add(calibrationValidStatusPanel);
        calibrationStatusPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        calibrationStatusPanel.add(calibrationDatePanel);
        calibrationStatusPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        return calibrationStatusPanel;
    }

    private MoveCallback createEmptyMoveCallback() {
        return new MoveCallback(){

            public void onOk(Pose6d pose6d, JointPositionVector jointPositionVector, Pose6d pose6d1) {
            }

            public void onCancel() {
            }
        };
    }
}

