/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.internal;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class CalibrationImageResource {
    private static boolean isG5 = true;

    private CalibrationImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="toolAxisIllustration.png")
    public static Icon toolAxisIllustration() {
        return CalibrationImageResource.tryGetImage("toolAxisIllustration.png");
    }

    @Key(value="program-waypoint.png")
    public static Icon programWaypoint() {
        return CalibrationImageResource.tryGetImage("program-waypoint.png");
    }

    @Key(value="program-robot.png")
    public static Icon programRobot() {
        return CalibrationImageResource.tryGetImage("program-robot.png");
    }

    @Key(value="program-set.png")
    public static Icon programSet() {
        return CalibrationImageResource.tryGetImage("program-set.png");
    }

    @Key(value="program-waypoint-undefined.png")
    public static Icon programWaypointUndefined() {
        return CalibrationImageResource.tryGetImage("program-waypoint-undefined.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return CalibrationImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            CalibrationImageResource.tryGetImage("toolAxisIllustration.png");
            CalibrationImageResource.tryGetImage("program-waypoint.png");
            CalibrationImageResource.tryGetImage("program-robot.png");
            CalibrationImageResource.tryGetImage("program-set.png");
            CalibrationImageResource.tryGetImage("program-waypoint-undefined.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

