/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.persistence;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence;
import gui.installation.services.LookupServiceFacade;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EventlessInstallationLoader {
    private final EventManager eventManager;
    private final DialogCreator dialogCreator;

    @Inject
    public EventlessInstallationLoader(EventManager eventManager, DialogCreator dialogCreator) {
        this.eventManager = eventManager;
        this.dialogCreator = dialogCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Installation loadRobotInstallation(File programFile, ProgramRootNode program) {
        Installation installationLoaded = null;
        Subscription installationStateListenerSubscription = null;
        Subscription programEventListenerSubscription = null;
        try {
            installationStateListenerSubscription = this.eventManager.addVeto(InstallationStateListener.class);
            programEventListenerSubscription = this.eventManager.addVeto(ProgramEventListener.class);
            FileManagementProgramComponent fileManagement = (FileManagementProgramComponent)program.getComponent(FileManagementProgramComponent.class);
            String installationFileName = fileManagement.getInstallationFileName() + ".installation";
            File fileFirstTry = new File(fileManagement.getInstallationDirectory(), installationFileName);
            File fileSecondTry = new File(programFile.getParent(), installationFileName);
            if (fileFirstTry.exists()) {
                installationLoaded = RobotInstallationPersistence.load((File)fileFirstTry);
            } else if (fileSecondTry.exists()) {
                installationLoaded = RobotInstallationPersistence.load((File)fileSecondTry);
            }
            if (installationLoaded == null) {
                this.dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToFindRobotInstallation(((FileManagementProgramComponent)program.getComponent(FileManagementProgramComponent.class)).getInstallationFileName()), new OkDialogListener());
                installationLoaded = (Installation)LookupServiceFacade.get(Installation.class);
            }
        }
        catch (Exception e) {
            Log.error((String)"Could not load installation file: ", (Throwable)e);
        }
        finally {
            if (installationStateListenerSubscription != null) {
                installationStateListenerSubscription.dispose();
            }
            if (programEventListenerSubscription != null) {
                programEventListenerSubscription.dispose();
            }
        }
        return installationLoaded;
    }
}

