/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramTransCTPNode;
import com.ur.polyscope.calibration.internal.CalibrationImageResource;
import com.ur.polyscope.calibration.programcorrection.ProgramTransKeyPairCard;
import com.ur.swing.CardPanel;
import com.ur.swing.CompletedListener;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProgramTransCTPPositionCard
extends CardPanel {
    Provider<MainCalibration> mainCalibrationProvider = null;
    private double xValue = 0.0;
    private double yValue = 0.0;
    private double zValue = 0.0;
    private double xRollValue = 0.0;
    private double yRollValue = 0.0;
    private double zRollValue = 0.0;
    private ProgramTransCTPNode ctpNode = null;
    private JTextField xAxisTextField;
    private JTextField yAxisTextField;
    private JTextField zAxisTextField;
    private final DialogCreator dialogCreator;

    @Inject
    public ProgramTransCTPPositionCard(Provider<MainCalibration> mainCalibrationProvider, DialogCreator dialogCreator) {
        this.dialogCreator = dialogCreator;
        this.initComponents();
        this.mainCalibrationProvider = mainCalibrationProvider;
        this.calculateXYZValues();
        this.xAxisTextField.setHorizontalAlignment(4);
        this.yAxisTextField.setHorizontalAlignment(4);
        this.zAxisTextField.setHorizontalAlignment(4);
        this.xAxisTextField.setText(Units.convert_from_m((double)this.xValue));
        this.yAxisTextField.setText(Units.convert_from_m((double)this.yValue));
        this.zAxisTextField.setText(Units.convert_from_m((double)this.zValue));
        NumberFieldUtils.bindNumberPicker((JTextField)this.xAxisTextField, (CompletedListener)new CompletedListener.Template(){

            public void requestApply() {
                ProgramTransCTPPositionCard.this.xValue = Units.convert_to_m((double)ProgramTransCTPPositionCard.this.parseValue(ProgramTransCTPPositionCard.this.xAxisTextField, ProgramTransCTPPositionCard.this.xValue));
                ProgramTransCTPPositionCard.this.tcpUpdate();
            }
        }, (Mode)Mode.Standard);
        this.bindValidator(this.xAxisTextField, 10.0);
        NumberFieldUtils.bindNumberPicker((JTextField)this.yAxisTextField, (CompletedListener)new CompletedListener.Template(){

            public void requestApply() {
                ProgramTransCTPPositionCard.this.yValue = Units.convert_to_m((double)ProgramTransCTPPositionCard.this.parseValue(ProgramTransCTPPositionCard.this.yAxisTextField, ProgramTransCTPPositionCard.this.yValue));
                ProgramTransCTPPositionCard.this.tcpUpdate();
            }
        }, (Mode)Mode.Standard);
        this.bindValidator(this.yAxisTextField, 10.0);
        NumberFieldUtils.bindNumberPicker((JTextField)this.zAxisTextField, (CompletedListener)new CompletedListener.Template(){

            public void requestApply() {
                ProgramTransCTPPositionCard.this.zValue = Units.convert_to_m((double)ProgramTransCTPPositionCard.this.parseValue(ProgramTransCTPPositionCard.this.zAxisTextField, ProgramTransCTPPositionCard.this.zValue));
                ProgramTransCTPPositionCard.this.tcpUpdate();
            }
        }, (Mode)Mode.Standard);
        this.bindValidator(this.zAxisTextField, 10.0);
    }

    private void bindValidator(JTextField field, double maximum) {
        ValidationStrategy validator = ValidationFactory.getRangeValidator((double)(maximum * -1.0), (double)maximum, (UnitsConverter)Units.getMetersConverter());
        NumberFieldUtils.bindErrorValidator((JTextField)field, (ValidationStrategy)validator);
    }

    void tcpUpdate() {
        try {
            double[] tcptrans = new double[]{this.xValue, this.yValue, this.zValue, this.xRollValue, this.yRollValue, this.zRollValue};
            this.ctpNode.getwp().setCorrespondingToolTransformationOffset(tcptrans);
            ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().addKeyPairOnServer(this.ctpNode.getwp(), this.ctpNode.getQ2().getJoints());
        }
        catch (Exception e) {
            System.err.println("Write failed in TCPPositionTab:tcpUpdate");
        }
    }

    private void calculateXYZValues() {
        if (this.ctpNode == null) {
            return;
        }
        this.xValue = this.ctpNode.getwp().getCorrespondingToolTransformationOffset()[0];
        this.yValue = this.ctpNode.getwp().getCorrespondingToolTransformationOffset()[1];
        this.zValue = this.ctpNode.getwp().getCorrespondingToolTransformationOffset()[2];
        this.xRollValue = this.ctpNode.getwp().getCorrespondingToolTransformationOffset()[3];
        this.yRollValue = this.ctpNode.getwp().getCorrespondingToolTransformationOffset()[4];
        this.zRollValue = this.ctpNode.getwp().getCorrespondingToolTransformationOffset()[5];
    }

    public void enter(Object o) {
        super.enter(o);
        if (o instanceof ProgramTransCTPNode) {
            this.ctpNode = (ProgramTransCTPNode)o;
            this.calculateXYZValues();
            this.xAxisTextField.setText(Units.convert_from_m((double)this.xValue));
            this.yAxisTextField.setText(Units.convert_from_m((double)this.yValue));
            this.zAxisTextField.setText(Units.convert_from_m((double)this.zValue));
        }
    }

    public Object exit() {
        return super.exit();
    }

    double parseValue(JTextField field, double defaultValue) {
        if (ValidationFactory.getNumberValidator().isValid(field.getText())) {
            return PrimitiveUtils.parseDouble((String)field.getText());
        }
        this.dialogCreator.showErrorDialog(LanguagePack.getErrorMessages().validationError(ValidationFactory.getNumberValidator().getErrorMessage(field.getText())), null);
        field.setText(Units.convert_from_m((double)defaultValue));
        return defaultValue;
    }

    private void initComponents() {
        JPanel jPanel24 = new JPanel();
        JPanel settingTheCTPPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel20 = new JLabel();
        JPanel jPanel16 = new JPanel();
        JPanel jPanel18 = new JPanel();
        JLabel jLabel12 = new JLabel();
        this.xAxisTextField = new JTextField();
        JLabel jLabel13 = new JLabel();
        JPanel jPanel19 = new JPanel();
        JLabel jLabel14 = new JLabel();
        this.yAxisTextField = new JTextField();
        JLabel jLabel15 = new JLabel();
        JPanel jPanel20 = new JPanel();
        JLabel jLabel16 = new JLabel();
        this.zAxisTextField = new JTextField();
        JLabel jLabel17 = new JLabel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel17 = new JPanel();
        JLabel jLabel19 = new JLabel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JButton jButtonBack = new JButton();
        this.setLayout(new BorderLayout());
        jPanel24.setLayout(new BorderLayout());
        settingTheCTPPanel.setBorder(BorderFactory.createTitledBorder("Setting the Corresponding Tool Position"));
        settingTheCTPPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout(0, 5, 0));
        jLabel20.setText("CTP Coordinates");
        jLabel20.setHorizontalTextPosition(2);
        jPanel2.add(jLabel20);
        settingTheCTPPanel.add((Component)jPanel2, "First");
        jPanel16.setLayout(new BoxLayout(jPanel16, 1));
        jLabel12.setText("X:");
        jPanel18.add(jLabel12);
        this.xAxisTextField.setText("000000");
        this.xAxisTextField.setPreferredSize(new Dimension(60, 28));
        jPanel18.add(this.xAxisTextField);
        jLabel13.setText(Units.getText((String)"UNIT_mm"));
        jPanel18.add(jLabel13);
        jPanel16.add(jPanel18);
        jLabel14.setText("Y:");
        jPanel19.add(jLabel14);
        this.yAxisTextField.setText("000000");
        this.yAxisTextField.setPreferredSize(new Dimension(60, 28));
        jPanel19.add(this.yAxisTextField);
        jLabel15.setText(Units.getText((String)"UNIT_mm"));
        jPanel19.add(jLabel15);
        jPanel16.add(jPanel19);
        jLabel16.setText("Z:");
        jPanel20.add(jLabel16);
        this.zAxisTextField.setText("000000");
        this.zAxisTextField.setPreferredSize(new Dimension(60, 28));
        jPanel20.add(this.zAxisTextField);
        jLabel17.setText(Units.getText((String)"UNIT_mm"));
        jPanel20.add(jLabel17);
        jPanel16.add(jPanel20);
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 223, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 161, Short.MAX_VALUE));
        jPanel16.add(jPanel3);
        settingTheCTPPanel.add((Component)jPanel16, "West");
        jPanel17.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel17.setLayout(new BorderLayout(20, 20));
        jLabel19.setIcon(CalibrationImageResource.toolAxisIllustration());
        jPanel17.add((Component)jLabel19, "North");
        settingTheCTPPanel.add((Component)jPanel17, "Center");
        jPanel24.add((Component)settingTheCTPPanel, "Center");
        settingTheCTPPanel.getAccessibleContext().setAccessibleName("");
        this.add(jPanel24, "Center");
        this.add(jPanel14, "North");
        jPanel1.setPreferredSize(new Dimension(679, 40));
        jButtonBack.setText("OK");
        jButtonBack.addActionListener(evt -> this.jButtonBackActionPerformed());
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(636, Short.MAX_VALUE).addComponent(jButtonBack).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jButtonBack).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(jPanel1, "Last");
    }

    private void jButtonBackActionPerformed() {
        this.stackCurrentCardAndSwitchTo(ProgramTransKeyPairCard.class, this.ctpNode.getwp());
    }
}

