/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveTab;
import com.ur.move.automove.AutoMoveTab;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramTransCTPNode;
import com.ur.polyscope.calibration.ProgramTransKeyPairNode;
import com.ur.polyscope.calibration.programcorrection.ProgramTransCTPPositionCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransPanel;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.WidgetFactory;
import com.ur.swing.units.Units;
import com.ur.view.hmc.JointControllerRPC;
import gui.program.EntityFactory;
import gui.program.ProgramMetaDataComponent;
import gui.program.calibration.KinematicDataComponent;
import gui.program.position.WaypointNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.media.j3d.Transform3D;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class ProgramTransKeyPairCard
extends CardPanel {
    private static final int MARGIN = 10;
    private static final int MARGIN_LABELS = 20;
    private static final int FONT_SIZE = UIManager.getInt("SmallFontSize");
    private static final DecimalFormat f2 = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.00");
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final EntityFactory entityFactory;
    private final WidgetFactory widgetFactory;
    private final Provider<MainCalibration> mainCalibrationProvider;
    private Provider<RobotIdentification> robotIdentificationProvider;
    private RobotCanvas3D robotCanvas3D;
    private ProgramTransKeyPairNode wp = null;
    private WaypointNode teachWaypointNode = null;
    private JointPositionVector q2 = null;
    private ProgramVisualization programVisualizer;
    private JButton jButtonChangeCTP;
    private JButton jButtonMoveToNew;
    private JButton jButtonMoveToOld;
    private JButton jButtonReset;
    private JButton jButtonChangeWaypoint;
    private JLabel jLabelOldJointAngles;
    private JLabel jLabelOldJointAnglesValue;
    private JLabel jLabelNewJointAngles;
    private JLabel jLabelNewJointAnglesValue;
    private JLabel jLabelCTP;
    private JLabel jLabelWaypointTitle;
    private JLabel jLabelCTPValue;
    private JPanel robotPanel;
    private Provider<KinematicsCalibration> kinematicsProvider;
    private final JointControllerRPC jointControllerRPC;

    @Inject
    public ProgramTransKeyPairCard(Provider<MainCalibration> mainCalibrationProvider, WidgetFactory widgetFactory, RobotCanvas3DFactory robotCanvas3DFactory, EntityFactory entityFactory, Provider<RobotIdentification> robotIdentificationProvider, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, JointControllerRPC jointControllerRPC) {
        this.widgetFactory = widgetFactory;
        this.mainCalibrationProvider = mainCalibrationProvider;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.entityFactory = entityFactory;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.kinematicsProvider = calibrationRecipe.lastProvider();
        this.jointControllerRPC = jointControllerRPC;
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.jLabelWaypointTitle = new JLabel();
        this.updateWaypointLabel("");
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("Program Translation 3D Canvas");
        this.programVisualizer = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualizer.getElementNode());
        }
        this.robotPanel = new JPanel();
        this.robotPanel.setBorder(BorderFactory.createEtchedBorder());
        this.robotPanel.setMinimumSize(new Dimension(170, 170));
        this.robotPanel.setLayout(new BorderLayout());
        this.robotPanel.add(this.robotCanvas3D.getComponent());
        this.jButtonMoveToOld = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent evt) {
                ProgramTransKeyPairCard.this.jButtonMoveToOldActionPerformed();
            }
        });
        this.jButtonMoveToOld.setText("Move to old position");
        this.jLabelOldJointAngles = new JLabel();
        this.jLabelOldJointAngles.setFont(this.getFont().deriveFont(1, FONT_SIZE));
        this.jLabelOldJointAngles.setText("Old joint angles");
        this.jLabelOldJointAnglesValue = new JLabel();
        this.jLabelOldJointAnglesValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        String wideDummyJointAnglesValue = new JointPositionVector(-200.22, -200.22, -200.22, -200.22, -200.22, -200.22).toString();
        this.jLabelOldJointAnglesValue.setText(wideDummyJointAnglesValue);
        this.jButtonChangeWaypoint = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent evt) {
                ProgramTransKeyPairCard.this.jButtonChangeWaypointActionPerformed();
            }
        });
        this.jButtonChangeWaypoint.setText("Change this waypoint");
        this.jButtonMoveToNew = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent evt) {
                ProgramTransKeyPairCard.this.jButtonMoveToNewActionPerformed();
            }
        });
        this.jButtonMoveToNew.setText("Move robot here");
        this.jLabelNewJointAngles = new JLabel();
        this.jLabelNewJointAngles.setFont(this.getFont().deriveFont(1, FONT_SIZE));
        this.jLabelNewJointAngles.setText("New joint angles");
        this.jLabelNewJointAnglesValue = new JLabel();
        this.jLabelNewJointAnglesValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelNewJointAnglesValue.setText(wideDummyJointAnglesValue);
        this.jButtonChangeCTP = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent evt) {
                ProgramTransKeyPairCard.this.jButtonChangeCTPActionPerformed();
            }
        });
        this.jButtonChangeCTP.setText("Change CTP");
        this.jLabelCTP = new JLabel();
        this.jLabelCTP.setFont(this.getFont().deriveFont(1, FONT_SIZE));
        this.jLabelCTP.setText("Corresponding Tool Position:");
        this.jLabelCTPValue = new JLabel();
        this.jLabelCTPValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelCTPValue.setText("[0,0,0]");
        this.jButtonReset = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){

            public void actionPerformed(ActionEvent evt) {
                ProgramTransKeyPairCard.this.jButtonResetActionPerformed();
            }
        });
        this.jButtonReset.setText("Reset");
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 23;
        c.insets = new Insets(10, 10, 0, 0);
        this.add(this.jLabelWaypointTitle, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 0);
        this.add(this.robotPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 10, 5);
        this.add(this.createAndlayoutInfoPanel(), c);
        c.gridx = 1;
        c.gridy = 2;
        c.weighty = 1.0;
        c.insets = new Insets(20, 10, 10, 5);
        c.anchor = 25;
        this.add(this.jButtonReset, c);
    }

    private Component createAndlayoutInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.anchor = 23;
        infoPanel.add((Component)this.jButtonMoveToOld, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jLabelOldJointAngles, c);
        c.gridy = y++;
        c.insets = new Insets(10, 0, 0, 0);
        infoPanel.add((Component)this.jLabelOldJointAnglesValue, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jButtonChangeWaypoint, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jButtonMoveToNew, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jLabelNewJointAngles, c);
        c.gridy = y++;
        c.insets = new Insets(10, 0, 0, 0);
        infoPanel.add((Component)this.jLabelNewJointAnglesValue, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jButtonChangeCTP, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jLabelCTP, c);
        c.gridy = y++;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        infoPanel.add((Component)this.jLabelCTPValue, c);
        this.adjustLabelWidth();
        this.adjustButtonWidth();
        final int infoPanelHeight = infoPanel.getPreferredSize().height;
        this.robotPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = ProgramTransKeyPairCard.this.robotPanel.getWidth();
                int height = infoPanelHeight;
                int pageHeight = ProgramTransKeyPairCard.this.getHeight();
                int size = Math.min(width, pageHeight);
                if (size == width) {
                    size = Math.min(width, height);
                }
                ProgramTransKeyPairCard.this.robotPanel.setPreferredSize(new Dimension(size, size));
                ProgramTransKeyPairCard.this.robotPanel.setMinimumSize(new Dimension(size, size));
                ProgramTransKeyPairCard.this.robotPanel.setMaximumSize(new Dimension(size, size));
                ProgramTransKeyPairCard.this.revalidate();
            }
        });
        return infoPanel;
    }

    private void adjustLabelWidth() {
        Dimension dim = new Dimension(this.jLabelOldJointAnglesValue.getPreferredSize().width, this.jLabelOldJointAnglesValue.getPreferredSize().height);
        this.jLabelOldJointAnglesValue.setMinimumSize(dim);
        this.jLabelOldJointAnglesValue.setMaximumSize(dim);
        this.jLabelOldJointAnglesValue.setPreferredSize(dim);
    }

    private void adjustButtonWidth() {
        int maxWidth = 0;
        maxWidth = Math.max(this.jButtonChangeCTP.getPreferredSize().width, maxWidth);
        maxWidth = Math.max(this.jButtonMoveToNew.getPreferredSize().width, maxWidth);
        maxWidth = Math.max(this.jButtonMoveToOld.getPreferredSize().width, maxWidth);
        maxWidth = Math.max(this.jButtonChangeWaypoint.getPreferredSize().width, maxWidth);
        maxWidth = Math.max(this.jButtonReset.getPreferredSize().width, maxWidth);
        this.setWidth(this.jButtonChangeCTP, maxWidth);
        this.setWidth(this.jButtonMoveToNew, maxWidth);
        this.setWidth(this.jButtonMoveToOld, maxWidth);
        this.setWidth(this.jButtonChangeWaypoint, maxWidth);
        this.setWidth(this.jButtonReset, maxWidth);
    }

    private void setWidth(Component component, int width) {
        Dimension dim = new Dimension(width, component.getPreferredSize().height);
        component.setMinimumSize(dim);
        component.setMaximumSize(dim);
        component.setPreferredSize(dim);
    }

    public void enter(Object o) {
        Object tmp;
        super.enter(o);
        this.robotCanvas3D.setVisible(true);
        if (this.teachWaypointNode != null) {
            if (!this.teachWaypointNode.isUndefined() && this.wp != null && this.teachWaypointNode.getJointPositionVector() != null) {
                ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().addKeyPairOnServer(this.wp, this.teachWaypointNode.getJointPositionVector().getJoints());
            } else {
                System.err.println("Error in ProgramCorrecpondancePointNode enter, wp was null with teachWaypointNode not null");
            }
            this.teachWaypointNode = null;
        }
        if ((tmp = o) == null) {
            tmp = ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().getTree().getSelectionPath().getLastPathComponent();
        }
        if (tmp instanceof ProgramTransKeyPairNode) {
            this.wp = (ProgramTransKeyPairNode)tmp;
            this.update();
        }
    }

    private void update() {
        if (this.wp == null) {
            return;
        }
        if (this.wp.getRobot1JointPosition().isUndefined()) {
            this.jLabelOldJointAnglesValue.setText(" --- ");
            this.jLabelCTPValue.setText(" --- ");
        } else {
            this.jLabelOldJointAnglesValue.setText("[" + ProgramTransPanel.Rad2Degree(this.wp.getRobot1JointPosition()).toString(f2) + "] " + Units.getText().unitDegrees());
        }
        this.setVisibleNewJointAndCTP(false);
        this.jLabelNewJointAnglesValue.setText(" --- ");
        this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable());
        ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_CorrespondingKeyRequest(((KinematicDataComponent)this.wp.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), ((ProgramMetaDataComponent)this.wp.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification(), this.wp.getProgramTransProgramContainerNode().getPlaceName(), this.wp.getRobot1JointPosition().getJoints(), ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid(), (RobotIdentification)this.robotIdentificationProvider.get(), this.wp.getProgramTransProgramContainerNode().getPlaceName());
        this.updateWaypointLabel(this.wp.getName());
    }

    private void setVisibleNewJointAndCTP(boolean visible) {
        this.jButtonMoveToNew.setVisible(visible);
        this.jLabelNewJointAngles.setVisible(visible);
        this.jLabelNewJointAnglesValue.setVisible(visible);
        this.jLabelCTP.setVisible(visible);
        this.jLabelCTPValue.setVisible(visible);
        this.jButtonChangeCTP.setVisible(visible);
    }

    private void updateWaypointLabel(String value) {
        this.jLabelWaypointTitle.setText(String.format("Waypoint: %s", value));
    }

    public Object exit() {
        this.q2 = null;
        this.robotCanvas3D.setVisible(false);
        return super.exit();
    }

    public void updateRobot2JointPostion(int checksum1, RobotIdentification robotName1, String placename1, double[] q1, int checksum2, RobotIdentification robotName2, String placename2, double[] q2, double[] ctp, double residualError) {
        if (this.wp == null) {
            return;
        }
        if (checksum1 != ((KinematicDataComponent)this.wp.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid()) {
            return;
        }
        if (!placename1.equals(this.wp.getProgramTransProgramContainerNode().getPlaceName())) {
            return;
        }
        JointPositionVector tmpq1 = new JointPositionVector(q1);
        if (!tmpq1.equals(this.wp.getRobot1JointPosition())) {
            return;
        }
        if (checksum2 != ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid()) {
            return;
        }
        if (!placename2.equals(this.wp.getProgramTransProgramContainerNode().getPlaceName())) {
            return;
        }
        if (q2 == null) {
            return;
        }
        this.q2 = new JointPositionVector(q2);
        Pose6d tcp = this.jointControllerRPC.getTCPPose(this.q2);
        if (tcp == null && (tcp = this.jointControllerRPC.getTCPPose(this.q2)) == null) {
            return;
        }
        this.jLabelNewJointAnglesValue.setText("[" + ProgramTransPanel.Rad2Degree(this.q2).toString(f2) + "] " + Units.getText().unitDegrees());
        this.setVisibleNewJointAndCTP(true);
        this.wp.setCorrespondingToolTransformationOffset(ctp);
        this.jLabelCTPValue.setText("[" + Units.convert_from_m((double)this.wp.getCorrespondingToolTransformationOffset()[0]) + ", " + Units.convert_from_m((double)this.wp.getCorrespondingToolTransformationOffset()[1]) + ", " + Units.convert_from_m((double)this.wp.getCorrespondingToolTransformationOffset()[2]) + "] " + Units.getText().unitMm());
        Pose6d ctpOffset = new Pose6d(ctp);
        Transform3D tmp = Pose6dTransformUtils.getTransform3D((Pose6d)tcp);
        tmp.mul(Pose6dTransformUtils.getTransform3D((Pose6d)ctpOffset));
        JointPositionVector q2Final = this.q2;
        this.robotCanvas3D.addQueue((Runnable)new DrawGraphicsRunnable(q2Final));
    }

    private void jButtonChangeWaypointActionPerformed() {
        if (this.wp == null) {
            return;
        }
        Point3d CTP = new Point3d();
        CTP.add((Tuple3d)this.wp.getToolPosition(), (Tuple3d)this.wp.getCorrespondingToolOffset());
        this.teachWaypointNode = this.entityFactory.createWaypointNode();
        this.teachWaypointNode.setPositionNodeType(PositionNodeType.RELATIVE);
        this.teachWaypointNode.setRelativeFromPosition(this.wp.getRobot1JointPosition(), CTP, this.wp.getToolAxisAngle());
        this.stackCurrentCardAndSwitchTo(MoveTab.class, this.teachWaypointNode);
    }

    private void jButtonResetActionPerformed() {
        if (this.wp == null || this.q2 == null) {
            return;
        }
        ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().deleteKeyPairOnServer(this.wp, this.q2.getJoints());
        this.update();
    }

    private void jButtonMoveToOldActionPerformed() {
        if (this.wp == null) {
            return;
        }
        this.stackCurrentCardAndSwitchTo(AutoMoveTab.class, this.wp.getRobot1JointPosition());
    }

    private void jButtonMoveToNewActionPerformed() {
        if (this.q2 == null || this.wp == null) {
            return;
        }
        this.stackCurrentCardAndSwitchTo(AutoMoveTab.class, this.q2);
    }

    private void jButtonChangeCTPActionPerformed() {
        if (this.q2 == null || this.wp == null) {
            return;
        }
        ProgramTransCTPNode ctpChangeNode = new ProgramTransCTPNode(this.wp, this.q2);
        this.stackCurrentCardAndSwitchTo(ProgramTransCTPPositionCard.class, ctpChangeNode);
    }

    private class DrawGraphicsRunnable
    implements Runnable {
        private JointPositionVector q2Final;

        public DrawGraphicsRunnable(JointPositionVector q2Final) {
            this.q2Final = q2Final;
        }

        @Override
        public void run() {
            ProgramTransKeyPairCard.this.robotCanvas3D.setJointAngleVector(this.q2Final);
            ProgramTransKeyPairCard.this.robotCanvas3D.setRobotAttached(true);
            ProgramTransKeyPairCard.this.programVisualizer.clearVisualization();
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private UpdateGraphicsRunnable() {
        }

        @Override
        public void run() {
            ProgramTransKeyPairCard.this.robotCanvas3D.setRobotAttached(false);
            if (ProgramTransKeyPairCard.this.wp.getRobot1JointPosition() != null) {
                ProgramTransKeyPairCard.this.robotCanvas3D.setShadowRobotJointAngleVector(ProgramTransKeyPairCard.this.wp.getRobot1JointPosition());
                ProgramTransKeyPairCard.this.programVisualizer.clearVisualization();
            }
        }
    }
}

