/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.polyscope.calibration.BasicTreeNode;
import com.ur.polyscope.calibration.EmptyTreeNode;
import com.ur.polyscope.calibration.programcorrection.NotAWaypointCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransCTPPositionCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransKeyPairCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransProgramCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransSettingsAndOverviewTab;
import com.ur.swing.CardPanel;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramTransNodeTab
extends CardPanel {
    private static ProgramTransNodeTab tabInstance = null;
    private final FlippablePanel panel;
    ProgramTransKeyPairCard programTransKeyPairCard = null;
    private BasicTreeNode selectedTreeNode = null;
    private ProgramTransSettingsAndOverviewTab programTransSettingsAndOverviewTab = null;
    private ProgramTransProgramCard programTransProgramCard = null;
    private ProgramTransCTPPositionCard programTransCTPCard = null;

    @Inject
    public ProgramTransNodeTab(ProgramTransSettingsAndOverviewTab programTransSettingsAndOverviewTab, ProgramTransProgramCard programTransProgramCard, ProgramTransKeyPairCard programTransKeyPairCard, ProgramTransCTPPositionCard programTransCTPPositionCard) {
        this.programTransSettingsAndOverviewTab = programTransSettingsAndOverviewTab;
        this.programTransProgramCard = programTransProgramCard;
        this.programTransKeyPairCard = programTransKeyPairCard;
        this.programTransCTPCard = programTransCTPPositionCard;
        this.panel = new FlippablePanel();
        this.addCardPanels();
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.panel.setCardParent((CardPanel)this);
        if (tabInstance != null) {
            Log.debug((String)"Warning, CalibrationNodeTab was instantiated more than once!!!");
        }
        tabInstance = this;
    }

    public static ProgramTransNodeTab getInstance() {
        return tabInstance;
    }

    public String getName() {
        return this.toString();
    }

    public void enter(Object o) {
        super.enter(o);
        if (o == null) {
            this.panel.enterActiveChild((Object)this.selectedTreeNode);
        } else {
            this.switchToCurrentNode(o);
            this.panel.enterActiveChild(o);
        }
    }

    public Object exit() {
        this.panel.exitActiveChild();
        return super.exit();
    }

    public String toString() {
        return "Setup";
    }

    public void scaleToSize(Dimension dim) {
        this.panel.setMaximumSize(dim);
        this.panel.setPreferredSize(dim);
    }

    public void switchToCurrentNode(Object o) {
        if (o == null) {
            Log.debug((String)"Object is null while in ProgramTransNodeTab. This should not happen!");
        } else if (o instanceof BasicTreeNode) {
            this.selectedTreeNode = (BasicTreeNode)o;
            Class<? extends CardPanel> thisClass = this.selectedTreeNode.getCardClass();
            this.panel.switchTo(thisClass, o);
        }
    }

    private void addCardPanels() {
        this.panel.addCardPanel((CardPanel)new EmptyTreeNode());
        this.panel.addCardPanel((CardPanel)new NotAWaypointCard());
        this.panel.addCardPanel((CardPanel)this.programTransSettingsAndOverviewTab);
        this.panel.addCardPanel((CardPanel)this.programTransProgramCard);
        this.panel.addCardPanel((CardPanel)this.programTransKeyPairCard);
        this.panel.addCardPanel((CardPanel)this.programTransCTPCard);
    }
}

