/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.i18n.TextResource;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.calibration.BasicTreeNode;
import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.CalibrationTreeEvent;
import com.ur.polyscope.calibration.CalibrationTreeListener;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramTransKeyPairNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRoot;
import com.ur.polyscope.calibration.communication.ICalibProgramTransKeyMapReceived;
import com.ur.polyscope.calibration.communication.ICalibProgramTransSocketReceiveActionList;
import com.ur.polyscope.calibration.persistence.EventlessInstallationLoader;
import com.ur.polyscope.calibration.programcorrection.ProgramCorrectionHelper;
import com.ur.polyscope.calibration.programcorrection.ProgramTransNodeTab;
import com.ur.polyscope.calibration.view.ProgramCorrectionTreeCellRenderer;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.baseview.SidePlaceholders;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.flippable.FlippableTabbedPanel;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.Waiting;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.util.logging.Log;
import com.ur.view.hmc.HMC;
import gui.installation.services.LookupServiceFacade;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.ProgramRootNodeSave;
import gui.program.calibration.KinematicDataComponent;
import gui.program.position.WaypointNode;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import gui.tree.TreePanel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.vecmath.Point3d;

@Singleton
public class ProgramTransPanel
extends TreePanel
implements ICalibProgramTransSocketReceiveActionList,
TreeSelectionListener,
CalibrationTreeListener {
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private static final int CARD_PANEL_SPACE = UIManager.getInt("CardPanel.space");
    private static final double DEGREES_PER_RAD = 57.29577951308232;
    protected final Provider<MainCalibration> mainCalibrationProvider;
    private final EventlessInstallationLoader eventlessInstallationLoader;
    private final ProgramTransNodeTab programTransNodeTab;
    private final FlippableTabbedPanel selectedNodeTabbedPanel = new FlippableTabbedPanel();
    private final TaskMonitor taskMonitor;
    private Provider<RobotIdentification> robotIdentificationProvider;
    private ProgramRootNode programGoingToBeCorrected;
    private Installation installationFile;
    private String programGoingToBeCorrectedOldPlace;
    private String programGoingToBeCorrectedNewPlace;
    private boolean correctionInProgress;
    private boolean correctionFailed;
    private transient Vector<ICalibProgramTransKeyMapReceived> keyMapListeners = new Vector();
    private HashMap<JointPositionVector, JointPositionVector> reteachedWaypoints = new HashMap();
    private ProgramRootNodeSave programRootNodeSave;
    private Provider<KinematicsCalibration> kinematicsProvider;
    private final ViewContext viewContext;
    private final DialogCreator dialogCreator;

    @Inject
    public ProgramTransPanel(TaskMonitor taskMonitor, ViewContext viewContext, SidePlaceholders placeholders, Provider<MainCalibration> mainCalibrationProvider, EventlessInstallationLoader eventlessInstallationLoader, ProgramTransNodeTab programTransNodeTab, Provider<RobotIdentification> robotIdentificationProvider, ProgramRootNodeSave programRootNodeSave, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, ProgramCorrectionTreeCellRenderer programCorrectionTreeCellRenderer, DialogCreator dialogCreator) {
        super(viewContext, placeholders);
        this.mainCalibrationProvider = mainCalibrationProvider;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.programRootNodeSave = programRootNodeSave;
        this.viewContext = viewContext;
        this.dialogCreator = dialogCreator;
        this.resizeProgramTreeToWidth(360);
        this.taskMonitor = taskMonitor;
        this.eventlessInstallationLoader = eventlessInstallationLoader;
        this.programTransNodeTab = programTransNodeTab;
        this.kinematicsProvider = calibrationRecipe.lastProvider();
        this.selectedNodeTabbedPanel.addCardPanel((CardPanel)programTransNodeTab, programTransNodeTab.getName());
        this.selectedNodeTabbedPanel.setSelectedIndex(0);
        this.selectedNodeTabbedPanel.setCardParent((CardPanel)this);
        this.tree.setBackground(Color.WHITE);
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(programCorrectionTreeCellRenderer);
        this.getTreeView().setBorder((Border)BorderFactory.createMatteBorder(0, 0, 0, CARD_PANEL_SPACE, BETWEEN_CARD_COLOR));
        this.setBorder(BorderFactory.createLineBorder(BETWEEN_CARD_COLOR, CARD_PANEL_SPACE));
        this.insertComponentIntoPlaceholderPanel((JComponent)((Object)programTransNodeTab));
    }

    public static JointPositionVector Rad2Degree(JointPositionVector in) {
        JointPositionVector out = new JointPositionVector(in);
        out.scale(57.29577951308232);
        return out;
    }

    public void enter(Object o) {
        super.enter(o);
        if (CalibrationTreeContainer.getInstance() == null) {
            Log.error((String)"Error in Calibratin Panel, no calibration tree instance");
            return;
        }
        this.resetTreeSize();
        this.update();
        CalibrationTreeContainer.getInstance().addSomethingChangedListener(this);
        this.selectedNodeTabbedPanel.enterActiveChild(o);
    }

    private void update() {
        if (this.tree.getModel() != CalibrationTreeContainer.getInstance().getTreeModel()) {
            this.tree.setModel(CalibrationTreeContainer.getInstance().getTreeModel());
        }
        this.tree.setRootVisible(false);
        this.expandTree();
        if (this.tree.isSelectionEmpty()) {
            this.tree.setSelectionInterval(0, 0);
        }
        this.updateSaveIcon();
        this.treeNameLabel.setText(CalibrationTreeContainer.getInstance().getName());
    }

    public void updateSaveIcon() {
        if (CalibrationTreeContainer.getInstance().isSaved()) {
            this.setSaveEnabled(false);
        } else {
            this.setSaveEnabled(true);
        }
    }

    public Object exit() {
        if (CalibrationTreeContainer.getInstance() != null) {
            CalibrationTreeContainer.getInstance().removedSomethingChangedListener(this);
        }
        this.selectedNodeTabbedPanel.exitActiveChild();
        return super.exit();
    }

    @Override
    public void receiveRobotPlace(int checksum, String robotName, String[] places) {
    }

    @Override
    public void receiveReteachedWaypoints(HashMap<JointPositionVector, JointPositionVector> reteachedWaypoints) {
        this.reteachedWaypoints = reteachedWaypoints;
        this.updateTree();
    }

    private void updateTree() {
        SwingUtil.invokeLater(() -> {
            this.tree.invalidate();
            this.tree.repaint();
        });
    }

    @Override
    public void receiveCorrespondingKey(int checksum1, RobotIdentification robotName1, String placename1, double[] q1, int checksum2, RobotIdentification robotName2, String placename2, double[] q2, double[] ctp, double residualError) {
        SwingUtil.invokeLater(() -> this.programTransNodeTab.programTransKeyPairCard.updateRobot2JointPostion(checksum1, robotName1, placename1, q1, checksum2, robotName2, placename2, q2, ctp, residualError));
    }

    public void addKeyMapReceivedListener(ICalibProgramTransKeyMapReceived listener) {
        this.keyMapListeners.add(listener);
    }

    public void removedKeyMapReceivedListener(ICalibProgramTransKeyMapReceived listener) {
        this.keyMapListeners.removeElement(listener);
    }

    void keyMapReceivedEventTricker(ProgramTransOverviewRoot treerootEvt) {
        for (int i = 0; i < this.keyMapListeners.size(); ++i) {
            this.keyMapListeners.elementAt(i).keyMapReceived(treerootEvt);
        }
    }

    @Override
    public void receiveKeyMap(ProgramTransOverviewRoot treeroot) {
        SwingUtil.invokeLater(() -> this.keyMapReceivedEventTricker(treeroot));
    }

    public void correctFiles(String place1, String place2, Vector<File> fromFileNames, Vector<File> toFileNames) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        if (fromFileNames.size() != toFileNames.size()) {
            Log.error((String)"fromFileNames.size()!=toFileNames.size()");
        }
        for (int i = 0; i < fromFileNames.size(); ++i) {
            this.sendAndSetProgramGoingToBeCorrectedFromFile(place1, place2, fromFileNames.elementAt(i), toFileNames.elementAt(i));
            if (this.correctionFailed) break;
        }
        if (!this.correctionFailed) {
            this.dialogCreator.showMessageDialog(new DialogMessage(textResource.programCorrection(), textResource.programCorrectionDone()), MessageDialogType.MESSAGE, null);
        } else {
            this.dialogCreator.showMessageDialog(new DialogMessage(textResource.programCorrection(), textResource.programCorrectionFailed()), MessageDialogType.MESSAGE, null);
        }
    }

    public boolean correctProgram(String place1, String place2, File programFile, ProgramRootNode program) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.sendAndSetProgramGoingToBeCorrected(place1, place2, programFile, program);
        if (!this.correctionFailed && !this.correctionInProgress) {
            this.dialogCreator.showMessageDialog(new DialogMessage(textResource.programCorrection(), textResource.programCorrectionDone()), MessageDialogType.MESSAGE, null);
        } else {
            this.dialogCreator.showMessageDialog(new DialogMessage(textResource.programCorrection(), textResource.programCorrectionFailed()), MessageDialogType.MESSAGE, null);
        }
        if (this.correctionInProgress) {
            // empty if block
        }
        return !this.correctionFailed;
    }

    private void sendAndSetProgramGoingToBeCorrectedFromFile(String place1, String place2, File programFile, File newFileName) {
        if (this.correctionInProgress) {
            Log.error((String)"correctionInProgress allready running");
            return;
        }
        try {
            this.programGoingToBeCorrected = ProgramRootNodeLoad.loadWithOutKinematicCheckOrInstallation((File)programFile);
            this.installationFile = this.eventlessInstallationLoader.loadRobotInstallation(programFile, this.programGoingToBeCorrected);
            if (this.installationFile == null) {
                this.installationFile = (Installation)LookupServiceFacade.get(Installation.class);
            }
            this.programGoingToBeCorrected.setName(((FileManagementProgramComponent)this.programGoingToBeCorrected.getComponent(FileManagementProgramComponent.class)).setDirectoryAndExtractName(newFileName));
            this.sendAndSetProgramGoingToBeCorrected(place1, place2, programFile, this.programGoingToBeCorrected);
            this.programRootNodeSave.saveOnlyTheProgram(this.programGoingToBeCorrected);
        }
        catch (Exception e) {
            Log.error((String)"ProgramContainerNode.loadProgram() caugt exception: ", (Throwable)e);
        }
    }

    private void sendAndSetProgramGoingToBeCorrected(String place1, String place2, File programFile, ProgramRootNode program) {
        if (this.correctionInProgress) {
            Log.error((String)"correctionInProgress allready running");
            return;
        }
        try {
            this.correctionFailed = false;
            this.programGoingToBeCorrected = program;
            this.installationFile = this.eventlessInstallationLoader.loadRobotInstallation(programFile, this.programGoingToBeCorrected);
            if (this.installationFile == null) {
                this.installationFile = (Installation)LookupServiceFacade.get(Installation.class);
            }
            this.programGoingToBeCorrectedOldPlace = place1;
            this.programGoingToBeCorrectedNewPlace = place2;
            ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_CorrectProgramRequest(place1, place2, this.programGoingToBeCorrected);
            this.correctionInProgress = true;
            ParallelTask task = new ParallelTask(LanguagePack.getTextResource().correctingProgram()){

                public void run() {
                    Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                        public boolean itHappened() {
                            return !ProgramTransPanel.this.correctionInProgress;
                        }
                    }, (int)30, (TimeUnit)TimeUnit.MINUTES);
                }
            };
            this.taskMonitor.runAndWait((Task)task);
        }
        catch (Exception e) {
            Log.error((String)("ProgramContainerNode.loadProgram() caught exception: " + e));
        }
    }

    @Override
    public void endSocket() {
        this.correctionFailed = true;
        this.correctionInProgress = false;
    }

    @Override
    public List<String> receiveCorrectedProgramConfigurations(int checksum1, RobotIdentification robotName1, String place1, int checksum2, RobotIdentification robotName2, String place2, Vector<JointPositionVector> orginal, Vector<JointPositionVector> corrected) {
        ArrayList<String> skippedWaypoints = new ArrayList<String>();
        if (this.programGoingToBeCorrected == null) {
            return skippedWaypoints;
        }
        if (corrected.size() == 0) {
            this.correctionFailed = true;
        }
        if (checksum1 != ((KinematicDataComponent)ProgramRootNode.get((AbstractProgramNode)this.programGoingToBeCorrected).getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid() || checksum2 != ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid()) {
            Log.error((String)"receiveCorrectedProgramConfigurations failed, wrong checksum");
            this.correctionFailed = true;
        }
        if (!place1.equals(this.programGoingToBeCorrectedOldPlace) || !place2.equals(this.programGoingToBeCorrectedNewPlace)) {
            Log.error((String)"receiveCorrectedProgramConfigurations failed, wrong place name");
            this.correctionFailed = true;
        }
        if (this.correctionFailed) {
            this.correctionInProgress = false;
            return skippedWaypoints;
        }
        int i = 0;
        TCP tcp = ((TCPSettings)LookupServiceFacade.robotInstallationLookupService().getComponent(TCPSettings.class)).getSelectedTCP_Old();
        ToolPosition tcpOffset = tcp.getOffsetPose();
        tcp.setOffset(((TCPSettings)this.installationFile.getComponent(TCPSettings.class)).getSelectedTCP_Old().getOffsetPose());
        Enumeration e = this.programGoingToBeCorrected.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            JointPositionVector jointPositionVector;
            WaypointNode tmpWNode;
            AbstractProgramNode tmpNode;
            Object o = e.nextElement();
            if (!(o instanceof AbstractProgramNode) || !((tmpNode = (AbstractProgramNode)o) instanceof WaypointNode) || !ProgramCorrectionHelper.waypointIsEligibleForProgramCorrection(tmpWNode = (WaypointNode)tmpNode)) continue;
            if (!tmpWNode.getJointPositionVector().equals(orginal.get(i))) {
                Log.error((String)"receiveCorrectedProgramConfigurations failed, corresponding configuration do not match");
                Log.error((String)("org: " + orginal.get(i).toString()));
                Log.error((String)("new: " + tmpWNode.getJointPositionVector().toString()));
            }
            if (!(jointPositionVector = corrected.get(i)).isUndefined()) {
                for (int j = 0; j < 6; ++j) {
                    tmpWNode.getJointPositionVector().setJoint(j, jointPositionVector.getJoint(j));
                }
                Pose6d tcpPose = new HMC().getTCPPose(tmpWNode.getJointPositionVector());
                if (tcpPose != null && tcpPose.toArray() != null) {
                    double[] res = tcpPose.toArray();
                    tmpWNode.setPosition(tmpWNode.getJointPositionVector(), new Point3d(res[0], res[1], res[2]), new Point3d(res[3], res[4], res[5]));
                }
            } else {
                skippedWaypoints.add(tmpWNode.getName());
            }
            ++i;
        }
        tcp.setOffset(tcpOffset);
        ((KinematicDataComponent)this.programGoingToBeCorrected.getComponent(KinematicDataComponent.class)).setKinematics((KinematicsCalibration)this.kinematicsProvider.get());
        this.correctionInProgress = false;
        return skippedWaypoints;
    }

    public void addKeyPairOnServer(ProgramTransKeyPairNode node1, int checksum2, RobotIdentification robotName2, double[] q2, String waypointName, double[] ctp) {
        ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_AddKeyPair(((KinematicDataComponent)node1.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), ((ProgramMetaDataComponent)node1.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification(), node1.getProgramTransProgramContainerNode().getPlaceName(), node1.getRobot1JointPosition().getJoints(), checksum2, robotName2, node1.getProgramTransProgramContainerNode().getPlaceName(), q2, waypointName, ctp);
    }

    public void addKeyPairOnServer(ProgramTransKeyPairNode node1, double[] q2) {
        this.addKeyPairOnServer(node1, ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid(), (RobotIdentification)this.robotIdentificationProvider.get(), q2, node1.getProgramTransProgramContainerNode().getLoadedProgram().getName() + ", " + node1.getName(), node1.getCorrespondingToolTransformationOffset());
    }

    public void deleteKeyPairOnServer(ProgramTransKeyPairNode node1, int checksum2, RobotIdentification robotName2, double[] q2) {
        ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_RemoveKeyPair(((KinematicDataComponent)node1.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), ((ProgramMetaDataComponent)node1.getProgramTransProgramContainerNode().getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification(), node1.getProgramTransProgramContainerNode().getPlaceName(), node1.getRobot1JointPosition().getJoints(), checksum2, robotName2, node1.getProgramTransProgramContainerNode().getPlaceName(), q2);
    }

    public void deleteKeyPairOnServer(ProgramTransKeyPairNode node1, double[] q2) {
        this.deleteKeyPairOnServer(node1, ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid(), (RobotIdentification)this.robotIdentificationProvider.get(), q2);
    }

    protected void handleSaveIconMouseClicked(MouseEvent evt) {
        ((MainCalibration)this.mainCalibrationProvider.get()).saveCalibration();
    }

    protected void handleLoadIconMousePressed(MouseEvent evt) {
        ((MainCalibration)this.mainCalibrationProvider.get()).loadCalibration();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object node = e.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node instanceof BasicTreeNode) {
            if (this.programTransNodeTab.isVisible()) {
                this.programTransNodeTab.exit();
                this.programTransNodeTab.enter(node);
            } else {
                this.selectedNodeTabbedPanel.switchTo(ProgramTransNodeTab.class, node);
            }
        }
    }

    @Override
    public void somethingChanged(CalibrationTreeEvent e) {
        this.updateSaveIcon();
    }

    public boolean isReteached(JointPositionVector jointPositionVector) {
        return this.reteachedWaypoints.containsKey(jointPositionVector);
    }
}

