/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.lang.Defense;
import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.CalibrationTreeListener;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramTransProgramContainerNode;
import com.ur.polyscope.calibration.programcorrection.ProgramTransPanel;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.swing.CardPanel;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicDataComponent;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.TreeModel;

public class ProgramTransProgramCard
extends CardPanel {
    private final JTextField waypointNameTextField = new JTextField();
    private Provider<MainCalibration> mainCalibrationProvider = null;
    private ProgramTransProgramContainerNode programContainerNode = null;
    private boolean gettingNewPlaceName = false;
    private FileContainer textFileContainer;
    private CalibrationTreeListener calibrationTreeListener;
    private JLabel lblProgram;
    private JLabel lblInstallation;
    private JLabel lblSerialNumber;
    private JLabel lblChecksum;
    private JButton btnRemove;
    private JLabel lblError;

    @Inject
    public ProgramTransProgramCard(Provider<MainCalibration> mainCalibrationProvider) {
        this.initComponents();
        this.mainCalibrationProvider = mainCalibrationProvider;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        UIDefaults defaults = UIManager.getDefaults();
        Font boldFont = (Font)defaults.get("Header.font");
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(20, 50, 0, 0);
        JLabel programHeader = new JLabel("Program:");
        programHeader.setFont(boldFont);
        this.add(programHeader, c);
        c.gridy = 3;
        c.insets = new Insets(30, 50, 0, 0);
        JLabel installationHeader = new JLabel("Installation:");
        installationHeader.setFont(boldFont);
        this.add(installationHeader, c);
        c.gridy = 5;
        JLabel robotHeader = new JLabel("Robot:");
        robotHeader.setFont(boldFont);
        this.add(robotHeader, c);
        this.lblError = new JLabel();
        c.gridy = 8;
        c.anchor = 21;
        c.weighty = 1.0;
        this.add(this.lblError, c);
        this.lblProgram = new JLabel();
        c.gridx = 1;
        c.gridy = 2;
        c.weighty = 0.0;
        c.insets = new Insets(0, 100, 0, 0);
        c.anchor = 23;
        this.add(this.lblProgram, c);
        this.lblInstallation = new JLabel();
        c.gridy = 4;
        this.add(this.lblInstallation, c);
        this.lblSerialNumber = new JLabel();
        this.lblChecksum = new JLabel();
        c.gridy = 6;
        this.add(this.lblSerialNumber, c);
        c.gridy = 7;
        c.anchor = 23;
        this.add(this.lblChecksum, c);
        this.btnRemove = new JButton("Remove Program");
        this.btnRemove.addActionListener(evt -> this.btnRemoveActionPerformed());
        c.gridx = 3;
        c.gridy = 1;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.anchor = 24;
        c.insets = new Insets(20, 0, 0, 20);
        this.add(this.btnRemove, c);
    }

    public void enter(Object o) {
        Defense.notNull((Object)o, (String)"Cannot be null");
        Defense.isInstanceOf((Object)o, ProgramTransProgramContainerNode.class, (String)("Must be a " + ProgramTransProgramContainerNode.class + ", but was " + o));
        super.enter(o);
        this.programContainerNode = (ProgramTransProgramContainerNode)o;
        this.lblProgram.setText(this.programContainerNode.getLoadedProgram().getName());
        this.lblInstallation.setText(this.programContainerNode.getPlaceName());
        this.lblSerialNumber.setText("Serial Number: " + ((ProgramMetaDataComponent)this.programContainerNode.getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification());
        KinematicsCalibration kinematics = ((KinematicDataComponent)this.programContainerNode.getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics();
        this.lblChecksum.setText(String.format("Checksum: 0x%x", kinematics.getMergedChecksumIfValid()));
        this.lblError.setText(kinematics.isValidKinematics() ? "" : "From unknown robot with unknown kinematics");
        this.update();
        this.calibrationTreeListener = e -> this.btnRemove.setVisible(CalibrationTreeContainer.getInstance().containAny(ProgramTransProgramContainerNode.class));
        CalibrationTreeContainer.getInstance().addSomethingChangedListener(this.calibrationTreeListener);
    }

    public Object exit() {
        CalibrationTreeContainer.getInstance().removedSomethingChangedListener(this.calibrationTreeListener);
        return null;
    }

    private void update() {
        if (this.gettingNewPlaceName) {
            if (!this.waypointNameTextField.getText().equals("")) {
                String place = this.waypointNameTextField.getText();
                ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_AddRobotPlace(((KinematicDataComponent)this.programContainerNode.getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), ((ProgramMetaDataComponent)this.programContainerNode.getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification(), place);
            }
            this.gettingNewPlaceName = false;
        } else {
            ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_ListRobotPlaneRequest(((KinematicDataComponent)this.programContainerNode.getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), ((ProgramMetaDataComponent)this.programContainerNode.getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification());
        }
        if (this.textFileContainer != null) {
            Vector<File> from = new Vector<File>();
            Vector<File> to = new Vector<File>();
            File f = this.textFileContainer.getFile();
            if (f != null) {
                to.add(this.textFileContainer.getFile());
                ProgramRootNode programRootNode = this.programContainerNode.getLoadedProgram();
                from.add(((FileManagementProgramComponent)programRootNode.getComponent(FileManagementProgramComponent.class)).getFile(programRootNode));
                ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().correctFiles(this.programContainerNode.getPlaceName(), this.programContainerNode.getPlaceName(), from, to);
            }
            this.textFileContainer = null;
        } else {
            ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_ListRobotPlaneRequest(((KinematicDataComponent)this.programContainerNode.getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid(), ((ProgramMetaDataComponent)this.programContainerNode.getLoadedProgram().getComponent(ProgramMetaDataComponent.class)).getRobotIdentification());
        }
    }

    private void btnRemoveActionPerformed() {
        CalibrationTreeContainer.getInstance().removeNode(this.programContainerNode);
        ProgramTransPanel programTransPanel = ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel();
        programTransPanel.expandTree();
        JTree tree = programTransPanel.getTree();
        tree.requestFocus();
        tree.scrollRowToVisible(1);
        TreeModel model = tree.getModel();
        Object correctionModelNode = model.getChild(model.getRoot(), 0);
        programTransPanel.enter(correctionModelNode);
    }
}

