/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.lang.Defense;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramTransOverviewKeyPairNode;
import com.ur.polyscope.calibration.ProgramTransOverviewPlaceNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRobotPairNode;
import com.ur.polyscope.calibration.ProgramTransOverviewRoot;
import com.ur.polyscope.calibration.ProgramTransProgramContainerNode;
import com.ur.polyscope.calibration.ProgramTransSettingsAndOverviewNode;
import com.ur.polyscope.calibration.communication.ICalibProgramTransKeyMapReceived;
import com.ur.polyscope.calibration.persistence.EventlessInstallationLoader;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.units.Units;
import com.ur.util.logging.Log;
import com.ur.view.program.filemanager.ProgramFileManagerConfiguration;
import gui.program.calibration.KinematicDataComponent;
import gui.program.calibration.ProgramCorrectionKinematicStrategy;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

@Singleton
public class ProgramTransSettingsAndOverviewTab
extends CardPanel
implements TreeWillExpandListener,
TreeModelListener,
ICalibProgramTransKeyMapReceived {
    public static final int MARGIN = 10;
    private static final int MARGIN_LABELS = 20;
    private static final int FONT_SIZE = UIManager.getInt("SmallFontSize");
    private static final Border SCROLL_PANE_BORDER = UIManager.getBorder("ScrollPaneBorder");
    private final EventlessInstallationLoader eventlessInstallationLoader;
    private final Provider<MainCalibration> mainCalibrationProvider;
    private final RunningRobotRequirement runningRobotRequirement;
    private final FilePersistence filePersistence;
    private final DialogCreator dialogCreator;
    private Provider<RobotIdentification> robotIdentificationProvider;
    private FileContainer loadFileContainer = new FileContainer();
    private ProgramTransSettingsAndOverviewNode programTransSettingsAndOverviewNode = null;
    private WidgetFactory widgetFactory;
    private File currentSelection = null;
    private JButton jButtonAddProgram;
    private JButton jButtonDelete;
    private JLabel jLabelOverview;
    private JLabel jLabelCSOldRobot;
    private JLabel jLabelCSOldRobotValue;
    private JLabel jLabelCSThisRobot;
    private JLabel jLabelCSThisRobotValue;
    private JLabel jLabelCTP;
    private JLabel jLabelCTPtitle;
    private JLabel jLabelThisRobot;
    private JLabel jLabelOldRobot;
    private JLabel jLabelSNOldRobot;
    private JLabel jLabelSNOldRobotValue;
    private JLabel jLabelSNThisRobot;
    private JLabel jLabelSNThisRobotValue;
    private JScrollPane jScrollPane1;
    private JTree jTree;
    private GridBagConstraints gridBagConstraints;
    private Provider<KinematicsCalibration> kinematicsProvider;
    private ProgramCorrectionKinematicStrategy kinematicStrategy;

    @Inject
    public ProgramTransSettingsAndOverviewTab(FilePersistence filePersistence, WidgetFactory widgetFactory, Provider<MainCalibration> mainCalibrationProvider, EventlessInstallationLoader eventlessInstallationLoader, RunningRobotRequirement runningRobotRequirement, Provider<RobotIdentification> robotIdentificationProvider, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, ProgramCorrectionKinematicStrategy kinematicStrategy, DialogCreator dialogCreator) {
        this.filePersistence = filePersistence;
        this.widgetFactory = widgetFactory;
        this.mainCalibrationProvider = mainCalibrationProvider;
        this.runningRobotRequirement = runningRobotRequirement;
        this.eventlessInstallationLoader = eventlessInstallationLoader;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.kinematicStrategy = kinematicStrategy;
        this.dialogCreator = dialogCreator;
        this.kinematicsProvider = calibrationRecipe.lastProvider();
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.jTree = new JTree();
        this.jTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("JTree"){}));
        this.jTree.setRootVisible(false);
        this.jTree.addTreeSelectionListener(evt -> this.jTreeValueChanged());
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.setCellRenderer(new OverviewRenderer());
        this.jButtonAddProgram = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent evt) {
                ProgramTransSettingsAndOverviewTab.this.addProgramActionPerformed();
            }
        });
        this.jButtonAddProgram.setText(LanguagePack.getTextResource().loadProgram());
        this.jButtonAddProgram.setIcon(ViewImageResource.gtkAdd());
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setViewportView(this.jTree);
        this.jScrollPane1.setBorder(SCROLL_PANE_BORDER);
        this.jScrollPane1.setOpaque(false);
        this.jLabelOverview = new JLabel();
        this.jLabelOverview.setText("Overview of saved key-waypoints");
        this.jButtonDelete = new JButton();
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(evt -> this.jButtonDeleteActionPerformed());
        this.jLabelCTPtitle = new JLabel();
        this.jLabelCTPtitle.setFont(this.getFont().deriveFont(1, FONT_SIZE));
        this.jLabelCTPtitle.setText("Corresponding Tool Position:");
        this.jLabelCTP = new JLabel();
        this.jLabelCTP.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelCTP.setText("[0, 0, 0]");
        this.jLabelOldRobot = new JLabel();
        this.jLabelOldRobot.setFont(this.getFont().deriveFont(1, FONT_SIZE));
        this.jLabelOldRobot.setText("Old Robot:");
        this.jLabelSNOldRobot = new JLabel();
        this.jLabelSNOldRobot.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelSNOldRobot.setText("Serial Number:");
        this.jLabelCSOldRobot = new JLabel();
        this.jLabelCSOldRobot.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelCSOldRobot.setText("Checksum:");
        this.jLabelThisRobot = new JLabel();
        this.jLabelThisRobot.setFont(this.getFont().deriveFont(1, FONT_SIZE));
        this.jLabelThisRobot.setText("This Robot information:");
        this.jLabelSNThisRobot = new JLabel();
        this.jLabelSNThisRobot.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelSNThisRobot.setText("Serial Number:");
        this.jLabelCSThisRobot = new JLabel();
        this.jLabelCSThisRobot.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelCSThisRobot.setText("Checksum:");
        this.jLabelSNOldRobotValue = new JLabel();
        this.jLabelSNOldRobotValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelSNOldRobotValue.setText(" ");
        this.jLabelSNThisRobotValue = new JLabel();
        this.jLabelSNThisRobotValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelSNThisRobotValue.setText(" ");
        this.jLabelCSOldRobotValue = new JLabel();
        this.jLabelCSOldRobotValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelCSOldRobotValue.setText(" ");
        this.jLabelCSThisRobotValue = new JLabel();
        this.jLabelCSThisRobotValue.setFont(this.getFont().deriveFont(0, FONT_SIZE));
        this.jLabelCSThisRobotValue.setText(" ");
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.anchor = 23;
        this.gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add(this.jButtonAddProgram, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.weightx = 0.0;
        this.gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add(this.jLabelOverview, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.gridwidth = 5;
        this.gridBagConstraints.gridheight = 3;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        this.gridBagConstraints.fill = 1;
        this.add(this.jScrollPane1, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 6;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.gridheight = 1;
        this.gridBagConstraints.weightx = 0.0;
        this.gridBagConstraints.weighty = 0.0;
        this.gridBagConstraints.fill = 0;
        this.gridBagConstraints.anchor = 23;
        this.gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.createAndlayoutInfoPanel(), this.gridBagConstraints);
        this.gridBagConstraints.gridx = 6;
        this.gridBagConstraints.gridy = 3;
        this.gridBagConstraints.fill = 0;
        this.gridBagConstraints.anchor = 25;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add(this.jButtonDelete, this.gridBagConstraints);
    }

    private Component createAndlayoutInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.anchor = 23;
        infoPanel.add((Component)this.jLabelThisRobot, c);
        c.gridy = y++;
        c.insets = new Insets(5, 20, 0, 0);
        infoPanel.add((Component)this.jLabelSNThisRobot, c);
        c.gridy = y++;
        c.insets = new Insets(0, 40, 0, 0);
        infoPanel.add((Component)this.jLabelSNThisRobotValue, c);
        c.gridy = y++;
        c.insets = new Insets(0, 20, 0, 0);
        infoPanel.add((Component)this.jLabelCSThisRobot, c);
        c.gridy = y++;
        c.insets = new Insets(0, 40, 0, 0);
        infoPanel.add((Component)this.jLabelCSThisRobotValue, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jLabelOldRobot, c);
        c.gridy = y++;
        c.insets = new Insets(5, 20, 0, 0);
        infoPanel.add((Component)this.jLabelSNOldRobot, c);
        c.gridy = y++;
        c.insets = new Insets(0, 40, 0, 0);
        infoPanel.add((Component)this.jLabelSNOldRobotValue, c);
        c.gridy = y++;
        c.insets = new Insets(0, 20, 0, 0);
        infoPanel.add((Component)this.jLabelCSOldRobot, c);
        c.gridy = y++;
        c.insets = new Insets(0, 40, 0, 0);
        infoPanel.add((Component)this.jLabelCSOldRobotValue, c);
        c.gridy = y++;
        c.insets = new Insets(20, 0, 0, 0);
        infoPanel.add((Component)this.jLabelCTPtitle, c);
        c.gridy = y;
        c.insets = new Insets(0, 20, 0, 0);
        infoPanel.add((Component)this.jLabelCTP, c);
        JPanel containerPanel = new JPanel(new FlowLayout(0, 0, 0));
        containerPanel.add(infoPanel);
        containerPanel.setPreferredSize(new Dimension(this.jLabelCTPtitle.getPreferredSize().width, containerPanel.getPreferredSize().height));
        return containerPanel;
    }

    public String getName() {
        return this.toString();
    }

    public void enter(Object o) {
        Defense.notNull((Object)o, (String)"Cannot be null");
        Defense.isInstanceOf((Object)o, ProgramTransSettingsAndOverviewNode.class, (String)("Expected type to be " + ProgramTransSettingsAndOverviewNode.class + ", but was " + o.getClass()));
        super.enter(o);
        this.programTransSettingsAndOverviewNode = (ProgramTransSettingsAndOverviewNode)o;
        ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().addKeyMapReceivedListener(this);
        this.loadFile();
        this.sendProgramTransKeyPairMapRequest();
        this.updateInfo();
    }

    public Object exit() {
        ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().removedKeyMapReceivedListener(this);
        return super.exit();
    }

    private void loadFile() {
        if (this.loadFileContainer != null && this.loadFileContainer.hasFile()) {
            ProgramTransProgramContainerNode programContainerNode = new ProgramTransProgramContainerNode(this.eventlessInstallationLoader, ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel(), this.kinematicStrategy, this.kinematicsProvider);
            this.currentSelection = this.loadFileContainer.getFile();
            switch (programContainerNode.loadProgram(this.currentSelection)) {
                case MISSING_KINEMATICS: {
                    ErrorMessage em = new ErrorMessage("Error", "Missing kinematics information", "???");
                    this.dialogCreator.showErrorDialog(em, null);
                    Log.debug((String)("Failed to load file " + this.currentSelection));
                    break;
                }
                case MISSING_KINEMATICS_CHECKSUM: {
                    ErrorMessage em = new ErrorMessage("Error", "Missing kinematics checksum", "???");
                    this.dialogCreator.showErrorDialog(em, null);
                    Log.debug((String)("Failed to load file " + this.currentSelection));
                    break;
                }
                case FAILED_TO_LOAD: {
                    ErrorMessage em = new ErrorMessage("Error", "Controller not connected.", "Ensure the controller is running.");
                    this.dialogCreator.showErrorDialog(em, null);
                    Log.debug((String)("Failed to load file " + this.currentSelection));
                    break;
                }
                case SUCCESS: {
                    if (programContainerNode.isProgramForThisRobot((RobotIdentification)this.robotIdentificationProvider.get()) && ((KinematicDataComponent)programContainerNode.getLoadedProgram().getComponent(KinematicDataComponent.class)).getKinematics().getMergedChecksumIfValid() == ((KinematicsCalibration)this.kinematicsProvider.get()).getMergedChecksumIfValid()) {
                        ErrorMessage em = new ErrorMessage("Program Correction not Applicable", "Program Correction is not applicable when using the same robot the program was created on", "");
                        this.dialogCreator.showErrorDialog(em, null);
                        break;
                    }
                    CalibrationTreeContainer.getInstance().addNode(programContainerNode, this.programTransSettingsAndOverviewNode);
                    ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().expandTree();
                }
            }
        }
        this.loadFileContainer = null;
    }

    private void sendProgramTransKeyPairMapRequest() {
        KinematicsCalibration kinematicsCalibration = (KinematicsCalibration)this.kinematicsProvider.get();
        if (kinematicsCalibration != null) {
            ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_KeyPairMapRequest(kinematicsCalibration.getMergedChecksumIfValid(), (RobotIdentification)this.robotIdentificationProvider.get());
        }
    }

    @Override
    public void keyMapReceived(ProgramTransOverviewRoot treeRootNode) {
        super.resetAll();
        DefaultTreeModel model = new DefaultTreeModel(treeRootNode);
        this.jTree.setModel(model);
        this.expandTree();
        this.updateInfo();
    }

    public void expandTree() {
        for (int row = 0; row < this.jTree.getRowCount(); ++row) {
            this.jTree.expandRow(row);
        }
    }

    public GridBagConstraints getGridBagContrains() {
        return this.gridBagConstraints;
    }

    public void updateInfo() {
        Object selected = null;
        if (this.jTree.getSelectionPath() != null) {
            selected = this.jTree.getSelectionPath().getLastPathComponent();
        }
        if (selected instanceof ProgramTransOverviewKeyPairNode) {
            this.showAndUpdateInfoConfiguration((ProgramTransOverviewKeyPairNode)selected);
        } else if (selected instanceof ProgramTransOverviewRobotPairNode) {
            this.updateOldRobotInfo((ProgramTransOverviewRobotPairNode)selected);
            this.updateThisRobotInfo((ProgramTransOverviewRobotPairNode)selected);
            this.hideInfoConfiguration();
        } else if (selected instanceof ProgramTransOverviewPlaceNode) {
            this.showAndUpdateInfoRobotFromPlace((ProgramTransOverviewPlaceNode)selected);
            this.hideInfoConfiguration();
        } else {
            KinematicsCalibration kinematicsCalibration = (KinematicsCalibration)this.kinematicsProvider.get();
            if (kinematicsCalibration != null) {
                this.updateThisRobotInfo((RobotIdentification)this.robotIdentificationProvider.get(), kinematicsCalibration.getMergedChecksumIfValid());
            }
            this.hideOldRobotInfo();
            this.hideInfoConfiguration();
        }
        this.jButtonDelete.setEnabled(!this.jTree.getSelectionModel().isSelectionEmpty());
    }

    private void showAndUpdateInfoRobotFromPlace(ProgramTransOverviewPlaceNode place) {
        ProgramTransOverviewRobotPairNode robot = (ProgramTransOverviewRobotPairNode)place.getParent();
        this.updateOldRobotInfo(robot);
        this.updateThisRobotInfo(robot);
    }

    private void showAndUpdateInfoConfiguration(ProgramTransOverviewKeyPairNode keyPair) {
        ProgramTransOverviewPlaceNode place = (ProgramTransOverviewPlaceNode)keyPair.getParent();
        ProgramTransOverviewRobotPairNode robot = (ProgramTransOverviewRobotPairNode)place.getParent();
        this.updateOldRobotInfo(robot);
        this.updateThisRobotInfo(robot);
        this.jLabelCTPtitle.setVisible(true);
        this.jLabelCTP.setText("[" + Units.convert_from_m((double)keyPair.getCtp()[0]) + ", " + Units.convert_from_m((double)keyPair.getCtp()[1]) + ", " + Units.convert_from_m((double)keyPair.getCtp()[2]) + "] " + Units.getText().unitMm());
    }

    private void updateOldRobotInfo(ProgramTransOverviewRobotPairNode rpn) {
        this.jLabelSNOldRobot.setText("Serial Number:");
        this.jLabelSNOldRobotValue.setText(rpn.getRobotName1().getSerialNumber().getSerialNumber());
        this.jLabelCSOldRobot.setText("Checksum:");
        this.jLabelCSOldRobotValue.setText(String.format("0x%x", rpn.getChecksum1()));
        this.jLabelOldRobot.setVisible(true);
    }

    private void updateThisRobotInfo(ProgramTransOverviewRobotPairNode rpn) {
        this.updateThisRobotInfo(rpn.getRobotName2(), rpn.getChecksum2());
    }

    private void updateThisRobotInfo(RobotIdentification robotIdentification, int checksum) {
        this.jLabelSNThisRobot.setText("Serial Number:");
        this.jLabelSNThisRobotValue.setText(robotIdentification.getSerialNumber().getSerialNumber());
        this.jLabelCSThisRobot.setText("Checksum:");
        this.jLabelCSThisRobotValue.setText(String.format("0x%x", checksum));
    }

    private void hideOldRobotInfo() {
        this.jLabelSNOldRobot.setText("");
        this.jLabelSNOldRobotValue.setText("");
        this.jLabelCSOldRobot.setText("");
        this.jLabelCSOldRobotValue.setText("");
        this.jLabelOldRobot.setVisible(false);
    }

    private void hideInfoConfiguration() {
        this.jLabelCTPtitle.setVisible(false);
        this.jLabelCTP.setText("");
    }

    private void addProgramActionPerformed() {
        if (!this.runningRobotRequirement.checkAndNotify()) {
            return;
        }
        this.loadFileContainer = new FileContainer();
        this.loadFileContainer.setFile(this.currentSelection);
        this.filePersistence.openFile(this.loadFileContainer, (FileManagerConfiguration)new ProgramFileManagerConfiguration(LanguagePack.getTextResource().loadProgram()));
        this.sendProgramTransKeyPairMapRequest();
        ((MainCalibration)this.mainCalibrationProvider.get()).getProgramTransPanel().expandTree();
    }

    void deleteKeyPair(ProgramTransOverviewKeyPairNode keypair) {
        ProgramTransOverviewPlaceNode place = (ProgramTransOverviewPlaceNode)keypair.getParent();
        ProgramTransOverviewRobotPairNode robot = (ProgramTransOverviewRobotPairNode)place.getParent();
        ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_RemoveKeyPair(robot.getChecksum1(), robot.getRobotName1(), place.getRobotPlace1(), keypair.getQ1().getJoints(), robot.getChecksum2(), robot.getRobotName2(), place.getRobotPlace2(), keypair.getQ2().getJoints());
    }

    void deletePlace(ProgramTransOverviewPlaceNode place) {
        ProgramTransOverviewRobotPairNode robot = (ProgramTransOverviewRobotPairNode)place.getParent();
        ((MainCalibration)this.mainCalibrationProvider.get()).getSocket().sendPacketProgramTrans_RemoveRobotPlace(robot.getChecksum1(), robot.getRobotName1(), place.getRobotPlace1());
    }

    void deleteRobot(ProgramTransOverviewRobotPairNode robot) {
        Enumeration<TreeNode> e = robot.children();
        while (e.hasMoreElements()) {
            TreeNode tmp = e.nextElement();
            if (tmp instanceof ProgramTransOverviewPlaceNode) {
                this.deletePlace((ProgramTransOverviewPlaceNode)tmp);
                continue;
            }
            System.err.println("deleteRobot - wrong type");
        }
    }

    private void jButtonDeleteActionPerformed() {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                Object selected;
                Object object = selected = ProgramTransSettingsAndOverviewTab.this.jTree.getSelectionPath() == null ? null : ProgramTransSettingsAndOverviewTab.this.jTree.getSelectionPath().getLastPathComponent();
                if (selected == null) {
                    return;
                }
                if (selected instanceof ProgramTransOverviewKeyPairNode) {
                    ProgramTransSettingsAndOverviewTab.this.deleteKeyPair((ProgramTransOverviewKeyPairNode)selected);
                } else if (selected instanceof ProgramTransOverviewRobotPairNode) {
                    ProgramTransSettingsAndOverviewTab.this.deleteRobot((ProgramTransOverviewRobotPairNode)selected);
                } else if (selected instanceof ProgramTransOverviewPlaceNode) {
                    ProgramTransSettingsAndOverviewTab.this.deletePlace((ProgramTransOverviewPlaceNode)selected);
                }
                ProgramTransSettingsAndOverviewTab.this.sendProgramTransKeyPairMapRequest();
            }
        };
        this.dialogCreator.showConfirmationDialog(new ConfirmationMessage("Delete the Selected Key-waypoint?", "Deleting the key-waypoint removes it permanently.", "Delete Key-waypoint", "Cancel"), listener);
    }

    public Dimension getButtonDimension() {
        return this.jButtonDelete.getPreferredSize();
    }

    private void jTreeValueChanged() {
        this.updateInfo();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void treeNodesChanged(TreeModelEvent tme) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void treeNodesInserted(TreeModelEvent tme) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent tme) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void treeStructureChanged(TreeModelEvent tme) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return "Settings and Overview";
    }

    private static class OverviewRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private OverviewRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ProgramTransOverviewRobotPairNode || value instanceof ProgramTransOverviewPlaceNode) {
                this.setIcon(ViewImageResource.programFolder());
            } else if (value instanceof ProgramTransOverviewKeyPairNode) {
                this.setIcon(ViewImageResource.programWaypoint());
            }
            return this;
        }
    }
}

