/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.programcorrection;

import com.ur.polyscope.calibration.CalibrationTreeContainer;
import com.ur.polyscope.calibration.MainCalibration;
import com.ur.polyscope.calibration.ProgramRootNodeProgramCorrection;
import com.ur.polyscope.calibration.ProgramTransSettingsAndOverviewNode;
import com.ur.polyscope.calibration.internal.TextResource;
import com.ur.polyscope.calibration.programcorrection.ProgramCorrectionPanel;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.util.event.EventManager;
import com.ur.view.action.ShowProgramCorrectionScreenAction;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.polyscope.persistence.program.ProgramRootNodePersistence;
import gui.main.MainView;
import gui.polyscope.DashBoard;
import gui.polyscope.RunTab;
import gui.program.ProgramRootNode;
import gui.tools.DialogCreator;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Provider;

public class ToggleProgramCorrectionScreenAction
extends ShowScreenActionImpl
implements ShowProgramCorrectionScreenAction {
    private boolean isInProgramCorrectionMode = false;
    private final Provider<ProgramRootNode> programProvider;
    private Provider<ProgramRootNodeProgramCorrection> programCorrectionProvider;
    private final PasswordManager passwordManager;
    private GoToEnterPassword enterPassword;
    private final Provider<MainCalibration> mainCalibrationProvider;
    private final ProgramModeHolder programModeHolder;
    private boolean isPopupMenuAction;
    private CardPanel returnCard;
    private final TextResource textResource;
    private final DialogCreator dialogCreator;
    private ProgramRootNodePersistence programRootNodePersistence;

    @Inject
    ToggleProgramCorrectionScreenAction(Provider<ProgramRootNode> programProvider, Provider<ProgramRootNodeProgramCorrection> programCorrectionProvider, MainView mainPanel, PasswordManager passwordManager, GoToEnterPassword enterPassword, Provider<MainCalibration> mainCalibrationProvider, ProgramModeHolder programModeHolder, EventManager eventManager, TextResource textResource, ProgramRootNodePersistence programRootNodePersistence, DialogCreator dialogCreator) {
        super(ProgramCorrectionPanel.class, (FlipManager)mainPanel, false);
        this.programProvider = programProvider;
        this.programCorrectionProvider = programCorrectionProvider;
        this.passwordManager = passwordManager;
        this.enterPassword = enterPassword;
        this.mainCalibrationProvider = mainCalibrationProvider;
        this.programModeHolder = programModeHolder;
        this.textResource = textResource;
        this.programRootNodePersistence = programRootNodePersistence;
        this.dialogCreator = dialogCreator;
        eventManager.addStrongListener(AccessControlStateListener.class, (oldState, currentState) -> {
            if (currentState.getOperationalMode() == OperationalMode.AUTOMATIC) {
                SwingUtil.invokeLater(() -> this.doLeave(RunTab.class));
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isInProgramCorrectionMode && this.isPopupMenuAction) {
            this.leaveProgramCorrectionMode();
        } else {
            this.enterProgramCorrectionMode();
        }
    }

    public void setPopupMenuAction(boolean popupMenuAction) {
        this.isPopupMenuAction = popupMenuAction;
    }

    private void leaveProgramCorrectionMode() {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                ToggleProgramCorrectionScreenAction.this.doLeave();
            }
        };
        this.dialogCreator.showConfirmationDialog(new ConfirmationMessage(this.textResource.exitProgramCorrection(), this.textResource.exitProgramCorrectionDescription(), this.textResource.ok(), this.textResource.cancel()), listener);
    }

    private void doLeave() {
        this.doLeave(this.returnCard.getClass());
    }

    private void doLeave(Class<? extends CardPanel> cardPanel) {
        this.isInProgramCorrectionMode = false;
        if (this.isCurrentProgramProgramCorrectionPlaceholder()) {
            this.resetProgram();
        }
        this.programModeHolder.setMode(ProgramModeHolder.ProgramMode.ReadOnly);
        this.putValue("Name", this.textResource.tabProgramCorrection());
        this.getFlipManager().getSwitchSupport().resetAll();
        this.getFlipManager().switchTo(cardPanel);
    }

    private void resetProgram() {
        DashBoard.setProgram((ProgramRootNode)((ProgramRootNode)this.programProvider.get()));
    }

    private boolean isCurrentProgramProgramCorrectionPlaceholder() {
        return ProgramRootNode.get((AbstractProgramNode)DashBoard.getProgram()) instanceof ProgramRootNodeProgramCorrection;
    }

    private void enterProgramCorrectionMode() {
        if (this.isPopupMenuAction) {
            Runnable okAction = () -> this.requestLogin();
            this.programRootNodePersistence.requestToSaveUnsavedProgramChanges(okAction);
        } else {
            this.doSwitchToProgramCorrectionScreen();
        }
    }

    private void requestLogin() {
        this.returnCard = this.getFlipManager().getCurrentCard();
        if (this.passwordManager.isPasswordDefined(PasswordManager.Lock.HARDCODED)) {
            this.enterPassword.requestPassword(PasswordManager.Lock.HARDCODED, new PasswordLoginListener(){

                public void onLoginSuccess() {
                    ToggleProgramCorrectionScreenAction.this.enableProgramCorrectionMode();
                    ToggleProgramCorrectionScreenAction.this.doSwitchToProgramCorrectionScreen();
                }

                public void onLoginFailure() {
                }
            });
        } else {
            this.doSwitchToProgramCorrectionScreen();
        }
    }

    private void doSwitchToProgramCorrectionScreen() {
        super.actionPerformed(null);
    }

    private void enableProgramCorrectionMode() {
        this.isInProgramCorrectionMode = true;
        DashBoard.setProgram((ProgramRootNode)((ProgramRootNode)this.programCorrectionProvider.get()));
        if (this.isPopupMenuAction) {
            this.putValue("Name", this.textResource.exit());
        }
        this.programModeHolder.setMode(ProgramModeHolder.ProgramMode.Calibration);
        ((MainCalibration)this.mainCalibrationProvider.get()).startBackend();
        ProgramTransSettingsAndOverviewNode rootNode = new ProgramTransSettingsAndOverviewNode();
        CalibrationTreeContainer.newInstance(rootNode, "Program correction");
    }
}

