/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RescaleOp;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class IconConverter {
    private static final boolean USE_GRAY = UIManager.getBoolean("TreeRenderer.useGray");
    private static final float BRIGHT_FACTOR = ((Float)UIManager.get("TreeRenderer.brightFactor")).floatValue();

    private IconConverter() {
    }

    public static Icon convert(Icon icon) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(new Color(255, 255, 255, 255));
        g2d.fillRect(0, 0, w, h);
        icon.paintIcon(null, g2d, 0, 0);
        if (USE_GRAY) {
            ColorConvertOp op1 = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            image = op1.filter(image, null);
        }
        if (BRIGHT_FACTOR > 0.0f) {
            RescaleOp op2 = new RescaleOp(BRIGHT_FACTOR, 128.0f, null);
            image = op2.filter(image, null);
        }
        return new ImageIcon(image);
    }
}

